/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import java.io.File;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.internal.debug.core.sourcelookup.PSourceNotFoundElement;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PDebugUIUtils {
    public static String arrayToString(int[] array) {
        if (array.length == 0) {
            return "";
        }
        String msg = "";
        int preTask = array[0];
        msg = String.valueOf(msg) + preTask;
        boolean isContinue = false;
        int i = 1;
        while (i < array.length) {
            if (preTask == array[i] - 1) {
                preTask = array[i];
                isContinue = true;
                if (i == array.length - 1) {
                    msg = String.valueOf(msg) + "-" + array[i];
                    break;
                }
            } else {
                if (isContinue) {
                    msg = String.valueOf(msg) + "-" + preTask;
                }
                msg = String.valueOf(msg) + "," + array[i];
                isContinue = false;
                preTask = array[i];
            }
            ++i;
        }
        return msg;
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static IPStackFrame getCurrentStackFrame() {
        IAdaptable context = DebugUITools.getDebugContext();
        return context != null ? (IPStackFrame)context.getAdapter(IPStackFrame.class) : null;
    }

    public static String getEditorId(IEditorInput input, Object element) {
        if (element instanceof PSourceNotFoundElement) {
            return ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
        }
        if (input != null) {
            return PDebugUIUtils.getEditorId(input);
        }
        return null;
    }

    public static String getEditorId(Object element) {
        String name = null;
        if (element instanceof IFile) {
            name = ((IFile)element).getName();
        }
        if (element instanceof IEditorInput) {
            name = ((IEditorInput)element).getName();
        }
        if (name != null) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            return descriptor != null ? descriptor.getId() : "org.eclipse.cdt.ui.editor.CEditor";
        }
        return ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
    }

    public static IEditorInput getEditorInput(Object element) {
        IResource resource;
        if (element instanceof IMarker && (resource = ((IMarker)element).getResource()) instanceof IFile) {
            return new FileEditorInput((IFile)resource);
        }
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof IPBreakpoint) {
            IFile file;
            IPBreakpoint b;
            block14: {
                b = (IPBreakpoint)element;
                file = null;
                try {
                    Path path;
                    String handle = b.getSourceHandle();
                    if (handle == null || !(path = new Path(handle)).isValidPath(handle)) break block14;
                    IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
                    if (files.length > 0) {
                        file = files[0];
                        IProject project = b.getMarker().getResource().getProject();
                        IFile[] iFileArray = files;
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile f = iFileArray[n2];
                            if (f.getProject().equals((Object)project)) {
                                file = f;
                                break block14;
                            }
                            ++n2;
                        }
                        break block14;
                    }
                    File fsfile = new File(handle);
                    if (fsfile.isFile() && fsfile.exists()) {
                        IProject project = b.getMarker().getResource().getProject();
                        if (project != null) {
                            ICProject cproject = CoreModel.getDefault().create(project);
                            String id = CoreModel.getRegistedContentTypeId((IProject)project, (String)path.lastSegment());
                            ExternalTranslationUnit tu = new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)path), id);
                            return new ExternalEditorInput((ITranslationUnit)tu);
                        }
                        return new ExternalEditorInput((IPath)path);
                    }
                }
                catch (CoreException coreException) {}
            }
            if (file == null) {
                file = (IFile)b.getMarker().getResource().getAdapter(IFile.class);
            }
            if (file != null) {
                return new FileEditorInput(file);
            }
        }
        if (element instanceof LocalFileStorage) {
            return new ExternalEditorInput(((IStorage)element).getFullPath());
        }
        if (element instanceof PSourceNotFoundElement) {
            return new CommonSourceNotFoundEditorInput(element);
        }
        return null;
    }

    public static void main(String[] args) {
        TaskSet tasks = new TaskSet(0);
        System.out.println(PDebugUIUtils.showBitList(tasks));
    }

    public static String showBitList(TaskSet tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return "";
        }
        return PDebugUIUtils.arrayToString(tasks.toArray());
    }
}

