/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui.widgets;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryDialog;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class LSFQueryControl
extends Composite {
    protected String[] columnLabels;
    protected Vector<String[]> commandResponse;
    protected LSFQueryDialog dialog;
    private final List<ModifyListener> modifyListeners = new LinkedList<ModifyListener>();
    protected String selectedValues = "";

    public LSFQueryControl(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd.getStyle());
        this.setLayout((Layout)new FillLayout());
        this.setLayoutData(wd.getLayoutData());
        Button button = new Button((Composite)this, 8);
        button.setText(wd.getFixedText());
        button.setToolTipText(wd.getToolTipText());
        this.commandResponse = new Vector();
        this.configureQueryButton(button, wd.getRemoteConnection());
    }

    public void addModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.modifyListeners.add(listener);
    }

    protected abstract void configureQueryButton(Button var1, IRemoteConnection var2);

    protected abstract boolean getQueryResponse(IRemoteConnection var1);

    public String getSelectedValue() {
        return this.selectedValues;
    }

    protected void notifyListeners() {
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(null);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.modifyListeners.remove(listener);
    }

    public void setSelectedValues(String value) {
        this.selectedValues = value;
    }

    public boolean widgetSelected() {
        return this.selectedValues != null;
    }
}

