/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui.widgets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryControl;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryDialog;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class QueueQueryControl
extends LSFQueryControl {
    public QueueQueryControl(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd);
    }

    @Override
    protected void configureQueryButton(Button button, final IRemoteConnection connection) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (QueueQueryControl.this.getQueryResponse(connection)) {
                    QueueQueryControl.this.dialog = new LSFQueryDialog(QueueQueryControl.this.getShell(), Messages.QueueQueryControl_0, QueueQueryControl.this.columnLabels, QueueQueryControl.this.commandResponse, true);
                    QueueQueryControl.this.dialog.setSelectedValue(QueueQueryControl.this.selectedValues);
                    int selection = QueueQueryControl.this.dialog.open();
                    if (selection == 0) {
                        QueueQueryControl.this.selectedValues = QueueQueryControl.this.dialog.getSelectedValues();
                        QueueQueryControl.this.notifyListeners();
                    }
                }
            }
        });
    }

    @Override
    protected boolean getQueryResponse(IRemoteConnection connection) {
        IRemoteServices remoteServices = connection.getRemoteServices();
        IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, new String[]{"bqueues", "-w"});
        IRemoteProcess process = null;
        try {
            process = processBuilder.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (process.exitValue() == 0) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String data = reader.readLine();
                boolean headerLine = true;
                this.commandResponse.clear();
                while (data != null) {
                    if (headerLine) {
                        this.columnLabels = data.split(" +");
                        headerLine = false;
                    } else {
                        data = data.replaceAll(" +/ +", "/");
                        String[] columnData = data.split(" +");
                        this.commandResponse.add(columnData);
                    }
                    data = reader.readLine();
                }
                reader.close();
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error querying queues:\n" + e.getMessage()));
            return false;
        }
        return true;
    }
}

