/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.ptp.rm.lml.ui.providers.support.BorderLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ImageComp
extends Composite {
    private Image image;
    private static HashMap<URL, Image> urlToImage = new HashMap();
    private double prefWidth;
    private double prefHeight;

    public static void disposeAll() {
        for (Image image : urlToImage.values()) {
            image.dispose();
        }
        urlToImage.clear();
    }

    public ImageComp(Composite parent, int style, URL imageUrl, double width, double height) throws IOException {
        super(parent, style);
        if (urlToImage.containsKey(imageUrl)) {
            this.init(urlToImage.get(imageUrl));
        } else {
            Image image = new Image((Device)Display.getCurrent(), imageUrl.openConnection().getInputStream());
            urlToImage.put(imageUrl, image);
            this.init(image);
        }
        this.setPreferredPercentageSize(width, height);
    }

    public Point computeSize(int width, int height) {
        return this.computeSize(width, height, true);
    }

    public Point computeSize(int cWidth, int cHeight, boolean changed) {
        Point point = this.getParent().getSize();
        double width = 0.0;
        double height = 0.0;
        BorderLayout.BorderData layoutData = (BorderLayout.BorderData)this.getLayoutData();
        if (layoutData.field == 1 || layoutData.field == 7) {
            height = (double)point.y * this.prefHeight;
        }
        if (layoutData.field == 5 || layoutData.field == 3) {
            width = (double)point.x * this.prefWidth;
        }
        return new Point((int)Math.round(width), (int)Math.round(height));
    }

    public int getAlignment() {
        if (this.getLayoutData() instanceof BorderLayout.BorderData) {
            return ((BorderLayout.BorderData)this.getLayoutData()).field;
        }
        return -1;
    }

    public Image getImage() {
        return this.image;
    }

    public void setPreferredPercentageSize(double width, double height) {
        this.prefWidth = width;
        this.prefHeight = height;
    }

    protected void init(Image img) {
        this.setLayout((Layout)new FillLayout());
        this.image = img;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(ImageComp.this.image, 0, 0, ((ImageComp)ImageComp.this).image.getBounds().width, ((ImageComp)ImageComp.this).image.getBounds().height, 0, 0, ImageComp.this.getSize().x, ImageComp.this.getSize().y);
            }
        });
    }
}

