/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rephraserengine.core.vpg.IVPGComponentFactory;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.Messages;

public final class VPGLog<T, R extends IVPGNode<T>> {
    protected final File logFile;
    protected IVPGComponentFactory<?, T, R> locator;
    protected List<Entry> log = new ArrayList<Entry>();
    private Set<ILogListener> listeners = new HashSet<ILogListener>();
    private static final String EOL = System.getProperty("line.separator");
    private static final String EOL_ESCAPE = "&EOL;";

    public VPGLog(File logFile, IVPGComponentFactory<?, T, R> locator) {
        this.logFile = logFile;
        this.locator = locator;
    }

    public void clear() {
        this.log.clear();
        this.notifyListeners();
    }

    public void clearEntriesFor(String filename) {
        LinkedList<Entry> newLog = new LinkedList<Entry>();
        int i = 0;
        while (i < this.log.size()) {
            Entry entry = this.log.get(i);
            Object tokenRef = entry.getTokenRef();
            if (tokenRef == null || !tokenRef.getFilename().equals(filename)) {
                newLog.add(entry);
            }
            ++i;
        }
        this.log = newLog;
        this.notifyListeners();
    }

    public void logWarning(String message) {
        this.log.add(new Entry(this, true, message, null));
        this.notifyListeners();
    }

    public void logWarning(String message, String filename) {
        this.log.add(new Entry(this, true, message, this.locator.getVPGNode(filename, 0, 0)));
        this.notifyListeners();
    }

    public void logWarning(String message, R tokenRef) {
        this.log.add(new Entry(this, true, message, tokenRef));
        this.notifyListeners();
    }

    public void logError(Throwable e) {
        this.logError(e, null);
    }

    public void logError(Throwable e, R tokenRef) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName());
        sb.append(": ");
        sb.append(e.getMessage());
        sb.append("\n");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bs));
        sb.append(bs);
        this.log.add(new Entry(this, false, sb.toString(), tokenRef));
        this.notifyListeners();
    }

    public void logError(String message) {
        this.log.add(new Entry(this, false, message, null));
        this.notifyListeners();
    }

    public void logError(String message, R tokenRef) {
        this.log.add(new Entry(this, false, message, tokenRef));
        this.notifyListeners();
    }

    public boolean hasErrorsLogged() {
        int i = 0;
        while (i < this.log.size()) {
            if (this.log.get(i).isError()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasErrorsOrWarningsLogged() {
        return !this.log.isEmpty();
    }

    public List<Entry> getEntries() {
        return this.log;
    }

    public void printOn(PrintStream out) {
        int i = 0;
        while (i < this.log.size()) {
            Entry entry = this.log.get(i);
            out.print(entry.isError() ? Messages.VPGLog_ErrorLabel : Messages.VPGLog_WarningLabel);
            out.println(entry.getMessage());
            Object t = entry.getTokenRef();
            if (t != null) {
                out.print(Messages.bind((String)Messages.VPGLog_FilenameOffsetLength, (Object[])new Object[]{t.getFilename(), t.getOffset(), t.getLength()}));
            }
            ++i;
        }
    }

    public void addLogListener(ILogListener listener) {
        this.listeners.add(listener);
        listener.onLogChange();
    }

    public void removeLogListener(ILogListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ILogListener listener : this.listeners) {
            listener.onLogChange();
        }
    }

    public void writeToFile() throws IOException {
        BufferedWriter output = new BufferedWriter(new FileWriter(this.logFile));
        try {
            IVPGNode tokenRef = null;
            int i = 0;
            while (i < this.log.size()) {
                Entry entry = this.log.get(i);
                output.write(String.valueOf(Boolean.toString(entry.isWarning())) + EOL);
                tokenRef = (IVPGNode)entry.getTokenRef();
                if (tokenRef == null) {
                    output.write(EOL);
                } else {
                    output.write(String.valueOf(tokenRef.getFilename()) + "," + Integer.toString(tokenRef.getOffset()) + "," + Integer.toString(tokenRef.getLength()) + EOL);
                }
                output.write(String.valueOf(entry.getMessage().replaceAll(EOL, EOL_ESCAPE)) + EOL);
                ++i;
            }
        }
        finally {
            ((Writer)output).close();
        }
    }

    public void readLogFromFile() {
        try {
            try {
                String line;
                FileInputStream fstream = new FileInputStream(this.logFile);
                BufferedReader bRead = new BufferedReader(new InputStreamReader(fstream));
                this.clear();
                while ((line = bRead.readLine()) != null) {
                    IVPGNode tokenRef;
                    boolean isWarning = Boolean.parseBoolean(line);
                    line = bRead.readLine();
                    if (line.trim().equals("")) {
                        tokenRef = null;
                    } else {
                        String[] tokenRefString = line.split("\\,");
                        tokenRef = (IVPGNode)this.locator.getVPGNode(tokenRefString[0], Integer.parseInt(tokenRefString[1]), Integer.parseInt(tokenRefString[2]));
                    }
                    line = bRead.readLine();
                    this.log.add(new Entry(this, isWarning, line.replaceAll(EOL_ESCAPE, EOL), tokenRef));
                }
                bRead.close();
                fstream.close();
            }
            catch (Exception exception) {
                this.notifyListeners();
                return;
            }
        }
        finally {
            this.notifyListeners();
        }
    }

    public static class Entry {
        private boolean isWarning;
        private String message;
        private R tokenRef;
        final /* synthetic */ VPGLog this$0;

        public Entry(boolean isWarningOnly, String message, R tokenRef) {
            this.this$0 = var1_1;
            this.isWarning = isWarningOnly;
            this.message = message;
            this.tokenRef = tokenRef;
        }

        public boolean isWarning() {
            return this.isWarning;
        }

        public boolean isError() {
            return !this.isWarning;
        }

        public String getMessage() {
            return this.message;
        }

        public R getTokenRef() {
            return this.tokenRef;
        }
    }

    public static interface ILogListener {
        public void onLogChange();
    }
}

