/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.ui.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPGEdge;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.internal.ui.browser.EdgeArrow;
import org.eclipse.rephraserengine.internal.ui.browser.Messages;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

class EdgesTab {
    private TabItem edges;
    private Composite composite;
    private StyledText styledText;
    private Button showAll;
    private Button showSelected;
    private Button edgeButton;
    private String filename;
    private List<VPGEdge<?, ?, ?>> edgesInFile;
    private Set<VPGEdge<?, ?, ?>> showEdges;
    private EclipseVPG vpg;
    private Set<Integer> edgeTypes;
    private Set<Integer> edgeTypesToShow;
    private List<Color> color;
    private Label label;

    public EdgesTab(TabItem edges, TabFolder tabFolder, EclipseVPG vpg) {
        this.vpg = vpg;
        this.filename = null;
        this.edgesInFile = Collections.emptyList();
        this.showEdges = Collections.emptySet();
        this.edges = edges;
        this.edgeTypes = Collections.emptySet();
        this.edgeTypesToShow = new HashSet<Integer>();
        this.color = Collections.emptyList();
        this.color = new ArrayList<Color>();
        this.addColors();
        this.createControls(tabFolder);
    }

    private void addColors() {
        this.color.add(new Color(null, new RGB(192, 0, 0)));
        this.color.add(new Color(null, new RGB(0, 192, 0)));
        this.color.add(new Color(null, new RGB(0, 0, 192)));
    }

    private void createControls(TabFolder tabfolder) {
        this.createComposite(tabfolder);
        this.createRadioButtons();
        this.createEdgesMenu();
        this.createStyledText();
        this.createLabel();
    }

    private void createLabel() {
        this.label = new Label(this.composite, 0);
        this.label.setText("");
    }

    private void createEdgesMenu() {
        this.edgeButton = new Button(this.composite, 0x800000);
        this.edgeButton.setText(Messages.EdgesTab_EdgeTypes);
        this.edgeButton.addSelectionListener((SelectionListener)new ShowEdgeTypesMenu());
    }

    private Set<VPGEdge<?, ?, ?>> collectSelectedEdges(int caretOffset) {
        HashSet edgesToShow = new HashSet();
        for (VPGEdge<?, ?, ?> edge : this.edgesInFile) {
            if (edge.getSource().getOffset() <= caretOffset && edge.getSource().getEndOffset() >= caretOffset) {
                edgesToShow.add(edge);
                continue;
            }
            if (edge.getSink().getOffset() > caretOffset || edge.getSink().getEndOffset() < caretOffset) continue;
            edgesToShow.add(edge);
        }
        return edgesToShow;
    }

    private void createComposite(TabFolder tabfolder) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.composite = new Composite((Composite)tabfolder, 0);
        this.composite.setLayout((Layout)layout);
        this.edges.setControl((Control)this.composite);
    }

    private void createRadioButtons() {
        this.createShowAllButton();
        this.createShowSelectedButton();
    }

    private void createShowAllButton() {
        this.showAll = new Button(this.composite, 16);
        this.showAll.setText(Messages.EdgesTab_ShowAllEdges);
        this.showAll.setSelection(false);
        this.showAll.addSelectionListener((SelectionListener)new RadioButtonSelectionListener());
    }

    private void createShowSelectedButton() {
        this.showSelected = new Button(this.composite, 16);
        this.showSelected.setText(Messages.EdgesTab_ShowSelectedEdges);
        this.showSelected.setSelection(true);
        this.showSelected.addSelectionListener((SelectionListener)new RadioButtonSelectionListener());
    }

    private void createStyledText() {
        this.styledText = new StyledText(this.composite, 778);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        this.styledText.setLayoutData((Object)gridData);
        this.styledText.setFont(JFaceResources.getTextFont());
        this.styledText.addPaintListener((PaintListener)new EdgePainter(this.styledText));
        this.styledText.addCaretListener((CaretListener)new ShowEdgeCaretListener());
    }

    public void showEdges(String file_selected, EclipseVPG vpg) {
        this.filename = file_selected;
        Object ast = vpg.acquireTransientAST(this.filename);
        if (ast == null) {
            this.styledText.setText(Messages.bind((String)Messages.EdgesTab_UnableToParse, (Object)this.filename));
        } else {
            this.styledText.setText(vpg.getSourceCodeFromAST(ast));
        }
        this.edgesInFile = new ArrayList();
        for (VPGEdge edge : vpg.getAllEdgesFor(this.filename)) {
            this.edgesInFile.add(edge);
        }
        this.edgeTypes = new HashSet<Integer>();
        for (VPGEdge edge : vpg.getAllEdgesFor(this.filename)) {
            this.edgeTypes.add(edge.getType());
        }
        this.edgeButton.setEnabled(this.edgeTypes.size() != 0);
    }

    private final class EdgePainter
    implements PaintListener {
        private final StyledText styledText;

        private EdgePainter(StyledText styledText) {
            this.styledText = styledText;
        }

        public void paintControl(PaintEvent e) {
            for (VPGEdge edge : EdgesTab.this.edgesInFile) {
                if (!EdgesTab.this.edgeTypesToShow.contains(edge.getType())) continue;
                Color defaultColor = e.gc.getForeground();
                e.gc.setForeground(this.setColor(edge.getType()));
                IVPGNode source = edge.getSource();
                IVPGNode sink = edge.getSink();
                if (source.getFilename().equals(EdgesTab.this.filename) && sink.getFilename().equals(EdgesTab.this.filename)) {
                    Rectangle srcRect = this.drawRectangle(e, source.getOffset(), source.getEndOffset());
                    Rectangle sinkRect = this.drawRectangle(e, sink.getOffset(), sink.getEndOffset());
                    if (srcRect != null && sinkRect != null && (EdgesTab.this.showAll.getSelection() || EdgesTab.this.showEdges.contains(edge))) {
                        this.displayEdgesAndArrows(e.gc, sinkRect, srcRect);
                    }
                }
                e.gc.setForeground(defaultColor);
            }
        }

        private void displayEdgesAndArrows(GC gc, Rectangle sinkRect, Rectangle srcRect) {
            new EdgeArrow(srcRect, sinkRect).drawOn(gc);
        }

        private Color setColor(int type) {
            return (Color)EdgesTab.this.color.get(type % EdgesTab.this.color.size());
        }

        private Rectangle drawRectangle(PaintEvent e, int startOffset, int endOffset) {
            if (this.isValid(startOffset) && this.isValid(endOffset)) {
                Rectangle srcRect = this.styledText.getTextBounds(startOffset, Math.max(0, endOffset - 1));
                e.gc.drawRectangle(srcRect);
                return srcRect;
            }
            return null;
        }

        private boolean isValid(int offset) {
            return offset >= 0 && offset < this.styledText.getCharCount();
        }
    }

    private class MenuItemSelectionListener
    implements SelectionListener {
        private int edgeType;

        public MenuItemSelectionListener(int type) {
            this.edgeType = type;
        }

        public void widgetSelected(SelectionEvent e) {
            if (EdgesTab.this.edgeTypesToShow.contains(this.edgeType)) {
                EdgesTab.this.edgeTypesToShow.remove(this.edgeType);
            } else {
                EdgesTab.this.edgeTypesToShow.add(this.edgeType);
            }
            EdgesTab.this.styledText.redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private final class RadioButtonSelectionListener
    implements SelectionListener {
        private RadioButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            EdgesTab.this.styledText.redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class SelectAllSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            EdgesTab.this.edgeTypesToShow.addAll(EdgesTab.this.edgeTypes);
            EdgesTab.this.showEdges = EdgesTab.this.collectSelectedEdges(EdgesTab.this.styledText.getCaretOffset());
            EdgesTab.this.styledText.redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private final class ShowEdgeCaretListener
    implements CaretListener {
        private ShowEdgeCaretListener() {
        }

        public void caretMoved(CaretEvent event) {
            EdgesTab.this.showEdges = EdgesTab.this.collectSelectedEdges(event.caretOffset);
            this.displayCaretInformation(event);
            EdgesTab.this.styledText.redraw();
        }

        private void displayCaretInformation(CaretEvent event) {
            int caretLine = EdgesTab.this.styledText.getLineAtOffset(EdgesTab.this.styledText.getCaretOffset());
            int lineOffset = EdgesTab.this.styledText.getOffsetAtLine(caretLine);
            int caretOffset = EdgesTab.this.styledText.getCaretOffset();
            int caretColumn = caretOffset - lineOffset + 1;
            EdgesTab.this.label.setText(Messages.bind((String)Messages.EdgesTab_LineColOffset, (Object[])new Object[]{caretLine + 1, caretColumn, EdgesTab.this.styledText.getCaretOffset()}));
            EdgesTab.this.label.pack();
        }
    }

    private class ShowEdgeTypesMenu
    implements SelectionListener {
        private ShowEdgeTypesMenu() {
        }

        public void widgetSelected(SelectionEvent e) {
            Menu popupMenu = new Menu((Control)EdgesTab.this.edgeButton);
            for (Integer type : EdgesTab.this.edgeTypes) {
                MenuItem menuItem = new MenuItem(popupMenu, 32);
                menuItem.setText(EdgesTab.this.vpg.describeEdgeType(type.intValue()));
                menuItem.addSelectionListener((SelectionListener)new MenuItemSelectionListener(type));
                menuItem.setSelection(EdgesTab.this.edgeTypesToShow.contains(type));
            }
            new MenuItem(popupMenu, 2);
            MenuItem menuItem = new MenuItem(popupMenu, 32);
            menuItem.setText(Messages.EdgesTab_ShowAllEdges);
            menuItem.addSelectionListener((SelectionListener)new SelectAllSelectionListener());
            popupMenu.setVisible(true);
            while (!popupMenu.isDisposed() && popupMenu.isVisible()) {
                if (popupMenu.getDisplay().readAndDispatch()) continue;
                popupMenu.getDisplay().sleep();
            }
            popupMenu.dispose();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

