/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceEnablement;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.EventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.TraceInfo;

public class ChannelInfo
extends TraceInfo
implements IChannelInfo {
    private boolean fOverwriteMode;
    private long fSubBufferSize;
    private int fNumberOfSubBuffers;
    private long fSwitchTimer;
    private long fReadTimer;
    private String fOutputType = "";
    private TraceEnablement fState = TraceEnablement.DISABLED;
    private final List<IEventInfo> fEvents = new ArrayList<IEventInfo>();

    public ChannelInfo(String name) {
        super(name);
    }

    public ChannelInfo(ChannelInfo other) {
        super(other);
        this.fOverwriteMode = other.fOverwriteMode;
        this.fSubBufferSize = other.fSubBufferSize;
        this.fNumberOfSubBuffers = other.fNumberOfSubBuffers;
        this.fSwitchTimer = other.fSwitchTimer;
        this.fReadTimer = other.fReadTimer;
        this.fOutputType = other.fOutputType == null ? null : String.valueOf(other.fOutputType);
        this.fState = other.fState;
        for (IEventInfo event : other.fEvents) {
            if (event instanceof EventInfo) {
                this.fEvents.add(new EventInfo((EventInfo)event));
                continue;
            }
            this.fEvents.add(event);
        }
    }

    @Override
    public boolean isOverwriteMode() {
        return this.fOverwriteMode;
    }

    @Override
    public void setOverwriteMode(boolean mode) {
        this.fOverwriteMode = mode;
    }

    @Override
    public long getSubBufferSize() {
        return this.fSubBufferSize;
    }

    @Override
    public void setSubBufferSize(long bufferSize) {
        this.fSubBufferSize = bufferSize;
    }

    @Override
    public int getNumberOfSubBuffers() {
        return this.fNumberOfSubBuffers;
    }

    @Override
    public void setNumberOfSubBuffers(int numberOfSubBuffers) {
        this.fNumberOfSubBuffers = numberOfSubBuffers;
    }

    @Override
    public long getSwitchTimer() {
        return this.fSwitchTimer;
    }

    @Override
    public void setSwitchTimer(long timer) {
        this.fSwitchTimer = timer;
    }

    @Override
    public long getReadTimer() {
        return this.fReadTimer;
    }

    @Override
    public void setReadTimer(long timer) {
        this.fReadTimer = timer;
    }

    @Override
    public String getOutputType() {
        return this.fOutputType;
    }

    @Override
    public void setOutputType(String type) {
        this.fOutputType = type;
    }

    @Override
    public TraceEnablement getState() {
        return this.fState;
    }

    @Override
    public void setState(TraceEnablement state) {
        this.fState = state;
    }

    @Override
    public void setState(String stateName) {
        this.fState = TraceEnablement.ENABLED;
        if (TraceEnablement.DISABLED.getInName().equals(stateName)) {
            this.fState = TraceEnablement.DISABLED;
        } else if (TraceEnablement.ENABLED.getInName().equals(stateName)) {
            this.fState = TraceEnablement.ENABLED;
        }
    }

    @Override
    public IEventInfo[] getEvents() {
        return this.fEvents.toArray(new IEventInfo[this.fEvents.size()]);
    }

    @Override
    public void setEvents(List<IEventInfo> events) {
        this.fEvents.clear();
        for (IEventInfo eventInfo : events) {
            this.fEvents.add(eventInfo);
        }
    }

    @Override
    public void addEvent(IEventInfo channel) {
        this.fEvents.add(channel);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fEvents.hashCode();
        result = 31 * result + this.fNumberOfSubBuffers;
        result = 31 * result + (this.fOutputType == null ? 0 : this.fOutputType.hashCode());
        result = 31 * result + (this.fOverwriteMode ? 1231 : 1237);
        result = 31 * result + (int)(this.fReadTimer ^ this.fReadTimer >>> 32);
        result = 31 * result + (this.fState == null ? 0 : this.fState.ordinal() + 1);
        result = 31 * result + (int)(this.fSubBufferSize ^ this.fSubBufferSize >>> 32);
        result = 31 * result + (int)(this.fSwitchTimer ^ this.fSwitchTimer >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelInfo other = (ChannelInfo)obj;
        if (!this.fEvents.equals(other.fEvents)) {
            return false;
        }
        if (this.fNumberOfSubBuffers != other.fNumberOfSubBuffers) {
            return false;
        }
        if (this.fOutputType == null ? other.fOutputType != null : !this.fOutputType.equals(other.fOutputType)) {
            return false;
        }
        if (this.fOverwriteMode != other.fOverwriteMode) {
            return false;
        }
        if (this.fReadTimer != other.fReadTimer) {
            return false;
        }
        if (this.fState != other.fState) {
            return false;
        }
        if (this.fSubBufferSize != other.fSubBufferSize) {
            return false;
        }
        return this.fSwitchTimer == other.fSwitchTimer;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[ChannelInfo(");
        output.append(super.toString());
        output.append(",State=");
        output.append((Object)this.fState);
        output.append(",OverwriteMode=");
        output.append(this.fOverwriteMode);
        output.append(",SubBuffersSize=");
        output.append(this.fSubBufferSize);
        output.append(",NumberOfSubBuffers=");
        output.append(this.fNumberOfSubBuffers);
        output.append(",SwitchTimer=");
        output.append(this.fSwitchTimer);
        output.append(",ReadTimer=");
        output.append(this.fReadTimer);
        output.append(",output=");
        output.append(this.fOutputType);
        output.append(",Events=");
        if (this.fEvents.isEmpty()) {
            output.append("None");
        } else {
            for (IEventInfo event : this.fEvents) {
                output.append(event.toString());
            }
        }
        output.append(")]");
        return output.toString();
    }
}

