/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteInactiveHighlightingService;
import org.eclipse.ptp.internal.rdt.ui.editor.RemoteInactiveHighlightPosition;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.subsystems.IConnectorService;

public class RemoteInactiveHighlightingService
extends AbstractRemoteService
implements IRemoteInactiveHighlightingService {
    public RemoteInactiveHighlightingService(IConnectorService connectorService) {
        super(connectorService);
    }

    public RemoteInactiveHighlightingService(ICIndexSubsystem subsystem) {
        super(subsystem);
    }

    @Override
    public List<Position> computeInactiveHighlightingPositions(IDocument document, IWorkingCopy workingCopy) {
        ITranslationUnit unit;
        ICIndexSubsystem subsystem = this.getSubSystem();
        if (subsystem == null) {
            return Collections.emptyList();
        }
        subsystem.checkProject(workingCopy.getCProject().getProject(), (IProgressMonitor)new NullProgressMonitor());
        try {
            unit = this.adaptWorkingCopy(workingCopy);
        }
        catch (CModelException e) {
            RDTLog.logError((Throwable)e);
            return Collections.emptyList();
        }
        String result = subsystem.computeInactiveHighlightPositions(unit);
        return this.parsePositions(document, result);
    }

    private List<Position> parsePositions(IDocument document, String positionString) {
        if (positionString == null || positionString.length() == 0) {
            return Collections.emptyList();
        }
        String[] elements = positionString.split(",");
        ArrayList<Position> positions = new ArrayList<Position>(elements.length / 3);
        int i = 0;
        while (i < elements.length) {
            int start = Integer.parseInt(elements[i]);
            int end = Integer.parseInt(elements[i + 1]);
            boolean inclusive = Boolean.parseBoolean(elements[i + 2]);
            positions.add((Position)this.createHighlightPosition(document, start, end, inclusive));
            i += 3;
        }
        return positions;
    }

    private RemoteInactiveHighlightPosition createHighlightPosition(IDocument document, int startOffset, int endOffset, boolean inclusive) {
        try {
            if (document != null) {
                int start = document.getLineOfOffset(startOffset);
                int end = document.getLineOfOffset(endOffset);
                startOffset = document.getLineOffset(start);
                if (!inclusive) {
                    endOffset = document.getLineOffset(end);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return new RemoteInactiveHighlightPosition(startOffset, endOffset - startOffset, "inactiveCode");
    }
}

