/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersComparator;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersHideShowManager;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STOwnerDrawLabelProvider;
import org.eclipse.linuxtools.dataviewers.listeners.STDisposeListener;
import org.eclipse.linuxtools.dataviewers.listeners.STHeaderListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractSTViewer {
    private IDialogSettings viewerSettings = null;
    private ISTDataViewersField[] fields = null;
    private ColumnViewer viewer;
    private STDataViewersComparator comparator;
    private STDataViewersHideShowManager hideShowManager;

    public AbstractSTViewer(Composite parent) {
        this(parent, 68354);
    }

    public AbstractSTViewer(Composite parent, boolean init) {
        this(parent, 68354, init);
    }

    public AbstractSTViewer(Composite parent, int style) {
        this(parent, style, true);
    }

    public AbstractSTViewer(Composite parent, int style, boolean init) {
        if (init) {
            this.init(parent, style);
        }
    }

    protected void init(Composite parent, int style) {
        this.viewer = this.createViewer(parent, style);
        this.viewerSettings = this.createSTAbstractDataViewersSettings();
        this.fields = this.getAllFields();
        this.createColumns();
        this.restoreColumnOrder();
        STDataViewersHideShowManager manager = this.buildHideShowManager();
        manager.restoreState(this.viewerSettings);
        this.setHideShowManager(manager);
        STDataViewersComparator comparator = this.buildComparator();
        comparator.restoreState(this.viewerSettings);
        this.setComparator(comparator);
        this.setSortIndicators();
        IContentProvider cp = this.createContentProvider();
        this.viewer.setContentProvider(cp);
        this.viewer.setUseHashlookup(true);
        GridData data = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.setInput(this.createDefaultViewerInput());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Scrollable scrollable = (Scrollable)this.viewer.getControl();
        ScrollBar bar = scrollable.getVerticalBar();
        if (bar != null) {
            bar.setSelection(this.restoreVerticalScrollBarPosition());
        }
        if ((bar = scrollable.getHorizontalBar()) != null) {
            bar.setSelection(this.restoreHorizontalScrollBarPosition());
        }
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractSTViewer.this.handleOpenEvent(event);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractSTViewer.this.handleKeyPressed(e);
            }
        });
        this.viewer.getControl().addDisposeListener(this.createDisposeListener());
    }

    protected STDataViewersHideShowManager buildHideShowManager() {
        return new STDataViewersHideShowManager(this);
    }

    public void setHideShowManager(STDataViewersHideShowManager manager) {
        this.hideShowManager = manager;
        this.updateForNewHideShowManager(this.hideShowManager);
    }

    protected void updateForNewHideShowManager(STDataViewersHideShowManager manager) {
        manager.updateColumns();
    }

    protected STDataViewersComparator buildComparator() {
        return new STDataViewersComparator(this.getColumns());
    }

    public STDataViewersComparator getTableSorter() {
        return this.comparator;
    }

    public void setComparator(STDataViewersComparator comparator) {
        this.comparator = comparator;
        this.viewer.setComparator((ViewerComparator)comparator);
        this.updateForNewComparator(comparator);
    }

    protected void updateForNewComparator(STDataViewersComparator comparator) {
        comparator.saveState(this.viewerSettings);
        this.viewer.refresh();
        this.setSortIndicators();
    }

    protected void setSortIndicators() {
        Item topc = this.getTableSorter().getTopColumn();
        this.updateDirectionIndicator(topc);
    }

    protected IDialogSettings createSTAbstractDataViewersSettings() {
        IDialogSettings settings = this.getDialogSettings().getSection("viewer_state_section");
        if (settings == null) {
            settings = this.getDialogSettings().addNewSection("viewer_state_section");
        }
        return settings;
    }

    public void restoreColumnOrder() {
        int[] order = this.restoreColumnOrderSetting();
        if (order != null && order.length == this.fields.length) {
            this.setColumnOrder(order);
        }
    }

    public int restoreVerticalScrollBarPosition() {
        if (this.viewerSettings == null) {
            return 0;
        }
        String position = this.viewerSettings.get("vertical_position");
        if (position == null) {
            return 0;
        }
        try {
            return Integer.parseInt(position);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int restoreHorizontalScrollBarPosition() {
        if (this.viewerSettings == null) {
            return 0;
        }
        String position = this.viewerSettings.get("horizontal_position");
        if (position == null) {
            return 0;
        }
        try {
            return Integer.parseInt(position);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int[] restoreColumnOrderSetting() {
        if (this.viewerSettings == null) {
            return null;
        }
        String[] columnOrder = this.viewerSettings.getArray("column_order");
        if (columnOrder == null) {
            return null;
        }
        int n = columnOrder.length;
        if (n != this.getAllFields().length) {
            return null;
        }
        try {
            int[] values = new int[n];
            int i = 0;
            while (i < n) {
                int val;
                values[i] = val = Integer.parseInt(columnOrder[i]);
                ++i;
            }
            return values;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void saveState() {
        Scrollable scrollable;
        ScrollBar bar;
        if (this.viewerSettings == null) {
            this.viewerSettings = this.getDialogSettings().getSection("viewer_state_section");
        }
        if (this.viewerSettings == null) {
            this.viewerSettings = this.getDialogSettings().addNewSection("viewer_state_section");
        }
        int[] columnOrder = this.getColumnOrder();
        String[] columnOrderStrings = new String[columnOrder.length];
        int i = 0;
        while (i < columnOrder.length) {
            columnOrderStrings[i] = String.valueOf(columnOrder[i]);
            ++i;
        }
        this.viewerSettings.put("column_order", columnOrderStrings);
        if (this.getHideShowManager() != null) {
            this.getHideShowManager().saveState(this.viewerSettings);
        }
        if (this.getTableSorter() != null) {
            this.getTableSorter().saveState(this.viewerSettings);
        }
        int position = (bar = (scrollable = (Scrollable)this.viewer.getControl()).getVerticalBar()) != null ? bar.getSelection() : 0;
        this.viewerSettings.put("vertical_position", position);
        bar = scrollable.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        this.viewerSettings.put("horizontal_position", position);
    }

    protected DisposeListener createDisposeListener() {
        return new STDisposeListener(this);
    }

    protected SelectionListener createHeaderListener() {
        return new STHeaderListener(this);
    }

    public IDialogSettings getViewerSettings() {
        return this.viewerSettings;
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public STDataViewersHideShowManager getHideShowManager() {
        return this.hideShowManager;
    }

    protected Object createDefaultViewerInput() {
        return null;
    }

    protected void handleKeyPressed(KeyEvent event) {
    }

    protected void handleOpenEvent(OpenEvent event) {
    }

    public abstract ISTDataViewersField[] getAllFields();

    protected abstract IContentProvider createContentProvider();

    public abstract IDialogSettings getDialogSettings();

    protected abstract ColumnViewer createViewer(Composite var1, int var2);

    protected abstract void createColumns();

    protected CellLabelProvider createColumnLabelProvider(Item column) {
        return new STOwnerDrawLabelProvider(column);
    }

    public abstract void updateDirectionIndicator(Item var1);

    public abstract int[] getColumnOrder();

    protected abstract void setColumnOrder(int[] var1);

    public abstract Item[] getColumns();

    public abstract int getColumnIndex(Item var1);

    public abstract int getColumnWidth(Item var1);

    public abstract void setColumnWidth(Item var1, int var2);

    public abstract void setColumnResizable(Item var1, boolean var2);
}

