/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.parser;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.AbstractTask;
import org.eclipse.ui.internal.cheatsheets.composite.parser.CompositeCheatSheetParser;
import org.eclipse.ui.internal.cheatsheets.composite.parser.IStatusContainer;
import org.eclipse.ui.internal.cheatsheets.composite.parser.ITaskParseStrategy;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.w3c.dom.Node;

public class EditableTaskParseStrategy
implements ITaskParseStrategy {
    private boolean editableChildErrorReported;

    public void init() {
        this.editableChildErrorReported = false;
    }

    public boolean parseElementNode(Node childNode, Node parentNode, AbstractTask parentTask, IStatusContainer status) {
        boolean isElementHandled = true;
        String nodeName = childNode.getNodeName();
        if (CompositeCheatSheetParser.isAbstractTask(nodeName)) {
            if (!this.editableChildErrorReported) {
                this.editableChildErrorReported = true;
                String message = NLS.bind((String)Messages.ERROR_EDITABLE_TASK_WITH_CHILDREN, (Object[])new Object[]{parentTask.getName()});
                status.addStatus(4, message, null);
            }
        } else {
            isElementHandled = false;
        }
        return isElementHandled;
    }

    public void parsingComplete(AbstractTask parentTask, IStatusContainer status) {
        if (parentTask.getKind() == null) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_TASK_NO_KIND, (Object[])new Object[]{parentTask.getName()});
            status.addStatus(4, message, null);
        } else if (CheatSheetRegistryReader.getInstance().findTaskEditor(parentTask.getKind()) == null) {
            String message = NLS.bind((String)Messages.ERROR_PARSING_TASK_INVALID_KIND, (Object[])new Object[]{parentTask.getKind(), "task", parentTask.getName()});
            status.addStatus(4, message, null);
        }
    }
}

