/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.internal.ui.text.makefile.AbstractMakefileCodeScanner;
import org.eclipse.cdt.make.internal.ui.text.makefile.AutomaticVariableReferenceRule;
import org.eclipse.cdt.make.internal.ui.text.makefile.FunctionReferenceRule;
import org.eclipse.cdt.make.internal.ui.text.makefile.MacroDefinitionRule;
import org.eclipse.cdt.make.internal.ui.text.makefile.MacroReferenceRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class MakefileCodeScanner
extends AbstractMakefileCodeScanner {
    private static final String[] keywords = new String[]{"define", "endef", "ifdef", "ifndef", "ifeq", "ifneq", "else", "endif", "include", "-include", "sinclude", "override", "export", "unexport", "vpath"};
    public static final String[] fTokenProperties = new String[]{"org.eclipse.cdt.make.ui.editor.keyword", "org.eclipse.cdt.make.ui.editor.function", "org.eclipse.cdt.make.ui.editor.macro_ref", "org.eclipse.cdt.make.ui.editor.macro_def", "org.eclipse.cdt.make.ui.editor.default"};

    public MakefileCodeScanner() {
        this.initialize();
    }

    @Override
    protected List<IRule> createRules() {
        Token keywordToken = this.getToken("org.eclipse.cdt.make.ui.editor.keyword");
        Token functionToken = this.getToken("org.eclipse.cdt.make.ui.editor.function");
        Token macroRefToken = this.getToken("org.eclipse.cdt.make.ui.editor.macro_ref");
        Token macroDefToken = this.getToken("org.eclipse.cdt.make.ui.editor.macro_def");
        Token defaultToken = this.getToken("org.eclipse.cdt.make.ui.editor.default");
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char character) {
                return Character.isWhitespace(character);
            }
        }, (IToken)defaultToken));
        rules.add((IRule)new MacroDefinitionRule((IToken)macroDefToken, Token.UNDEFINED));
        WordRule keyWordRule = new WordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return Character.isLetterOrDigit(c) || c == '_';
            }

            public boolean isWordStart(char c) {
                return Character.isLetterOrDigit(c) || c == '_' || c == '-';
            }
        });
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            keyWordRule.addWord(keyword, (IToken)keywordToken);
            ++n2;
        }
        keyWordRule.setColumnConstraint(0);
        rules.add((IRule)keyWordRule);
        rules.add((IRule)new FunctionReferenceRule((IToken)functionToken));
        rules.add((IRule)new AutomaticVariableReferenceRule((IToken)macroRefToken));
        rules.add((IRule)new MacroReferenceRule((IToken)macroRefToken, "$(", ")"));
        rules.add((IRule)new MacroReferenceRule((IToken)macroRefToken, "$$(", ")"));
        rules.add((IRule)new MacroReferenceRule((IToken)macroRefToken, "${", "}"));
        rules.add((IRule)new MacroReferenceRule((IToken)macroRefToken, "$${", "}"));
        this.setDefaultReturnToken((IToken)defaultToken);
        return rules;
    }

    @Override
    protected String[] getTokenProperties() {
        return fTokenProperties;
    }
}

