/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.metadata;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.linuxtools.ctf.core.event.CTFClock;
import org.eclipse.linuxtools.ctf.core.event.types.ArrayDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Encoding;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.SequenceDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StringDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.Stream;
import org.eclipse.linuxtools.ctf.parser.CTFParser;
import org.eclipse.linuxtools.internal.ctf.core.Activator;
import org.eclipse.linuxtools.internal.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.Messages;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class IOStructGen {
    private static final boolean DEBUG = false;
    private final CTFTrace trace;
    private final CommonTree tree;
    private DeclarationScope scope = null;

    public IOStructGen(CommonTree tree, CTFTrace trace) {
        this.trace = trace;
        this.tree = tree;
    }

    public void generate() throws ParseException {
        this.parseRoot(this.tree);
    }

    private void parseRoot(CommonTree root) throws ParseException {
        List children = root.getChildren();
        Object fos = null;
        Object out = null;
        CommonTree traceNode = null;
        ArrayList<CommonTree> streams = new ArrayList<CommonTree>();
        ArrayList<CommonTree> events = new ArrayList<CommonTree>();
        ArrayList<CommonTree> declarations = new ArrayList<CommonTree>();
        ArrayList<CommonTree> environments = new ArrayList<CommonTree>();
        ArrayList<CommonTree> clocks = new ArrayList<CommonTree>();
        ArrayList<CommonTree> callsites = new ArrayList<CommonTree>();
        this.pushScope();
        try {
            for (CommonTree child : children) {
                int type = child.getType();
                switch (type) {
                    case 87: {
                        declarations.add(child);
                        break;
                    }
                    case 83: {
                        if (traceNode != null) {
                            throw new ParseException("Only one trace block is allowed");
                        }
                        traceNode = child;
                        break;
                    }
                    case 82: {
                        streams.add(child);
                        break;
                    }
                    case 81: {
                        events.add(child);
                        break;
                    }
                    case 85: {
                        clocks.add(child);
                        break;
                    }
                    case 84: {
                        environments.add(child);
                        break;
                    }
                    case 86: {
                        callsites.add(child);
                        break;
                    }
                    default: {
                        IOStructGen.childTypeError(child);
                    }
                }
            }
            for (CommonTree decl : declarations) {
                this.parseRootDeclaration(decl);
            }
            if (traceNode == null) {
                throw new ParseException("Missing trace block");
            }
            this.parseTrace(traceNode);
            for (CommonTree environment : environments) {
                this.parseEnvironment(environment);
            }
            for (CommonTree clock : clocks) {
                this.parseClock(clock);
            }
            for (CommonTree callsite : callsites) {
                this.parseCallsite(callsite);
            }
            if (streams.size() > 0) {
                for (CommonTree stream : streams) {
                    this.parseStream(stream);
                }
            } else {
                this.trace.addStream(new Stream(this.trace));
            }
            for (CommonTree event : events) {
                this.parseEvent(event);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.popScope();
    }

    private void parseCallsite(CommonTree callsite) {
        List children = callsite.getChildren();
        String name = null;
        String funcName = null;
        long lineNumber = -1L;
        long ip = -1L;
        String fileName = null;
        for (CommonTree child : children) {
            String left = child.getChild(0).getChild(0).getChild(0).getText();
            if (left.equals("name")) {
                name = child.getChild(1).getChild(0).getChild(0).getText().replaceAll("^\"|\"$", "");
                continue;
            }
            if (left.equals("func")) {
                funcName = child.getChild(1).getChild(0).getChild(0).getText().replaceAll("^\"|\"$", "");
                continue;
            }
            if (left.equals("ip")) {
                ip = Long.parseLong(child.getChild(1).getChild(0).getChild(0).getText().substring(2), 16);
                continue;
            }
            if (left.equals("file")) {
                fileName = child.getChild(1).getChild(0).getChild(0).getText().replaceAll("^\"|\"$", "");
                continue;
            }
            if (!left.equals("line")) continue;
            lineNumber = Long.parseLong(child.getChild(1).getChild(0).getChild(0).getText());
        }
        this.trace.addCallsite(name, funcName, ip, fileName, lineNumber);
    }

    private void parseEnvironment(CommonTree environment) {
        List children = environment.getChildren();
        for (CommonTree child : children) {
            String left = child.getChild(0).getChild(0).getChild(0).getText();
            String right = child.getChild(1).getChild(0).getChild(0).getText();
            this.trace.addEnvironmentVar(left, right);
        }
    }

    private void parseClock(CommonTree clock) {
        List children = clock.getChildren();
        CTFClock ctfClock = new CTFClock();
        for (CommonTree child : children) {
            String key = child.getChild(0).getChild(0).getChild(0).getText();
            CommonTree value = (CommonTree)child.getChild(1).getChild(0).getChild(0);
            int type = value.getType();
            switch (type) {
                case 57: 
                case 110: {
                    Long numValue;
                    try {
                        numValue = Long.parseLong(value.getText());
                    }
                    catch (Exception exception) {
                        numValue = 1330938566783103277L;
                    }
                    ctfClock.addAttribute(key, numValue);
                    break;
                }
                default: {
                    ctfClock.addAttribute(key, value.getText());
                }
            }
        }
        String nameValue = ctfClock.getName();
        this.trace.addClock(nameValue, ctfClock);
    }

    private void parseTrace(CommonTree traceNode) throws ParseException {
        List children = traceNode.getChildren();
        if (children == null) {
            throw new ParseException("Trace block is empty");
        }
        this.pushScope();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 107: {
                    this.parseTypealias(child);
                    break;
                }
                case 106: {
                    this.parseTypedef(child);
                    break;
                }
                case 96: 
                case 97: {
                    this.parseTraceDeclaration(child);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (this.trace.getByteOrder() == null) {
            throw new ParseException("Trace byte order not set");
        }
        this.popScope();
    }

    private void parseTraceDeclaration(CommonTree traceDecl) throws ParseException {
        CommonTree leftNode = (CommonTree)traceDecl.getChild(0);
        CommonTree rightNode = (CommonTree)traceDecl.getChild(1);
        List leftStrings = leftNode.getChildren();
        if (!IOStructGen.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
            throw new ParseException("Left side of CTF assignment must be a string");
        }
        String left = IOStructGen.concatenateUnaryStrings(leftStrings);
        if (left.equals("major")) {
            if (this.trace.majortIsSet()) {
                throw new ParseException("major is already set");
            }
            this.trace.setMajor(IOStructGen.getMajorOrMinor(rightNode));
        } else if (left.equals("minor")) {
            if (this.trace.minorIsSet()) {
                throw new ParseException("minor is already set");
            }
            this.trace.setMinor(IOStructGen.getMajorOrMinor(rightNode));
        } else if (left.equals("uuid")) {
            UUID uuid = IOStructGen.getUUID(rightNode);
            if (this.trace.uuidIsSet()) {
                if (this.trace.getUUID().compareTo(uuid) != 0) {
                    throw new ParseException("UUID mismatch. Packet says " + this.trace.getUUID() + " but metadata says " + uuid);
                }
            } else {
                this.trace.setUUID(uuid);
            }
        } else if (left.equals("byte_order")) {
            ByteOrder byteOrder = this.getByteOrder(rightNode);
            if (this.trace.getByteOrder() != null) {
                if (this.trace.getByteOrder() != byteOrder) {
                    throw new ParseException("Endianness mismatch. Magic number says " + this.trace.getByteOrder() + " but metadata says " + byteOrder);
                }
            } else {
                String[] types;
                this.trace.setByteOrder(byteOrder);
                DeclarationScope parentScope = this.scope.getParentScope();
                String[] stringArray = types = parentScope.getTypeNames();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    IDeclaration d = parentScope.lookupType(type);
                    if (d instanceof IntegerDeclaration) {
                        IOStructGen.addByteOrder(byteOrder, parentScope, type, (IntegerDeclaration)d);
                    } else if (d instanceof StructDeclaration) {
                        this.setAlign(parentScope, (StructDeclaration)d, byteOrder);
                    }
                    ++n2;
                }
            }
        } else if (left.equals("packet.header")) {
            if (this.trace.packetHeaderIsSet()) {
                throw new ParseException("packet.header already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 89) {
                throw new ParseException("packet.header expects a type specifier");
            }
            IDeclaration packetHeaderDecl = this.parseTypeSpecifierList(typeSpecifier, null);
            if (!(packetHeaderDecl instanceof StructDeclaration)) {
                throw new ParseException("packet.header expects a struct");
            }
            this.trace.setPacketHeader((StructDeclaration)packetHeaderDecl);
        } else {
            Activator.log(2, String.valueOf(Messages.IOStructGen_UnknownTraceAttributeWarning) + " " + left);
        }
    }

    private static void addByteOrder(ByteOrder byteOrder, DeclarationScope parentScope, String name, IntegerDeclaration decl) throws ParseException {
        if (decl.getByteOrder() == null) {
            IntegerDeclaration newI = new IntegerDeclaration(decl.getLength(), decl.isSigned(), decl.getBase(), byteOrder, decl.getEncoding(), decl.getClock(), decl.getAlignment());
            parentScope.replaceType(name, newI);
        }
    }

    private void setAlign(DeclarationScope parentScope, StructDeclaration sd, ByteOrder byteOrder) throws ParseException {
        for (String s : sd.getFieldsList()) {
            IntegerDeclaration decl;
            IDeclaration d = sd.getFields().get(s);
            if (d instanceof StructDeclaration) {
                this.setAlign(parentScope, (StructDeclaration)d, byteOrder);
                continue;
            }
            if (d instanceof VariantDeclaration) {
                this.setAlign(parentScope, (VariantDeclaration)d, byteOrder);
                continue;
            }
            if (!(d instanceof IntegerDeclaration) || (decl = (IntegerDeclaration)d).getByteOrder() != null) continue;
            IntegerDeclaration newI = new IntegerDeclaration(decl.getLength(), decl.isSigned(), decl.getBase(), byteOrder, decl.getEncoding(), decl.getClock(), decl.getAlignment());
            sd.getFields().put(s, newI);
        }
    }

    private void setAlign(DeclarationScope parentScope, VariantDeclaration vd, ByteOrder byteOrder) throws ParseException {
        for (String s : vd.getFields().keySet()) {
            IDeclaration d = vd.getFields().get(s);
            if (d instanceof StructDeclaration) {
                this.setAlign(parentScope, (StructDeclaration)d, byteOrder);
                continue;
            }
            if (!(d instanceof IntegerDeclaration)) continue;
            IntegerDeclaration decl = (IntegerDeclaration)d;
            IntegerDeclaration newI = new IntegerDeclaration(decl.getLength(), decl.isSigned(), decl.getBase(), byteOrder, decl.getEncoding(), decl.getClock(), decl.getAlignment());
            vd.getFields().put(s, newI);
        }
    }

    private void parseStream(CommonTree streamNode) throws ParseException {
        Stream stream = new Stream(this.trace);
        List children = streamNode.getChildren();
        if (children == null) {
            throw new ParseException("Empty stream block");
        }
        this.pushScope();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 107: {
                    this.parseTypealias(child);
                    break;
                }
                case 106: {
                    this.parseTypedef(child);
                    break;
                }
                case 96: 
                case 97: {
                    this.parseStreamDeclaration(child, stream);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (!(!stream.isIdSet() || this.trace.packetHeaderIsSet() && this.trace.getPacketHeader().hasField("stream_id"))) {
            throw new ParseException("Stream has an ID, but there is no stream_id field in packet header.");
        }
        this.trace.addStream(stream);
        this.popScope();
    }

    private void parseStreamDeclaration(CommonTree streamDecl, Stream stream) throws ParseException {
        CommonTree leftNode = (CommonTree)streamDecl.getChild(0);
        CommonTree rightNode = (CommonTree)streamDecl.getChild(1);
        List leftStrings = leftNode.getChildren();
        if (!IOStructGen.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
            throw new ParseException("Left side of CTF assignment must be a string");
        }
        String left = IOStructGen.concatenateUnaryStrings(leftStrings);
        if (left.equals("id")) {
            if (stream.isIdSet()) {
                throw new ParseException("stream id already defined");
            }
            long streamID = IOStructGen.getStreamID(rightNode);
            stream.setId(streamID);
        } else if (left.equals("event.header")) {
            if (stream.isEventHeaderSet()) {
                throw new ParseException("event.header already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 89) {
                throw new ParseException("event.header expects a type specifier");
            }
            IDeclaration eventHeaderDecl = this.parseTypeSpecifierList(typeSpecifier, null);
            if (!(eventHeaderDecl instanceof StructDeclaration)) {
                throw new ParseException("event.header expects a struct");
            }
            stream.setEventHeader((StructDeclaration)eventHeaderDecl);
        } else if (left.equals("event.context")) {
            if (stream.isEventContextSet()) {
                throw new ParseException("event.context already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 89) {
                throw new ParseException("event.context expects a type specifier");
            }
            IDeclaration eventContextDecl = this.parseTypeSpecifierList(typeSpecifier, null);
            if (!(eventContextDecl instanceof StructDeclaration)) {
                throw new ParseException("event.context expects a struct");
            }
            stream.setEventContext((StructDeclaration)eventContextDecl);
        } else if (left.equals("packet.context")) {
            if (stream.isPacketContextSet()) {
                throw new ParseException("packet.context already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 89) {
                throw new ParseException("packet.context expects a type specifier");
            }
            IDeclaration packetContextDecl = this.parseTypeSpecifierList(typeSpecifier, null);
            if (!(packetContextDecl instanceof StructDeclaration)) {
                throw new ParseException("packet.context expects a struct");
            }
            stream.setPacketContext((StructDeclaration)packetContextDecl);
        } else {
            Activator.log(2, String.valueOf(Messages.IOStructGen_UnknownStreamAttributeWarning) + " " + left);
        }
    }

    private void parseEvent(CommonTree eventNode) throws ParseException {
        List children = eventNode.getChildren();
        if (children == null) {
            throw new ParseException("Empty event block");
        }
        EventDeclaration event = new EventDeclaration();
        this.pushScope();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 107: {
                    this.parseTypealias(child);
                    break;
                }
                case 106: {
                    this.parseTypedef(child);
                    break;
                }
                case 96: 
                case 97: {
                    this.parseEventDeclaration(child, event);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (!event.nameIsSet()) {
            throw new ParseException("Event name not set");
        }
        if (!event.streamIsSet()) {
            if (this.trace.nbStreams() > 1) {
                throw new ParseException("Event without stream_id with more than one stream");
            }
            Stream stream = this.trace.getStream(null);
            if (stream != null) {
                event.setStream(stream);
            } else {
                throw new ParseException("Event without stream_id, but there is no stream without id");
            }
        }
        event.getStream().addEvent(event);
        this.popScope();
    }

    private void parseEventDeclaration(CommonTree eventDecl, EventDeclaration event) throws ParseException {
        CommonTree leftNode = (CommonTree)eventDecl.getChild(0);
        CommonTree rightNode = (CommonTree)eventDecl.getChild(1);
        List leftStrings = leftNode.getChildren();
        if (!IOStructGen.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
            throw new ParseException("Left side of CTF assignment must be a string");
        }
        String left = IOStructGen.concatenateUnaryStrings(leftStrings);
        if (left.equals("name")) {
            if (event.nameIsSet()) {
                throw new ParseException("name already defined");
            }
            String name = IOStructGen.getEventName(rightNode);
            event.setName(name);
        } else if (left.equals("id")) {
            if (event.idIsSet()) {
                throw new ParseException("id already defined");
            }
            long id = IOStructGen.getEventID(rightNode);
            event.setId(id);
        } else if (left.equals("stream_id")) {
            if (event.streamIsSet()) {
                throw new ParseException("stream id already defined");
            }
            long streamId = IOStructGen.getStreamID(rightNode);
            Stream stream = this.trace.getStream(streamId);
            if (stream == null) {
                throw new ParseException("Stream " + streamId + " not found");
            }
            event.setStream(stream);
        } else if (left.equals("context")) {
            if (event.contextIsSet()) {
                throw new ParseException("context already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 89) {
                throw new ParseException("context expects a type specifier");
            }
            IDeclaration contextDecl = this.parseTypeSpecifierList(typeSpecifier, null);
            if (!(contextDecl instanceof StructDeclaration)) {
                throw new ParseException("context expects a struct");
            }
            event.setContext((StructDeclaration)contextDecl);
        } else if (left.equals("fields")) {
            if (event.fieldsIsSet()) {
                throw new ParseException("fields already defined");
            }
            CommonTree typeSpecifier = (CommonTree)rightNode.getChild(0);
            if (typeSpecifier.getType() != 89) {
                throw new ParseException("fields expects a type specifier");
            }
            IDeclaration fieldsDecl = this.parseTypeSpecifierList(typeSpecifier, null);
            if (!(fieldsDecl instanceof StructDeclaration)) {
                throw new ParseException("fields expects a struct");
            }
            StructDeclaration fields = (StructDeclaration)fieldsDecl;
            event.setFields(fields);
        } else if (left.equals("loglevel")) {
            long logLevel = IOStructGen.parseUnaryInteger((CommonTree)rightNode.getChild(0));
            event.setLogLevel(logLevel);
        } else {
            String right = IOStructGen.parseUnaryString((CommonTree)rightNode.getChild(0));
            event.setCustomAttribute(left, right);
        }
    }

    private void parseRootDeclaration(CommonTree declaration) throws ParseException {
        List children = declaration.getChildren();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 106: {
                    this.parseTypedef(child);
                    break;
                }
                case 107: {
                    this.parseTypealias(child);
                    break;
                }
                case 89: {
                    this.parseTypeSpecifierList(child, null);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
    }

    private void parseTypealias(CommonTree typealias) throws ParseException {
        List children = typealias.getChildren();
        CommonTree target = null;
        CommonTree alias = null;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 108: {
                    target = child;
                    break;
                }
                case 109: {
                    alias = child;
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        IDeclaration targetDeclaration = this.parseTypealiasTarget(target);
        if (targetDeclaration instanceof VariantDeclaration && ((VariantDeclaration)targetDeclaration).isTagged()) {
            throw new ParseException("Typealias of untagged variant is not permitted");
        }
        String aliasString = IOStructGen.parseTypealiasAlias(alias);
        this.getCurrentScope().registerType(aliasString, targetDeclaration);
    }

    private IDeclaration parseTypealiasTarget(CommonTree target) throws ParseException {
        List children = target.getChildren();
        CommonTree typeSpecifierList = null;
        CommonTree typeDeclaratorList = null;
        CommonTree typeDeclarator = null;
        StringBuilder identifierSB = new StringBuilder();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 89: {
                    typeSpecifierList = child;
                    break;
                }
                case 90: {
                    typeDeclaratorList = child;
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (typeDeclaratorList != null) {
            if (typeDeclaratorList.getChildCount() != 1) {
                throw new ParseException("Only one type declarator is allowed in the typealias target");
            }
            typeDeclarator = (CommonTree)typeDeclaratorList.getChild(0);
        }
        IDeclaration targetDeclaration = this.parseTypeDeclarator(typeDeclarator, typeSpecifierList, identifierSB);
        if (identifierSB.length() > 0) {
            throw new ParseException("Identifier (" + identifierSB.toString() + ") not expected in the typealias target");
        }
        return targetDeclaration;
    }

    private static String parseTypealiasAlias(CommonTree alias) throws ParseException {
        List children = alias.getChildren();
        CommonTree typeSpecifierList = null;
        CommonTree typeDeclaratorList = null;
        CommonTree typeDeclarator = null;
        LinkedList<CommonTree> pointers = new LinkedList<CommonTree>();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 89: {
                    typeSpecifierList = child;
                    break;
                }
                case 90: {
                    typeDeclaratorList = child;
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (typeDeclaratorList != null) {
            if (typeDeclaratorList.getChildCount() != 1) {
                throw new ParseException("Only one type declarator is allowed in the typealias alias");
            }
            typeDeclarator = (CommonTree)typeDeclaratorList.getChild(0);
            List typeDeclaratorChildren = typeDeclarator.getChildren();
            for (CommonTree child : typeDeclaratorChildren) {
                switch (child.getType()) {
                    case 49: {
                        pointers.add(child);
                        break;
                    }
                    case 79: {
                        throw new ParseException("Identifier (" + child.getText() + ") not expected in the typealias target");
                    }
                    default: {
                        IOStructGen.childTypeError(child);
                    }
                }
            }
        }
        return IOStructGen.createTypeDeclarationString(typeSpecifierList, pointers);
    }

    private void parseTypedef(CommonTree typedef) throws ParseException {
        CommonTree typeDeclaratorListNode = (CommonTree)typedef.getFirstChildWithType(90);
        CommonTree typeSpecifierListNode = (CommonTree)typedef.getFirstChildWithType(89);
        List typeDeclaratorList = typeDeclaratorListNode.getChildren();
        for (CommonTree typeDeclaratorNode : typeDeclaratorList) {
            StringBuilder identifierSB;
            IDeclaration typeDeclaration = this.parseTypeDeclarator(typeDeclaratorNode, typeSpecifierListNode, identifierSB = new StringBuilder());
            if (typeDeclaration instanceof VariantDeclaration && ((VariantDeclaration)typeDeclaration).isTagged()) {
                throw new ParseException("Typealias of untagged variant is not permitted");
            }
            this.getCurrentScope().registerType(identifierSB.toString(), typeDeclaration);
        }
    }

    private IDeclaration parseTypeDeclarator(CommonTree typeDeclarator, CommonTree typeSpecifierList, StringBuilder identifierSB) throws ParseException {
        IDeclaration declaration = null;
        List children = null;
        LinkedList<CommonTree> pointers = new LinkedList<CommonTree>();
        LinkedList<CommonTree> lengths = new LinkedList<CommonTree>();
        CommonTree identifier = null;
        if (typeDeclarator != null) {
            children = typeDeclarator.getChildren();
            for (CommonTree child : children) {
                switch (child.getType()) {
                    case 49: {
                        pointers.add(child);
                        break;
                    }
                    case 79: {
                        identifier = child;
                        break;
                    }
                    case 105: {
                        lengths.add(child);
                        break;
                    }
                    default: {
                        IOStructGen.childTypeError(child);
                    }
                }
            }
        }
        declaration = this.parseTypeSpecifierList(typeSpecifierList, pointers);
        if (lengths.size() > 0) {
            Collections.reverse(lengths);
            for (CommonTree length : lengths) {
                List lengthChildren = length.getChildren();
                CommonTree first = (CommonTree)lengthChildren.get(0);
                if (IOStructGen.isUnaryInteger(first)) {
                    int arrayLength = (int)IOStructGen.parseUnaryInteger(first);
                    if (arrayLength < 1) {
                        throw new ParseException("Array length is negative");
                    }
                    declaration = new ArrayDeclaration(arrayLength, declaration);
                    continue;
                }
                if (IOStructGen.isAnyUnaryString(first)) {
                    String lengthName = IOStructGen.concatenateUnaryStrings(lengthChildren);
                    declaration = new SequenceDeclaration(lengthName, declaration);
                    continue;
                }
                IOStructGen.childTypeError(first);
            }
        }
        if (identifier != null) {
            identifierSB.append(identifier.getText());
        }
        return declaration;
    }

    private IDeclaration parseTypeSpecifierList(CommonTree typeSpecifierList, List<CommonTree> pointerList) throws ParseException {
        IDeclaration declaration = null;
        CommonTree firstChild = (CommonTree)typeSpecifierList.getChild(0);
        switch (firstChild.getType()) {
            case 112: {
                declaration = this.parseFloat(firstChild);
                break;
            }
            case 110: {
                declaration = this.parseInteger(firstChild);
                break;
            }
            case 111: {
                declaration = IOStructGen.parseString(firstChild);
                break;
            }
            case 92: {
                declaration = this.parseStruct(firstChild);
                break;
            }
            case 120: {
                declaration = this.parseVariant(firstChild);
                break;
            }
            case 113: {
                declaration = this.parseEnum(firstChild);
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 79: {
                declaration = this.parseTypeDeclaration(typeSpecifierList, pointerList);
                break;
            }
            default: {
                IOStructGen.childTypeError(firstChild);
            }
        }
        return declaration;
    }

    private IDeclaration parseFloat(CommonTree floatingPoint) throws ParseException {
        List children = floatingPoint.getChildren();
        if (children == null) {
            throw new ParseException("float: missing size attribute");
        }
        FloatDeclaration floatDeclaration = null;
        ByteOrder byteOrder = this.trace.getByteOrder();
        long alignment = 0L;
        int exponent = 8;
        int mantissa = 24;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 97: {
                    CommonTree leftNode = (CommonTree)child.getChild(0);
                    CommonTree rightNode = (CommonTree)child.getChild(1);
                    List leftStrings = leftNode.getChildren();
                    if (!IOStructGen.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
                        throw new ParseException("Left side of ctf expression must be a string");
                    }
                    String left = IOStructGen.concatenateUnaryStrings(leftStrings);
                    if (left.equals("exp_dig")) {
                        exponent = (int)IOStructGen.parseUnaryInteger((CommonTree)rightNode.getChild(0));
                        break;
                    }
                    if (left.equals("byte_order")) {
                        byteOrder = this.getByteOrder(rightNode);
                        break;
                    }
                    if (left.equals("mant_dig")) {
                        mantissa = (int)IOStructGen.parseUnaryInteger((CommonTree)rightNode.getChild(0));
                        break;
                    }
                    if (left.equals("align")) {
                        alignment = IOStructGen.getAlignment(rightNode);
                        break;
                    }
                    throw new ParseException("Float: unknown attribute " + left);
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        int size = mantissa + exponent;
        if (size == 0) {
            throw new ParseException("Float missing size attribute");
        }
        if (alignment == 0L) {
            alignment = size % 8 == 0 ? 1L : 8L;
        }
        floatDeclaration = new FloatDeclaration(exponent, mantissa, byteOrder, alignment);
        return floatDeclaration;
    }

    private IDeclaration parseTypeDeclaration(CommonTree typeSpecifierList, List<CommonTree> pointerList) throws ParseException {
        String typeStringRepresentation = IOStructGen.createTypeDeclarationString(typeSpecifierList, pointerList);
        IDeclaration decl = this.getCurrentScope().rlookupType(typeStringRepresentation);
        if (decl == null) {
            throw new ParseException("Type " + typeStringRepresentation + " has not been defined.");
        }
        return decl;
    }

    private IntegerDeclaration parseInteger(CommonTree integer) throws ParseException {
        List children = integer.getChildren();
        if (children == null) {
            throw new ParseException("integer: missing size attribute");
        }
        IntegerDeclaration integerDeclaration = null;
        boolean signed = false;
        ByteOrder byteOrder = this.trace.getByteOrder();
        long size = 0L;
        long alignment = 0L;
        int base = 10;
        String clock = null;
        Encoding encoding = Encoding.NONE;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 97: {
                    CommonTree leftNode = (CommonTree)child.getChild(0);
                    CommonTree rightNode = (CommonTree)child.getChild(1);
                    List leftStrings = leftNode.getChildren();
                    if (!IOStructGen.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
                        throw new ParseException("Left side of ctf expression must be a string");
                    }
                    String left = IOStructGen.concatenateUnaryStrings(leftStrings);
                    if (left.equals("signed")) {
                        signed = IOStructGen.getSigned(rightNode);
                        break;
                    }
                    if (left.equals("byte_order")) {
                        byteOrder = this.getByteOrder(rightNode);
                        break;
                    }
                    if (left.equals("size")) {
                        size = IOStructGen.getSize(rightNode);
                        break;
                    }
                    if (left.equals("align")) {
                        alignment = IOStructGen.getAlignment(rightNode);
                        break;
                    }
                    if (left.equals("base")) {
                        base = IOStructGen.getBase(rightNode);
                        break;
                    }
                    if (left.equals("encoding")) {
                        encoding = IOStructGen.getEncoding(rightNode);
                        break;
                    }
                    if (left.equals("map")) {
                        clock = IOStructGen.getClock(rightNode);
                        break;
                    }
                    Activator.log(2, String.valueOf(Messages.IOStructGen_UnknownIntegerAttributeWarning) + " " + left);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (size == 0L) {
            throw new ParseException("Integer missing size attribute");
        }
        if (alignment == 0L) {
            alignment = size % 8L == 0L ? 1L : 8L;
        }
        integerDeclaration = new IntegerDeclaration((int)size, signed, base, byteOrder, encoding, clock, alignment);
        return integerDeclaration;
    }

    private static String getClock(CommonTree rightNode) {
        return rightNode.getChild(1).getChild(0).getChild(0).getText();
    }

    private static StringDeclaration parseString(CommonTree string) throws ParseException {
        List children = string.getChildren();
        StringDeclaration stringDeclaration = null;
        if (children == null) {
            stringDeclaration = new StringDeclaration();
        } else {
            Encoding encoding = Encoding.UTF8;
            for (CommonTree child : children) {
                switch (child.getType()) {
                    case 97: {
                        CommonTree leftNode = (CommonTree)child.getChild(0);
                        CommonTree rightNode = (CommonTree)child.getChild(1);
                        List leftStrings = leftNode.getChildren();
                        if (!IOStructGen.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
                            throw new ParseException("Left side of ctf expression must be a string");
                        }
                        String left = IOStructGen.concatenateUnaryStrings(leftStrings);
                        if (left.equals("encoding")) {
                            encoding = IOStructGen.getEncoding(rightNode);
                            break;
                        }
                        throw new ParseException("String: unknown attribute " + left);
                    }
                    default: {
                        IOStructGen.childTypeError(child);
                    }
                }
            }
            stringDeclaration = new StringDeclaration(encoding);
        }
        return stringDeclaration;
    }

    private StructDeclaration parseStruct(CommonTree struct) throws ParseException {
        List children = struct.getChildren();
        StructDeclaration structDeclaration = null;
        String structName = null;
        boolean hasName = false;
        CommonTree structBody = null;
        boolean hasBody = false;
        long structAlign = 0L;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 93: {
                    hasName = true;
                    CommonTree structNameIdentifier = (CommonTree)child.getChild(0);
                    structName = structNameIdentifier.getText();
                    break;
                }
                case 94: {
                    hasBody = true;
                    structBody = child;
                    break;
                }
                case 95: {
                    CommonTree structAlignExpression = (CommonTree)child.getChild(0);
                    structAlign = IOStructGen.getAlignment(structAlignExpression);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (hasBody) {
            if (hasName && this.getCurrentScope().lookupStruct(structName) != null) {
                throw new ParseException("struct " + structName + " already defined.");
            }
            structDeclaration = new StructDeclaration(structAlign);
            this.parseStructBody(structBody, structDeclaration);
            if (hasName) {
                this.getCurrentScope().registerStruct(structName, structDeclaration);
            }
        } else if (hasName) {
            structDeclaration = this.getCurrentScope().rlookupStruct(structName);
            if (structDeclaration == null) {
                throw new ParseException("struct " + structName + " is not defined");
            }
        } else {
            throw new ParseException("struct with no name and no body");
        }
        return structDeclaration;
    }

    private void parseStructBody(CommonTree structBody, StructDeclaration structDeclaration) throws ParseException {
        List structDeclarations = structBody.getChildren();
        if (structDeclarations != null) {
            this.pushScope();
            for (CommonTree declarationNode : structDeclarations) {
                switch (declarationNode.getType()) {
                    case 107: {
                        this.parseTypealias(declarationNode);
                        break;
                    }
                    case 106: {
                        this.parseTypedef(declarationNode);
                        break;
                    }
                    case 88: {
                        this.parseStructDeclaration(declarationNode, structDeclaration);
                        break;
                    }
                    default: {
                        IOStructGen.childTypeError(declarationNode);
                    }
                }
            }
            this.popScope();
        }
    }

    private void parseStructDeclaration(CommonTree declaration, StructDeclaration struct) throws ParseException {
        CommonTree typeSpecifierListNode = (CommonTree)declaration.getFirstChildWithType(89);
        CommonTree typeDeclaratorListNode = (CommonTree)declaration.getFirstChildWithType(90);
        List typeDeclaratorList = typeDeclaratorListNode.getChildren();
        for (CommonTree typeDeclaratorNode : typeDeclaratorList) {
            StringBuilder identifierSB = new StringBuilder();
            IDeclaration decl = this.parseTypeDeclarator(typeDeclaratorNode, typeSpecifierListNode, identifierSB);
            String fieldName = identifierSB.toString();
            if (struct.hasField(fieldName)) {
                throw new ParseException("struct: duplicate field " + fieldName);
            }
            struct.addField(fieldName, decl);
        }
    }

    private EnumDeclaration parseEnum(CommonTree theEnum) throws ParseException {
        List children = theEnum.getChildren();
        EnumDeclaration enumDeclaration = null;
        String enumName = null;
        CommonTree enumBody = null;
        IntegerDeclaration containerTypeDeclaration = null;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 116: {
                    CommonTree enumNameIdentifier = (CommonTree)child.getChild(0);
                    enumName = enumNameIdentifier.getText();
                    break;
                }
                case 119: {
                    enumBody = child;
                    break;
                }
                case 114: {
                    containerTypeDeclaration = this.parseEnumContainerType(child);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (containerTypeDeclaration == null) {
            EnumDeclaration enumDecl;
            if (enumName != null && (enumDecl = this.getCurrentScope().rlookupEnum(enumName)) != null) {
                return enumDecl;
            }
            IDeclaration decl = this.getCurrentScope().rlookupType("int");
            if (decl == null) {
                throw new ParseException("enum container type implicit and type int not defined");
            }
            if (!(decl instanceof IntegerDeclaration)) {
                throw new ParseException("enum container type implicit and type int not an integer");
            }
            containerTypeDeclaration = (IntegerDeclaration)decl;
        }
        if (enumBody != null) {
            if (enumName != null && this.getCurrentScope().lookupEnum(enumName) != null) {
                throw new ParseException("enum " + enumName + " already defined");
            }
            enumDeclaration = new EnumDeclaration(containerTypeDeclaration);
            this.parseEnumBody(enumBody, enumDeclaration);
            if (enumName != null) {
                this.getCurrentScope().registerEnum(enumName, enumDeclaration);
            }
        } else if (enumName != null) {
            enumDeclaration = this.getCurrentScope().rlookupEnum(enumName);
            if (enumDeclaration == null) {
                throw new ParseException("enum " + enumName + " is not defined");
            }
        } else {
            throw new ParseException("enum with no name and no body");
        }
        return enumDeclaration;
    }

    private void parseEnumBody(CommonTree enumBody, EnumDeclaration enumDeclaration) throws ParseException {
        List enumerators = enumBody.getChildren();
        this.pushScope();
        long lastHigh = -1L;
        for (CommonTree enumerator : enumerators) {
            lastHigh = IOStructGen.parseEnumEnumerator(enumerator, enumDeclaration, lastHigh);
        }
        this.popScope();
    }

    private static long parseEnumEnumerator(CommonTree enumerator, EnumDeclaration enumDeclaration, long lastHigh) throws ParseException {
        List children = enumerator.getChildren();
        long low = 0L;
        long high = 0L;
        boolean valueSpecified = false;
        String label = null;
        for (CommonTree child : children) {
            if (IOStructGen.isAnyUnaryString(child)) {
                label = IOStructGen.parseUnaryString(child);
                continue;
            }
            if (child.getType() == 117) {
                valueSpecified = true;
                high = low = IOStructGen.parseUnaryInteger((CommonTree)child.getChild(0));
                continue;
            }
            if (child.getType() == 118) {
                valueSpecified = true;
                low = IOStructGen.parseUnaryInteger((CommonTree)child.getChild(0));
                high = IOStructGen.parseUnaryInteger((CommonTree)child.getChild(1));
                continue;
            }
            IOStructGen.childTypeError(child);
        }
        if (!valueSpecified) {
            high = low = lastHigh + 1L;
        }
        if (low > high) {
            throw new ParseException("enum low value greater than high value");
        }
        if (!enumDeclaration.add(low, high, label)) {
            throw new ParseException("enum declarator values overlap.");
        }
        if (valueSpecified && (BigInteger.valueOf(low).compareTo(enumDeclaration.getContainerType().getMinValue()) == -1 || BigInteger.valueOf(high).compareTo(enumDeclaration.getContainerType().getMaxValue()) == 1)) {
            throw new ParseException("enum value is not in range");
        }
        return high;
    }

    private IntegerDeclaration parseEnumContainerType(CommonTree enumContainerType) throws ParseException {
        CommonTree typeSpecifierList = (CommonTree)enumContainerType.getChild(0);
        IDeclaration decl = this.parseTypeSpecifierList(typeSpecifierList, null);
        if (decl instanceof IntegerDeclaration) {
            return (IntegerDeclaration)decl;
        }
        throw new ParseException("enum container type must be an integer");
    }

    private VariantDeclaration parseVariant(CommonTree variant) throws ParseException {
        List children = variant.getChildren();
        VariantDeclaration variantDeclaration = null;
        boolean hasName = false;
        String variantName = null;
        boolean hasBody = false;
        CommonTree variantBody = null;
        boolean hasTag = false;
        String variantTag = null;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 121: {
                    hasName = true;
                    CommonTree variantNameIdentifier = (CommonTree)child.getChild(0);
                    variantName = variantNameIdentifier.getText();
                    break;
                }
                case 122: {
                    hasTag = true;
                    CommonTree variantTagIdentifier = (CommonTree)child.getChild(0);
                    variantTag = variantTagIdentifier.getText();
                    break;
                }
                case 123: {
                    hasBody = true;
                    variantBody = child;
                    break;
                }
                default: {
                    IOStructGen.childTypeError(child);
                }
            }
        }
        if (hasBody) {
            if (hasName && this.getCurrentScope().lookupVariant(variantName) != null) {
                throw new ParseException("variant " + variantName + " already defined.");
            }
            variantDeclaration = new VariantDeclaration();
            this.parseVariantBody(variantBody, variantDeclaration);
            if (hasName) {
                this.getCurrentScope().registerVariant(variantName, variantDeclaration);
            }
        } else if (hasName) {
            variantDeclaration = this.getCurrentScope().rlookupVariant(variantName);
            if (variantDeclaration == null) {
                throw new ParseException("variant " + variantName + " is not defined");
            }
        } else {
            throw new ParseException("variant with no name and no body");
        }
        if (hasTag) {
            variantDeclaration.setTag(variantTag);
        }
        return variantDeclaration;
    }

    private void parseVariantBody(CommonTree variantBody, VariantDeclaration variantDeclaration) throws ParseException {
        List variantDeclarations = variantBody.getChildren();
        this.pushScope();
        for (CommonTree declarationNode : variantDeclarations) {
            switch (declarationNode.getType()) {
                case 107: {
                    this.parseTypealias(declarationNode);
                    break;
                }
                case 106: {
                    this.parseTypedef(declarationNode);
                    break;
                }
                case 88: {
                    this.parseVariantDeclaration(declarationNode, variantDeclaration);
                    break;
                }
                default: {
                    IOStructGen.childTypeError(declarationNode);
                }
            }
        }
        this.popScope();
    }

    private void parseVariantDeclaration(CommonTree declaration, VariantDeclaration variant) throws ParseException {
        CommonTree typeSpecifierListNode = (CommonTree)declaration.getFirstChildWithType(89);
        CommonTree typeDeclaratorListNode = (CommonTree)declaration.getFirstChildWithType(90);
        List typeDeclaratorList = typeDeclaratorListNode.getChildren();
        for (CommonTree typeDeclaratorNode : typeDeclaratorList) {
            StringBuilder identifierSB = new StringBuilder();
            IDeclaration decl = this.parseTypeDeclarator(typeDeclaratorNode, typeSpecifierListNode, identifierSB);
            if (variant.hasField(identifierSB.toString())) {
                throw new ParseException("variant: duplicate field " + identifierSB.toString());
            }
            variant.addField(identifierSB.toString(), decl);
        }
    }

    private static String createTypeDeclarationString(CommonTree typeSpecifierList, List<CommonTree> pointers) throws ParseException {
        StringBuilder sb = new StringBuilder();
        IOStructGen.createTypeSpecifierListString(typeSpecifierList, sb);
        IOStructGen.createPointerListString(pointers, sb);
        return sb.toString();
    }

    private static void createTypeSpecifierListString(CommonTree typeSpecifierList, StringBuilder sb) throws ParseException {
        List children = typeSpecifierList.getChildren();
        boolean firstItem = true;
        for (CommonTree child : children) {
            if (!firstItem) {
                sb.append(' ');
            }
            firstItem = false;
            IOStructGen.createTypeSpecifierString(child, sb);
        }
    }

    private static void createTypeSpecifierString(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        switch (typeSpecifier.getType()) {
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 79: {
                sb.append(typeSpecifier.getText());
                break;
            }
            case 92: {
                CommonTree structName = (CommonTree)typeSpecifier.getFirstChildWithType(93);
                if (structName == null) {
                    throw new ParseException("nameless struct found in createTypeSpecifierString");
                }
                CommonTree structNameIdentifier = (CommonTree)structName.getChild(0);
                sb.append(structNameIdentifier.getText());
                break;
            }
            case 120: {
                CommonTree variantName = (CommonTree)typeSpecifier.getFirstChildWithType(121);
                if (variantName == null) {
                    throw new ParseException("nameless variant found in createTypeSpecifierString");
                }
                CommonTree variantNameIdentifier = (CommonTree)variantName.getChild(0);
                sb.append(variantNameIdentifier.getText());
                break;
            }
            case 113: {
                CommonTree enumName = (CommonTree)typeSpecifier.getFirstChildWithType(116);
                if (enumName == null) {
                    throw new ParseException("nameless enum found in createTypeSpecifierString");
                }
                CommonTree enumNameIdentifier = (CommonTree)enumName.getChild(0);
                sb.append(enumNameIdentifier.getText());
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                throw new ParseException("CTF type found in createTypeSpecifierString");
            }
            default: {
                IOStructGen.childTypeError(typeSpecifier);
            }
        }
    }

    private static void createPointerListString(List<CommonTree> pointerList, StringBuilder sb) {
        if (pointerList == null) {
            return;
        }
        for (CommonTree pointer : pointerList) {
            sb.append(" *");
            if (pointer.getChildCount() <= 0) continue;
            sb.append(" const");
        }
    }

    private static boolean isUnaryString(CommonTree node) {
        return node.getType() == 100;
    }

    private static boolean isAnyUnaryString(CommonTree node) {
        return node.getType() == 100 || node.getType() == 101;
    }

    private static boolean isUnaryInteger(CommonTree node) {
        return node.getType() == 102 || node.getType() == 103 || node.getType() == 104;
    }

    private static String parseUnaryString(CommonTree unaryString) {
        CommonTree value = (CommonTree)unaryString.getChild(0);
        String strval = value.getText();
        if (unaryString.getType() == 101) {
            strval = strval.substring(1, strval.length() - 1);
        }
        return strval;
    }

    private static long parseUnaryInteger(CommonTree unaryInteger) throws ParseException {
        long intval;
        List children = unaryInteger.getChildren();
        CommonTree value = (CommonTree)children.get(0);
        String strval = value.getText();
        try {
            intval = unaryInteger.getType() == 102 ? Long.parseLong(strval, 10) : (unaryInteger.getType() == 103 ? Long.parseLong(strval, 16) : Long.parseLong(strval, 8));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid integer format: " + strval);
        }
        if (children.size() % 2 == 0) {
            return -intval;
        }
        return intval;
    }

    private static long getMajorOrMinor(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryInteger(firstChild)) {
            if (rightNode.getChildCount() > 1) {
                throw new ParseException("Invalid value for major/minor");
            }
            long m = IOStructGen.parseUnaryInteger(firstChild);
            if (m < 0L) {
                throw new ParseException("Invalid value for major/minor");
            }
            return m;
        }
        throw new ParseException("Invalid value for major/minor");
    }

    private static UUID getUUID(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isAnyUnaryString(firstChild)) {
            if (rightNode.getChildCount() > 1) {
                throw new ParseException("Invalid value for UUID");
            }
            String uuidstr = IOStructGen.parseUnaryString(firstChild);
            try {
                return UUID.fromString(uuidstr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Invalid format for UUID");
            }
        }
        throw new ParseException("Invalid value for UUID");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getSigned(CommonTree rightNode) throws ParseException {
        boolean ret = false;
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryString(firstChild)) {
            String strval = IOStructGen.concatenateUnaryStrings(rightNode.getChildren());
            if (strval.equals("true")) return true;
            if (strval.equals("TRUE")) {
                return true;
            }
            if (strval.equals("false")) return false;
            if (!strval.equals("FALSE")) throw new ParseException("Invalid boolean value " + firstChild.getChild(0).getText());
            return false;
        }
        if (!IOStructGen.isUnaryInteger(firstChild)) throw new ParseException();
        if (rightNode.getChildCount() > 1) {
            throw new ParseException("Invalid boolean value");
        }
        long intval = IOStructGen.parseUnaryInteger(firstChild);
        if (intval == 1L) {
            return true;
        }
        if (intval != 0L) throw new ParseException("Invalid boolean value " + firstChild.getChild(0).getText());
        return false;
    }

    private ByteOrder getByteOrder(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryString(firstChild)) {
            String strval = IOStructGen.concatenateUnaryStrings(rightNode.getChildren());
            if (strval.equals("le")) {
                return ByteOrder.LITTLE_ENDIAN;
            }
            if (strval.equals("be") || strval.equals("network")) {
                return ByteOrder.BIG_ENDIAN;
            }
            if (strval.equals("native")) {
                return this.trace.getByteOrder();
            }
            throw new ParseException("Invalid value for byte order");
        }
        throw new ParseException("Invalid value for byte order");
    }

    private static boolean isValidAlignment(long alignment) {
        return alignment > 0L && (alignment & alignment - 1L) == 0L;
    }

    private static long getSize(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryInteger(firstChild)) {
            if (rightNode.getChildCount() > 1) {
                throw new ParseException("Invalid value for size");
            }
            long size = IOStructGen.parseUnaryInteger(firstChild);
            if (size < 1L) {
                throw new ParseException("Invalid value for size");
            }
            return size;
        }
        throw new ParseException("Invalid value for size");
    }

    private static long getAlignment(CommonTree node) throws ParseException {
        if (node.getType() == 99) {
            if (node.getChildCount() > 1) {
                throw new ParseException("Invalid alignment value");
            }
            return IOStructGen.getAlignment((CommonTree)node.getChild(0));
        }
        if (IOStructGen.isUnaryInteger(node)) {
            long alignment = IOStructGen.parseUnaryInteger(node);
            if (!IOStructGen.isValidAlignment(alignment)) {
                throw new ParseException("Invalid value for alignment : " + alignment);
            }
            return alignment;
        }
        throw new ParseException("Invalid value for alignment");
    }

    private static int getBase(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryInteger(firstChild)) {
            if (rightNode.getChildCount() > 1) {
                throw new ParseException("invalid base value");
            }
            long intval = IOStructGen.parseUnaryInteger(firstChild);
            if (intval == 2L || intval == 8L || intval == 10L || intval == 16L) {
                return (int)intval;
            }
            throw new ParseException("Invalid value for base");
        }
        if (IOStructGen.isUnaryString(firstChild)) {
            String strval = IOStructGen.concatenateUnaryStrings(rightNode.getChildren());
            if (strval.equals("decimal") || strval.equals("dec") || strval.equals("d") || strval.equals("i") || strval.equals("u")) {
                return 10;
            }
            if (strval.equals("hexadecimal") || strval.equals("hex") || strval.equals("x") || strval.equals("X") || strval.equals("p")) {
                return 16;
            }
            if (strval.equals("octal") || strval.equals("oct") || strval.equals("o")) {
                return 8;
            }
            if (strval.equals("binary") || strval.equals("b")) {
                return 2;
            }
            throw new ParseException("Invalid value for base");
        }
        throw new ParseException("invalid value for base");
    }

    private static Encoding getEncoding(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryString(firstChild)) {
            String strval = IOStructGen.concatenateUnaryStrings(rightNode.getChildren());
            if (strval.equals("UTF8")) {
                return Encoding.UTF8;
            }
            if (strval.equals("ASCII")) {
                return Encoding.ASCII;
            }
            if (strval.equals("none")) {
                return Encoding.NONE;
            }
            throw new ParseException("Invalid value for encoding");
        }
        throw new ParseException("Invalid value for encoding");
    }

    private static long getStreamID(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryInteger(firstChild)) {
            if (rightNode.getChildCount() > 1) {
                throw new ParseException("invalid value for stream id");
            }
            long intval = IOStructGen.parseUnaryInteger(firstChild);
            return intval;
        }
        throw new ParseException("invalid value for stream id");
    }

    private static String getEventName(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isAnyUnaryString(firstChild)) {
            String str = IOStructGen.concatenateUnaryStrings(rightNode.getChildren());
            return str;
        }
        throw new ParseException("invalid value for event name");
    }

    private static long getEventID(CommonTree rightNode) throws ParseException {
        CommonTree firstChild = (CommonTree)rightNode.getChild(0);
        if (IOStructGen.isUnaryInteger(firstChild)) {
            if (rightNode.getChildCount() > 1) {
                throw new ParseException("invalid value for event id");
            }
            long intval = IOStructGen.parseUnaryInteger(firstChild);
            return intval;
        }
        throw new ParseException("invalid value for event id");
    }

    private static String concatenateUnaryStrings(List<CommonTree> strings) {
        StringBuilder sb = new StringBuilder();
        CommonTree first = strings.get(0);
        sb.append(IOStructGen.parseUnaryString(first));
        boolean isFirst = true;
        for (CommonTree ref : strings) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            CommonTree id = (CommonTree)ref.getChild(0);
            if (ref.getType() == 51) {
                sb.append("->");
            } else {
                sb.append('.');
            }
            sb.append(IOStructGen.parseUnaryString(id));
        }
        return sb.toString();
    }

    private static void childTypeError(CommonTree child) throws ParseException {
        CommonTree parent = (CommonTree)child.getParent();
        String error = "Parent " + CTFParser.tokenNames[parent.getType()] + " can't have a child of type " + CTFParser.tokenNames[child.getType()] + ".";
        throw new ParseException(error);
    }

    private void pushScope() {
        this.scope = new DeclarationScope(this.scope);
    }

    private void popScope() {
        this.scope = this.scope.getParentScope();
    }

    private DeclarationScope getCurrentScope() {
        return this.scope;
    }
}

