/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class SelectTraceTypeContributionItem
extends CompoundContributionItem {
    private static final ImageDescriptor SELECTED_ICON = Activator.getDefault().getImageDescripterFromPath("icons/elcl16/bullet.gif");
    private static final String BUNDLE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.bundle";
    private static final String TYPE_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.type";
    private static final String ICON_PARAMETER = "org.eclipse.linuxtools.tmf.ui.commandparameter.select_trace_type.icon";
    private static final String SELECT_TRACE_TYPE_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.select_trace_type";
    private static final String CUSTOM_TXT_CATEGORY = "Custom Text";
    private static final String CUSTOM_XML_CATEGORY = "Custom XML";
    private static final String DEFAULT_TRACE_ICON_PATH = "icons/elcl16/trace.gif";

    protected IContributionItem[] getContributionItems() {
        MenuManager subMenu;
        boolean selected;
        String label;
        String traceIcon;
        String traceTypeId;
        String traceBundle;
        CustomXmlTraceDefinition[] customXmlTraceDefinitions;
        IConfigurationElement[] config;
        HashSet<String> selectedTraceTypes = new HashSet<String>();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ISelection selection = page.getSelection();
        if (selection instanceof StructuredSelection) {
            for (Object element : ((StructuredSelection)selection).toList()) {
                if (!(element instanceof TmfTraceElement)) continue;
                TmfTraceElement trace = (TmfTraceElement)element;
                selectedTraceTypes.add(trace.getTraceType());
            }
        }
        LinkedList<IContributionItem> list = new LinkedList<IContributionItem>();
        HashMap<String, MenuManager> categoriesMap = new HashMap<String, MenuManager>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("category")) {
                String categoryId = ce.getAttribute("id");
                ImageDescriptor icon = SelectTraceTypeContributionItem.isSelectedCategory(categoryId, config, selectedTraceTypes) ? SELECTED_ICON : null;
                MenuManager subMenu2 = new MenuManager(ce.getAttribute("name"), icon, null);
                categoriesMap.put(categoryId, subMenu2);
                list.add((IContributionItem)subMenu2);
            }
            ++n2;
        }
        CustomTxtTraceDefinition[] customTxtTraceDefinitions = CustomTxtTraceDefinition.loadAll();
        if (customTxtTraceDefinitions.length > 0) {
            ImageDescriptor icon = SelectTraceTypeContributionItem.isSelectedCategory(customTxtTraceDefinitions, selectedTraceTypes) ? SELECTED_ICON : null;
            MenuManager subMenu3 = new MenuManager(CUSTOM_TXT_CATEGORY, icon, null);
            categoriesMap.put(CUSTOM_TXT_CATEGORY, subMenu3);
            list.add((IContributionItem)subMenu3);
        }
        if ((customXmlTraceDefinitions = CustomXmlTraceDefinition.loadAll()).length > 0) {
            ImageDescriptor icon = SelectTraceTypeContributionItem.isSelectedCategory(customXmlTraceDefinitions, selectedTraceTypes) ? SELECTED_ICON : null;
            MenuManager subMenu4 = new MenuManager(CUSTOM_XML_CATEGORY, icon, null);
            categoriesMap.put(CUSTOM_XML_CATEGORY, subMenu4);
            list.add((IContributionItem)subMenu4);
        }
        Object[] objectArray = config;
        int n3 = config.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement ce = objectArray[n4];
            if (ce.getName().equals("type")) {
                traceBundle = ce.getContributor().getName();
                traceTypeId = ce.getAttribute("id");
                traceIcon = ce.getAttribute("icon");
                label = ce.getAttribute("name").replaceAll("&", "&&");
                selected = selectedTraceTypes.contains(traceTypeId);
                subMenu = (MenuManager)categoriesMap.get(ce.getAttribute("category"));
                SelectTraceTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            }
            ++n4;
        }
        objectArray = customTxtTraceDefinitions;
        n3 = customTxtTraceDefinitions.length;
        n4 = 0;
        while (n4 < n3) {
            IConfigurationElement def = objectArray[n4];
            traceBundle = Activator.getDefault().getBundle().getSymbolicName();
            traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + def.definitionName;
            traceIcon = DEFAULT_TRACE_ICON_PATH;
            label = def.definitionName;
            selected = selectedTraceTypes.contains(traceTypeId);
            subMenu = (MenuManager)categoriesMap.get(CUSTOM_TXT_CATEGORY);
            SelectTraceTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            ++n4;
        }
        objectArray = customXmlTraceDefinitions;
        n3 = customXmlTraceDefinitions.length;
        n4 = 0;
        while (n4 < n3) {
            IConfigurationElement def = objectArray[n4];
            traceBundle = Activator.getDefault().getBundle().getSymbolicName();
            traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + def.definitionName;
            traceIcon = DEFAULT_TRACE_ICON_PATH;
            label = def.definitionName;
            selected = selectedTraceTypes.contains(traceTypeId);
            subMenu = (MenuManager)categoriesMap.get(CUSTOM_XML_CATEGORY);
            SelectTraceTypeContributionItem.addContributionItem(list, traceBundle, traceTypeId, traceIcon, label, selected, subMenu);
            ++n4;
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private static void addContributionItem(List<IContributionItem> list, String traceBundle, String traceTypeId, String traceIcon, String label, boolean selected, MenuManager subMenu) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(BUNDLE_PARAMETER, traceBundle);
        params.put(TYPE_PARAMETER, traceTypeId);
        params.put(ICON_PARAMETER, traceIcon);
        ImageDescriptor icon = null;
        if (selected) {
            icon = SELECTED_ICON;
        }
        CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "my.parameterid", SELECT_TRACE_TYPE_COMMAND_ID, 8);
        param.parameters = params;
        param.icon = icon;
        param.disabledIcon = icon;
        param.hoverIcon = icon;
        param.label = label;
        param.visibleEnabled = true;
        if (subMenu != null) {
            subMenu.add((IContributionItem)new CommandContributionItem(param));
        } else {
            list.add((IContributionItem)new CommandContributionItem(param));
        }
    }

    private static boolean isSelectedCategory(String categoryId, IConfigurationElement[] config, Set<String> selectedTraceTypes) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            String traceTypeId;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getName().equals("type") && selectedTraceTypes.contains(traceTypeId = ce.getAttribute("id")) && categoryId.equals(ce.getAttribute("category"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSelectedCategory(CustomTxtTraceDefinition[] customTxtTraceDefinitions, Set<String> selectedTraceTypes) {
        CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = customTxtTraceDefinitions;
        int n = customTxtTraceDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            CustomTxtTraceDefinition def = customTxtTraceDefinitionArray[n2];
            String traceTypeId = String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + def.definitionName;
            if (selectedTraceTypes.contains(traceTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSelectedCategory(CustomXmlTraceDefinition[] customXmlTraceDefinitions, Set<String> selectedTraceTypes) {
        CustomXmlTraceDefinition[] customXmlTraceDefinitionArray = customXmlTraceDefinitions;
        int n = customXmlTraceDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            CustomXmlTraceDefinition def = customXmlTraceDefinitionArray[n2];
            String traceTypeId = String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + def.definitionName;
            if (selectedTraceTypes.contains(traceTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

