/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.properties;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestampFormat;

public class TmfTimePreferences {
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss.SSS_CCC_NNN";
    static final String TIME_FORMAT_PREF = "org.eclipse.linuxtools.tmf.ui.prefs.time.format";
    static final String DATIME = "org.eclipse.linuxtools.tmf.ui.prefs.time.format.datime";
    static final String SUBSEC = "org.eclipse.linuxtools.tmf.ui.prefs.time.format.subsec";
    static final String DATE_DELIMITER = "org.eclipse.linuxtools.tmf.ui.prefs.time.format.date.delimiter";
    static final String TIME_DELIMITER = "org.eclipse.linuxtools.tmf.ui.prefs.time.format.time.delimiter";
    static final String SSEC_DELIMITER = "org.eclipse.linuxtools.tmf.ui.prefs.time.format.ssec.delimiter";
    static final String DATE_YEAR_FMT = "yyyy-MM-dd HH:mm:ss";
    static final String DATE_YEAR2_FMT = "yy-MM-dd HH:mm:ss";
    static final String DATE_MONTH_FMT = "MM-dd HH:mm:ss";
    static final String DATE_DAY_FMT = "dd HH:mm:ss";
    static final String DATE_JDAY_FMT = "DDD HH:mm:ss";
    static final String DATE_NO_FMT = "HH:mm:ss";
    static final String TIME_HOUR_FMT = "HH:mm:ss";
    static final String TIME_MINUTE_FMT = "mm:ss";
    static final String TIME_SECOND_FMT = "ss";
    static final String TIME_ELAPSED_FMT = "TTT";
    static final String TIME_NO_FMT = "";
    static final String SUBSEC_MILLI_FMT = "SSS";
    static final String SUBSEC_MICRO_FMT = "SSS CCC";
    static final String SUBSEC_NANO_FMT = "SSS CCC NNN";
    static final String SUBSEC_NO_FMT = "";
    static final String DELIMITER_NONE = "";
    static final String DELIMITER_SPACE = " ";
    static final String DELIMITER_PERIOD = ".";
    static final String DELIMITER_COMMA = ",";
    static final String DELIMITER_DASH = "-";
    static final String DELIMITER_UNDERLINE = "_";
    static final String DELIMITER_COLON = ":";
    static final String DELIMITER_SEMICOLON = ";";
    static final String DELIMITER_SLASH = "/";
    static final String DELIMITER_DQUOT = "\"";
    private static TmfTimePreferences fPreferences;
    private static IPreferenceStore fPreferenceStore;
    private static String fTimestampPattern;
    private static String fIntervalPattern;
    private String fDatimeFormat;
    private String fDateFormat;
    private String fTimeFormat;
    private String fSSecFormat;
    private String fDateFieldSep = "-";
    private String fTimeFieldSep = ":";
    private String fSSecFieldSep = " ";

    public static void init() {
        fPreferenceStore = Activator.getDefault().getPreferenceStore();
        fPreferenceStore.setDefault(DATIME, "HH:mm:ss");
        fPreferenceStore.setDefault(SUBSEC, SUBSEC_NANO_FMT);
        fPreferenceStore.setDefault(DATE_DELIMITER, DELIMITER_DASH);
        fPreferenceStore.setDefault(TIME_DELIMITER, DELIMITER_COLON);
        fPreferenceStore.setDefault(SSEC_DELIMITER, DELIMITER_SPACE);
        TmfTimePreferences.getInstance();
    }

    public static synchronized IPreferenceStore getPreferenceStore() {
        if (fPreferenceStore == null) {
            TmfTimePreferences.init();
        }
        return fPreferenceStore;
    }

    public static synchronized TmfTimePreferences getInstance() {
        if (fPreferences == null) {
            fPreferences = new TmfTimePreferences();
        }
        return fPreferences;
    }

    private TmfTimePreferences() {
        this.initPatterns();
        TmfTimePreferences.setTimePattern(fTimestampPattern);
    }

    public static String getTimePattern() {
        return fTimestampPattern;
    }

    static void setTimePattern(String timePattern) {
        fTimestampPattern = timePattern;
        TmfTimestampFormat.setDefaultTimeFormat((String)fTimestampPattern);
        TmfTimestampFormat.setDefaultIntervalFormat((String)fIntervalPattern);
    }

    void setDateFieldSep(String pattern) {
        this.fDateFieldSep = pattern;
    }

    void setTimeFieldSep(String pattern) {
        this.fTimeFieldSep = pattern;
    }

    void setSSecFieldSep(String pattern) {
        this.fSSecFieldSep = pattern;
    }

    void setDateTimeFormat(String pattern) {
        int index;
        this.fDatimeFormat = pattern;
        if (this.fDatimeFormat == null) {
            this.fDatimeFormat = DEFAULT_TIME_PATTERN;
        }
        if ((index = this.fDatimeFormat.indexOf(32)) != -1) {
            this.fDateFormat = this.fDatimeFormat.substring(0, this.fDatimeFormat.indexOf(32) + 1);
            this.fTimeFormat = this.fDatimeFormat.substring(this.fDateFormat.length());
        } else {
            this.fDateFormat = "";
            this.fTimeFormat = this.fDatimeFormat;
        }
    }

    void setSSecFormat(String pattern) {
        this.fSSecFormat = pattern;
    }

    void initPatterns() {
        this.setDateTimeFormat(fPreferenceStore.getString(DATIME));
        this.fSSecFormat = fPreferenceStore.getString(SUBSEC);
        this.fDateFieldSep = fPreferenceStore.getString(DATE_DELIMITER);
        this.fTimeFieldSep = fPreferenceStore.getString(TIME_DELIMITER);
        this.fSSecFieldSep = fPreferenceStore.getString(SSEC_DELIMITER);
        this.updatePatterns();
    }

    void updatePatterns() {
        String dateFmt = this.fDateFormat.replaceAll(DELIMITER_DASH, this.fDateFieldSep);
        String timeFmt = this.fTimeFormat.replaceAll(DELIMITER_COLON, this.fTimeFieldSep);
        String ssecFmt = this.fSSecFormat.replaceAll(DELIMITER_SPACE, this.fSSecFieldSep);
        fTimestampPattern = String.valueOf(dateFmt) + timeFmt + DELIMITER_PERIOD + ssecFmt;
        fIntervalPattern = "TTT." + ssecFmt;
    }

    void setDefaults() {
        this.setDateTimeFormat("HH:mm:ss");
        this.setSSecFormat(SUBSEC_NANO_FMT);
        this.setDateFieldSep(DELIMITER_DASH);
        this.setTimeFieldSep(DELIMITER_COLON);
        this.setSSecFieldSep(DELIMITER_SPACE);
        this.updatePatterns();
    }
}

