/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.launch;

import java.net.URI;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.gprof.launch.GprofLaunchMessages;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GprofLaunchConfigurationDelegate
extends ProfileLaunchConfigurationDelegate {
    protected ILaunchConfiguration config;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        IPath exePath = this.getExePath(config);
        IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.getProject());
        URI workingDirURI = this.getProject().getLocationURI();
        Path workingDirPath = new Path(workingDirURI.getPath());
        String[] arguments = this.getProgramArgumentsArray(config);
        ILaunchManager lmgr = DebugPlugin.getDefault().getLaunchManager();
        lmgr.addLaunchListener((ILaunchesListener)new LaunchTerminationWatcher(launch, exePath));
        Process process = launcher.execute(exePath, arguments, this.getEnvironment(config), (IPath)workingDirPath, monitor);
        DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.gprof.launch";
    }

    protected IProject getProject() {
        try {
            IProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
            return project;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IPath getExePath(ILaunchConfiguration config) throws CoreException {
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        return exePath;
    }

    class LaunchTerminationWatcher
    implements ILaunchesListener2 {
        private ILaunch launch;
        private IPath exePath;

        public LaunchTerminationWatcher(ILaunch il, IPath exePath) {
            this.launch = il;
            this.exePath = exePath;
        }

        public void launchesTerminated(ILaunch[] launches) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch l = iLaunchArray[n2];
                if (l.equals(this.launch)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String s = LaunchTerminationWatcher.this.exePath.toOSString();
                                URI workingDirURI = GprofLaunchConfigurationDelegate.this.getProject().getLocationURI();
                                RemoteProxyManager rpmgr = RemoteProxyManager.getInstance();
                                IRemoteFileProxy proxy = rpmgr.getFileProxy(GprofLaunchConfigurationDelegate.this.getProject());
                                String workingDirPath = proxy.toPath(workingDirURI);
                                String gmonExpected = String.valueOf(workingDirPath) + "/gmon.out";
                                IFileStore f = proxy.getResource(gmonExpected);
                                if (!f.fetchInfo().exists()) {
                                    String title = GprofLaunchMessages.GprofCompilerOptions_msg;
                                    String message = GprofLaunchMessages.GprofCompileAgain_msg;
                                    Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                    MessageDialog.openWarning((Shell)parent, (String)title, (String)message);
                                } else {
                                    IFileStore exe = proxy.getResource(LaunchTerminationWatcher.this.exePath.toString());
                                    if (exe.fetchInfo().getLastModified() > f.fetchInfo().getLastModified()) {
                                        String title = GprofLaunchMessages.GprofGmonStale_msg;
                                        String message = GprofLaunchMessages.GprofGmonStaleExplanation_msg;
                                        Shell parent = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                                        MessageDialog.openWarning((Shell)parent, (String)title, (String)message);
                                    }
                                }
                                Display.getDefault().asyncExec((Runnable)new LaunchTerminationWatcherRunnable(s, gmonExpected));
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (CoreException coreException) {}
                        }
                    });
                }
                ++n2;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        class LaunchTerminationWatcherRunnable
        implements Runnable {
            private String exePath;
            private String gmonPath;

            public LaunchTerminationWatcherRunnable(String exePath, String gmonPath) {
                this.exePath = exePath;
                this.gmonPath = gmonPath;
            }

            @Override
            public void run() {
                GmonView.displayGprofView((String)this.exePath, (String)this.gmonPath, (IProject)GprofLaunchConfigurationDelegate.this.getProject());
            }
        }
    }
}

