/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.jaxb.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolArgumentType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolPaneType;
import org.eclipse.ptp.internal.etfw.jaxb.util.ToolArgumentTypeUtil;
import org.eclipse.ptp.internal.etfw.jaxb.util.ToolPaneTypeUtil;

public class ToolAppTypeUtil {
    public static List<String> getArguments(ILaunchConfiguration configuration, List<ToolPaneType> toolPanes, List<ToolArgumentType> toolArgs) throws CoreException {
        ArrayList<String> input = new ArrayList<String>();
        if (toolArgs != null) {
            for (ToolArgumentType toolArg : toolArgs) {
                String nextArg = ToolArgumentTypeUtil.getArgument(configuration, toolArg);
                if (nextArg == null || (nextArg = nextArg.trim()).length() <= 0) continue;
                int space = nextArg.indexOf(32);
                if (nextArg.indexOf(45) == 0 && space > 0) {
                    input.add(nextArg.substring(0, space).trim());
                    nextArg = nextArg.substring(space).trim();
                }
                input.add(nextArg);
            }
        }
        if (toolPanes != null) {
            for (ToolPaneType toolPane : toolPanes) {
                String nextArg;
                String arg = "";
                if (toolPane.getPrependWith() != null) {
                    arg = String.valueOf(arg) + toolPane.getPrependWith();
                }
                if (toolPane.getEncloseWith() != null) {
                    arg = String.valueOf(arg) + toolPane.getEncloseWith();
                }
                if ((nextArg = ToolPaneTypeUtil.getArgument(configuration, toolPane.getConfigId())) == null) continue;
                nextArg = nextArg.trim();
                arg = String.valueOf(arg) + nextArg;
                if (toolPane.getEncloseWith() != null) {
                    arg = String.valueOf(arg) + toolPane.getEncloseWith();
                }
                if (arg.length() <= 0) continue;
                int space = arg.indexOf(32);
                if (arg.indexOf(45) == 0 && space > 0) {
                    input.add(arg.substring(0, space).trim());
                    arg = arg.substring(space).trim();
                }
                input.add(arg);
            }
        }
        return input;
    }

    public static Map<String, String> getEnvVars(ILaunchConfiguration configuration, List<ToolPaneType> toolPanes, List<ToolArgumentType> toolArgs) throws CoreException {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        if (toolPanes != null) {
            for (ToolPaneType toolPane : toolPanes) {
                Map<String, String> test;
                if (toolPane == null || (test = ToolPaneTypeUtil.getEnvVars(configuration, toolPane.getConfigVarId())) == null) continue;
                vars.putAll(test);
            }
        }
        return vars;
    }
}

