/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.ui.ActivityContextManager;
import org.eclipse.mylyn.internal.monitor.ui.IMonitoredWindow;
import org.eclipse.mylyn.internal.monitor.ui.WorkbenchUserActivityMonitor;
import org.eclipse.mylyn.monitor.core.IInteractionEventListener;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractUserActivityMonitor;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MonitorUiPlugin
extends AbstractUIPlugin {
    private static final int DEFAULT_ACTIVITY_TIMEOUT = 180000;
    public static final String ID_PLUGIN = "org.eclipse.mylyn.monitor.ui";
    private static MonitorUiPlugin INSTANCE;
    private final List<AbstractUserInteractionMonitor> selectionMonitors = new ArrayList<AbstractUserInteractionMonitor>();
    private final List<IInteractionEventListener> interactionListeners = new ArrayList<IInteractionEventListener>();
    private ActivityContextManager activityContextManager;
    private final ArrayList<AbstractUserActivityMonitor> monitors = new ArrayList();
    protected Set<IPartListener> partListeners = new HashSet<IPartListener>();
    protected Set<IPageListener> pageListeners = new HashSet<IPageListener>();
    protected Set<IPerspectiveListener> perspectiveListeners = new HashSet<IPerspectiveListener>();
    protected Set<ISelectionListener> postSelectionListeners = new HashSet<ISelectionListener>();
    private final Set<IWorkbenchWindow> monitoredWindows = new HashSet<IWorkbenchWindow>();
    public static final String OBFUSCATED_LABEL = "[obfuscated]";
    public static final String ACTIVITY_TRACKING_ENABLED = "org.eclipse.mylyn.monitor.activity.tracking.enabled";
    private IWorkbenchWindow launchingWorkbenchWindow = null;
    private final IPropertyChangeListener PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.monitor.ui.activity.timeout") || event.getProperty().equals("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled")) {
                MonitorUiPlugin.this.updateActivityTimout();
            } else if (event.getProperty().equals(MonitorUiPlugin.ACTIVITY_TRACKING_ENABLED)) {
                MonitorUiPlugin.this.setActivityTrackingEnabled(MonitorUiPlugin.this.getPreferenceStore().getBoolean(MonitorUiPlugin.ACTIVITY_TRACKING_ENABLED));
            }
        }
    };
    protected IWindowListener WINDOW_LISTENER = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IMonitoredWindow awareWindow;
            if (MonitorUiPlugin.this.getWorkbench().isClosing()) {
                return;
            }
            if (window instanceof IMonitoredWindow && !(awareWindow = (IMonitoredWindow)window).isMonitored()) {
                return;
            }
            MonitorUiPlugin.this.addListenersToWindow(window);
        }

        public void windowClosed(IWorkbenchWindow window) {
            MonitorUiPlugin.this.removeListenersFromWindow(window);
            if (window == MonitorUiPlugin.this.launchingWorkbenchWindow) {
                MonitorUiPlugin.this.launchingWorkbenchWindow = null;
            }
        }
    };
    private boolean activityTrackingEnabled;

    public MonitorUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.monitor.ui.activity.timeout", 180000);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled", true);
        this.getPreferenceStore().setDefault(ACTIVITY_TRACKING_ENABLED, false);
        this.activityContextManager = new ActivityContextManager(new ArrayList<AbstractUserActivityMonitor>(0));
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MonitorUiPlugin.this.init();
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        try {
            if (this.activityContextManager != null) {
                this.activityContextManager.stop();
            }
            if (Platform.isRunning()) {
                this.getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
                if (this.getWorkbench() != null && !this.getWorkbench().isClosing()) {
                    this.getWorkbench().removeWindowListener(this.WINDOW_LISTENER);
                    for (IWorkbenchWindow window : this.monitoredWindows) {
                        this.removeListenersFromWindow(window);
                    }
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Monitor UI stop failed", (Throwable)e));
        }
        INSTANCE = null;
    }

    public void addWindowPartListener(IPartListener listener) {
        this.partListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.getPartService().addPartListener(listener);
        }
    }

    public void removeWindowPartListener(IPartListener listener) {
        this.partListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.getPartService().removePartListener(listener);
        }
    }

    public void addWindowPageListener(IPageListener listener) {
        this.pageListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.addPageListener(listener);
        }
    }

    public void removeWindowPageListener(IPageListener listener) {
        this.pageListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.removePageListener(listener);
        }
    }

    public void addWindowPerspectiveListener(IPerspectiveListener listener) {
        this.perspectiveListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.addPerspectiveListener(listener);
        }
    }

    public void removeWindowPerspectiveListener(IPerspectiveListener listener) {
        this.perspectiveListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            window.removePerspectiveListener(listener);
        }
    }

    public void addWindowPostSelectionListener(ISelectionListener listener) {
        this.postSelectionListeners.add(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            ISelectionService service = window.getSelectionService();
            service.addPostSelectionListener(listener);
        }
    }

    public void removeWindowPostSelectionListener(ISelectionListener listener) {
        MonitorUiPlugin.getDefault().postSelectionListeners.remove(listener);
        for (IWorkbenchWindow window : this.monitoredWindows) {
            ISelectionService service = window.getSelectionService();
            service.removePostSelectionListener(listener);
        }
    }

    public static MonitorUiPlugin getDefault() {
        return INSTANCE;
    }

    public List<AbstractUserInteractionMonitor> getSelectionMonitors() {
        return this.selectionMonitors;
    }

    public void addInteractionListener(IInteractionEventListener listener) {
        this.interactionListeners.add(listener);
    }

    public void removeInteractionListener(IInteractionEventListener listener) {
        this.interactionListeners.remove(listener);
    }

    public void notifyInteractionObserved(InteractionEvent interactionEvent) {
        for (IInteractionEventListener listener : this.interactionListeners) {
            listener.interactionObserved(interactionEvent);
        }
    }

    public List<IInteractionEventListener> getInteractionListeners() {
        return this.interactionListeners;
    }

    public ActivityContextManager getActivityContextManager() {
        return this.activityContextManager;
    }

    public boolean suppressConfigurationWizards() {
        List<String> commandLineArgs = Arrays.asList(Platform.getCommandLineArgs());
        if (commandLineArgs.contains("-showMylynWizards")) {
            return false;
        }
        return commandLineArgs.contains("-pdelaunch");
    }

    private void removeListenersFromWindow(IWorkbenchWindow window) {
        for (IPageListener iPageListener : this.pageListeners) {
            window.removePageListener(iPageListener);
        }
        for (IPartListener iPartListener : this.partListeners) {
            window.getPartService().removePartListener(iPartListener);
        }
        for (IPerspectiveListener iPerspectiveListener : this.perspectiveListeners) {
            window.removePerspectiveListener(iPerspectiveListener);
        }
        for (ISelectionListener iSelectionListener : this.postSelectionListeners) {
            window.getSelectionService().removePostSelectionListener(iSelectionListener);
        }
        this.monitoredWindows.remove(window);
    }

    private void addListenersToWindow(IWorkbenchWindow window) {
        for (IPageListener iPageListener : this.pageListeners) {
            window.addPageListener(iPageListener);
        }
        for (IPartListener iPartListener : this.partListeners) {
            window.getPartService().addPartListener(iPartListener);
        }
        for (IPerspectiveListener iPerspectiveListener : this.perspectiveListeners) {
            window.addPerspectiveListener(iPerspectiveListener);
        }
        for (ISelectionListener iSelectionListener : this.postSelectionListeners) {
            window.getSelectionService().addPostSelectionListener(iSelectionListener);
        }
        this.monitoredWindows.add(window);
    }

    public Set<IWorkbenchWindow> getMonitoredWindows() {
        return this.monitoredWindows;
    }

    public IWorkbenchWindow getLaunchingWorkbenchWindow() {
        return this.launchingWorkbenchWindow;
    }

    private void init() {
        try {
            this.getWorkbench().addWindowListener(this.WINDOW_LISTENER);
            IWorkbenchWindow[] windows = this.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                this.launchingWorkbenchWindow = windows[0];
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                this.addListenersToWindow(window);
                ++n2;
            }
            this.monitors.add(new WorkbenchUserActivityMonitor());
            new MonitorUiExtensionPointReader().initExtensions();
            this.activityContextManager.init(this.monitors);
            this.updateActivityTimout();
            this.activityContextManager.start();
            this.setActivityTrackingEnabled(this.getPreferenceStore().getBoolean(ACTIVITY_TRACKING_ENABLED));
            this.getPreferenceStore().addPropertyChangeListener(this.PROPERTY_LISTENER);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Monitor UI start failed", (Throwable)e));
        }
    }

    private void updateActivityTimout() {
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.activity.timeout.enabled")) {
            this.activityContextManager.setInactivityTimeout(this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.activity.timeout"));
        } else {
            this.activityContextManager.setInactivityTimeout(0);
        }
    }

    public void setActivityTrackingEnabled(boolean b) {
        this.activityTrackingEnabled = b;
    }

    public boolean isActivityTrackingEnabled() {
        return this.activityTrackingEnabled;
    }

    public boolean isTrackingOsTime() {
        return this.monitors.size() > 1;
    }

    class MonitorUiExtensionPointReader {
        public static final String EXTENSION_ID_USER = "org.eclipse.mylyn.monitor.ui.user";
        public static final String ELEMENT_ACTIVITY_TIMER = "osActivityTimer";
        public static final String ELEMENT_CLASS = "class";
        private boolean extensionsRead = false;

        MonitorUiExtensionPointReader() {
        }

        public void initExtensions() {
            try {
                IExtensionRegistry registry;
                IExtensionPoint extensionPoint;
                if (!this.extensionsRead && (extensionPoint = (registry = Platform.getExtensionRegistry()).getExtensionPoint(EXTENSION_ID_USER)) != null) {
                    IExtension[] extensions;
                    IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if (element.getName().compareTo(ELEMENT_ACTIVITY_TIMER) == 0) {
                                this.readActivityMonitor(element);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    this.extensionsRead = true;
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, MonitorUiPlugin.ID_PLUGIN, "Could not read monitor extension", t));
            }
        }

        private void readActivityMonitor(IConfigurationElement element) throws CoreException {
            try {
                Object activityTimer;
                if (element.getAttribute(ELEMENT_CLASS) != null && (activityTimer = element.createExecutableExtension(ELEMENT_CLASS)) instanceof AbstractUserActivityMonitor) {
                    MonitorUiPlugin.this.monitors.add(0, (AbstractUserActivityMonitor)activityTimer);
                }
            }
            catch (Throwable e) {
                StatusHandler.log((IStatus)new Status(4, MonitorUiPlugin.ID_PLUGIN, "Could not load activity timer", e));
            }
        }
    }
}

