/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IDomainInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.ChannelInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.TraceInfo;

public class DomainInfo
extends TraceInfo
implements IDomainInfo {
    private final List<IChannelInfo> fChannels = new ArrayList<IChannelInfo>();
    private boolean fIsKernel = false;

    public DomainInfo(String name) {
        super(name);
    }

    public DomainInfo(DomainInfo other) {
        super(other);
        int i = 0;
        while (i < other.fChannels.size()) {
            if (other.fChannels.get(i) instanceof ChannelInfo) {
                this.fChannels.add(new ChannelInfo((ChannelInfo)other.fChannels.get(i)));
            } else {
                this.fChannels.add(other.fChannels.get(i));
            }
            ++i;
        }
        this.fIsKernel = other.fIsKernel;
    }

    @Override
    public boolean isKernel() {
        return this.fIsKernel;
    }

    @Override
    public void setIsKernel(boolean isKernel) {
        this.fIsKernel = isKernel;
    }

    @Override
    public IChannelInfo[] getChannels() {
        return this.fChannels.toArray(new IChannelInfo[this.fChannels.size()]);
    }

    @Override
    public void setChannels(List<IChannelInfo> channels) {
        this.fChannels.clear();
        for (IChannelInfo channelInfo : channels) {
            this.fChannels.add(channelInfo);
        }
    }

    @Override
    public void addChannel(IChannelInfo channel) {
        this.fChannels.add(channel);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fChannels.hashCode();
        result = 31 * result + (this.fIsKernel ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DomainInfo other = (DomainInfo)obj;
        if (!this.fChannels.equals(other.fChannels)) {
            return false;
        }
        return this.fIsKernel == other.fIsKernel;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[DomainInfo(");
        output.append(super.toString());
        output.append(",Channels=");
        if (this.fChannels.isEmpty()) {
            output.append("None");
        } else {
            for (IChannelInfo channel : this.fChannels) {
                output.append(channel.toString());
            }
        }
        output.append(",isKernel=");
        output.append(String.valueOf(this.fIsKernel));
        output.append(")]");
        return output.toString();
    }
}

