/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.core.services.local;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.remote.core.services.local.LocalConnection;
import org.eclipse.ptp.internal.remote.core.services.local.LocalConnectionManager;
import org.eclipse.ptp.internal.remote.core.services.local.LocalFileManager;
import org.eclipse.ptp.internal.remote.core.services.local.LocalProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;

public class LocalServices
implements IRemoteServices {
    public static final String LocalServicesId = "org.eclipse.ptp.remote.LocalServices";
    private IRemoteFileManager fFileMgr = null;
    private final IRemoteConnectionManager fConnMgr = new LocalConnectionManager(this);
    private final IRemoteServicesDescriptor fDescriptor;

    public LocalServices(IRemoteServicesDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    @Override
    public boolean canCreateConnections() {
        return this.fDescriptor.canCreateConnections();
    }

    @Override
    public IRemoteProcess getCommandShell(IRemoteConnection conn, int flags) throws IOException {
        throw new IOException("Not currently implemented");
    }

    @Override
    public IRemoteConnectionManager getConnectionManager() {
        return this.fConnMgr;
    }

    @Override
    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        if (!(conn instanceof LocalConnection)) {
            return null;
        }
        if (this.fFileMgr == null) {
            this.fFileMgr = new LocalFileManager((LocalConnection)conn);
        }
        return this.fFileMgr;
    }

    @Override
    public String getId() {
        return this.fDescriptor.getId();
    }

    @Override
    public String getName() {
        return this.fDescriptor.getName();
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        return new LocalProcessBuilder(conn, command);
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        return new LocalProcessBuilder(conn, command);
    }

    @Override
    public String getScheme() {
        return this.fDescriptor.getScheme();
    }

    public Object getServicesExtension(IRemoteConnection conn, Class extension) {
        return null;
    }

    @Override
    public boolean initialize(IProgressMonitor monitor) {
        return true;
    }
}

