/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.IStateHistoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.CoreNode;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HTConfig;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HTInterval;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HTNode;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HT_IO;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HistoryTree;
import org.eclipse.linuxtools.tmf.core.exceptions.StateSystemDisposedException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    protected final HistoryTree sht;
    private final HT_IO treeIO;
    protected boolean isFinishedBuilding = false;

    public HistoryTreeBackend(File newStateFile, int blockSize, int maxChildren, int providerVersion, long startTime) throws IOException {
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.sht = new HistoryTree(conf);
        this.treeIO = this.sht.getTreeIO();
    }

    public HistoryTreeBackend(File newStateFile, int providerVersion, long startTime) throws IOException {
        this(newStateFile, 65536, 50, providerVersion, startTime);
    }

    public HistoryTreeBackend(File existingStateFile, int providerVersion) throws IOException {
        this.sht = new HistoryTree(existingStateFile, providerVersion);
        this.treeIO = this.sht.getTreeIO();
        this.isFinishedBuilding = true;
    }

    @Override
    public long getStartTime() {
        return this.sht.getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.sht.getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        this.sht.insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.sht.closeTree(endTime);
        this.isFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.treeIO.supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.treeIO.supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.treeIO.supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.treeIO.deleteFile();
    }

    @Override
    public void dispose() {
        if (this.isFinishedBuilding) {
            this.treeIO.closeFile();
        } else {
            this.treeIO.deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        CoreNode currentNode = this.sht.getLatestBranch().get(0);
        currentNode.writeInfoFromNode(stateInfo, t);
        try {
            while (currentNode.getNbChildren() > 0) {
                currentNode = (CoreNode)this.sht.selectNextChild(currentNode, t);
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        return this.getRelevantInterval(t, attributeQuark);
    }

    @Override
    public boolean checkValidTime(long t) {
        return t >= this.sht.getTreeStart() && t <= this.sht.getTreeEnd();
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, StateSystemDisposedException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException();
        }
        CoreNode currentNode = this.sht.getLatestBranch().get(0);
        HTInterval interval = currentNode.getRelevantInterval(key, t);
        try {
            while (interval == null && currentNode.getNbChildren() > 0) {
                currentNode = (CoreNode)this.sht.selectNextChild(currentNode, t);
                interval = currentNode.getRelevantInterval(key, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
        assert (interval != null);
        return interval;
    }

    public long getFileSize() {
        return this.sht.getFileSize();
    }

    public int getTreeDepth() {
        return this.sht.getLatestBranch().size();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.sht.getNodeCount()) {
                HTNode node = this.treeIO.readNode(seq);
                total += node.getNodeUsagePRC();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            e.printStackTrace();
        }
        long ret = total / (long)this.sht.getNodeCount();
        assert (ret >= 0L && ret <= 100L);
        return (int)ret;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.sht.toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.sht.debugPrintFullTree(writer, printIntervals);
    }
}

