/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorList;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;
    boolean selected;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    void changeColor(long id2, long sel, long sender) {
        this.selected = true;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        NSColor color;
        NSString appName;
        NSColorList colorList;
        Display display;
        NSColorPanel panel = NSColorPanel.sharedColorPanel();
        Display display2 = display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        if (this.rgb != null) {
            NSColor color2 = NSColor.colorWithDeviceRed((float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0);
            panel.setColor(color2);
        }
        if ((colorList = NSColorList.colorListNamed(appName = Display.getApplicationName())) == null) {
            colorList = (NSColorList)new NSColorList().alloc();
            colorList.initWithName(appName);
            panel.attachColorList(colorList);
        } else {
            colorList.retain();
        }
        if (this.rgbs != null) {
            int i;
            NSArray keys = colorList.allKeys();
            int length = (int)keys.count();
            for (i = length - 1; i >= 0; --i) {
                colorList.removeColorWithKey(new NSString(keys.objectAtIndex(i)));
            }
            for (i = 0; i < this.rgbs.length; ++i) {
                RGB rgb = this.rgbs[i];
                if (rgb == null) continue;
                NSColor color3 = NSColor.colorWithDeviceRed((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f, 1.0);
                NSString key = appName;
                if (i > 0) {
                    key = key.stringByAppendingString(NSString.stringWith(" " + i));
                }
                colorList.insertColor(color3, key, i);
            }
        }
        SWTPanelDelegate delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        long jniRef = OS.NewGlobalRef(this);
        if (jniRef == 0L) {
            this.error(2);
        }
        OS.object_setInstanceVariable(delegate.id, Display.SWT_OBJECT, jniRef);
        panel.setDelegate(delegate);
        this.rgb = null;
        this.selected = false;
        panel.orderFront(null);
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(panel);
        display.setModalDialog(null);
        panel.setDelegate(null);
        delegate.release();
        OS.DeleteGlobalRef(jniRef);
        if (this.selected && (color = panel.color()) != null) {
            double[] handle = display.getNSColorRGB(color);
            this.rgb = new RGB((int)(handle[0] * 255.0), (int)(handle[1] * 255.0), (int)(handle[2] * 255.0));
        }
        NSArray keys = colorList.allKeys();
        int length = (int)keys.count();
        this.rgbs = new RGB[length];
        for (int i = 0; i < length; ++i) {
            NSString key = new NSString(keys.objectAtIndex(i));
            double[] handle = display.getNSColorRGB(colorList.colorWithKey(key));
            this.rgbs[i] = new RGB((int)(handle[0] * 255.0), (int)(handle[1] * 255.0), (int)(handle[2] * 255.0));
        }
        colorList.release();
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    public void setRGBs(RGB[] rgbs) {
        this.rgbs = rgbs;
    }

    void windowWillClose(long id2, long sel, long sender) {
        NSApplication.sharedApplication().stop(null);
    }
}

