/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.history.CommitSelectionDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareWithCommitActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(true, event);
        if (repo == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        CommitSelectionDialog dlg = new CommitSelectionDialog(this.getShell(event), repo, resources);
        if (dlg.open() != 0) {
            return null;
        }
        if (resources.length == 1 && resources[0] instanceof IFile) {
            IFile baseFile = (IFile)resources[0];
            try {
                CompareUtils.compareWorkspaceWithRef(repo, baseFile, dlg.getCommitId().getName(), null);
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
            }
        } else {
            try {
                CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                view.setInput(resources, dlg.getCommitId().name());
            }
            catch (PartInitException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.selectionMapsToSingleRepository();
    }
}

