/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakeRecon
extends OutputStream {
    IPath make;
    String[] args;
    String[] environ;
    IPath directory;
    IProgressMonitor monitor;
    OutputStream console;
    MyList log;
    StringBuffer currentLine;

    public MakeRecon(IPath buildCommand, String[] buildArguments, String[] env, IPath workingDirectory, IProgressMonitor mon, OutputStream cos) {
        this(buildCommand, new String[]{"-n"}, buildArguments, env, workingDirectory, mon, cos);
    }

    public MakeRecon(IPath buildCommand, String[] options, String[] buildArguments, String[] env, IPath workingDirectory, IProgressMonitor mon, OutputStream cos) {
        String[] array;
        this.make = buildCommand;
        this.args = new String[0];
        if (options != null) {
            array = new String[this.args.length + options.length];
            System.arraycopy(this.args, 0, array, 0, this.args.length);
            System.arraycopy(options, 0, array, this.args.length, options.length);
            this.args = array;
        }
        if (buildArguments != null) {
            array = new String[this.args.length + buildArguments.length];
            System.arraycopy(this.args, 0, array, 0, this.args.length);
            System.arraycopy(buildArguments, 0, array, this.args.length, buildArguments.length);
            this.args = array;
        }
        this.environ = env;
        this.directory = workingDirectory;
        this.monitor = mon;
        this.console = cos;
        this.currentLine = new StringBuffer();
        this.log = new MyList();
        this.invokeMakeRecon();
    }

    private void invokeMakeRecon() {
        int i = 0;
        String[] array = new String[this.args.length + 1];
        array[0] = this.make.toOSString();
        System.arraycopy(this.args, 0, array, 1, this.args.length);
        try {
            Process p = ProcessFactory.getFactory().exec(array, this.environ, this.directory.toFile());
            InputStream in = p.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    this.log.add(line);
                    ++i;
                }
            }
            catch (IOException iOException) {}
            try {
                in.close();
            }
            catch (IOException iOException) {}
            p.destroy();
            this.log.trimToSize();
        }
        catch (IOException iOException) {
            i = -1;
        }
        this.monitor.beginTask("", i);
    }

    @Override
    public void close() throws IOException {
        if (this.console != null) {
            this.console.close();
        }
        this.monitor.done();
    }

    @Override
    public void flush() throws IOException {
        if (this.console != null) {
            this.console.flush();
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkProgress(false);
        if (this.console != null) {
            this.console.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkProgress(false);
        if (this.console != null) {
            this.console.write(b, off, len);
        }
    }

    private void checkProgress(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf("\n")) != -1) {
            String line = buffer.substring(0, i).trim();
            this.processLine(line);
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    private void processLine(String line) {
        int found = -1;
        int i = 0;
        while (i < this.log.size()) {
            String s = (String)this.log.get(i);
            if (s.startsWith(line)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found != -1) {
            String show = (String)this.log.get(found);
            if (show.length() > 50) {
                show = show.substring(0, 50);
            }
            this.monitor.subTask(show);
            this.monitor.worked(found + 1);
            this.log.removeInterval(0, found + 1);
        }
    }

    class MyList
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;

        MyList() {
        }

        public void removeInterval(int start, int len) {
            this.removeRange(start, len);
        }
    }
}

