/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.statistics;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfStatsUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.statistics.ITmfStatistics;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.core.trace.TmfTraceManager;
import org.eclipse.linuxtools.tmf.ui.viewers.TmfViewer;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.ITmfColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfBaseColumnData;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfBaseColumnDataProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfStatisticsTreeManager;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfTreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TmfStatisticsViewer
extends TmfViewer {
    public static final byte TIME_SCALE = -9;
    protected static final int PAGE_SIZE = 50000;
    protected final Long STATS_INPUT_CHANGED_REFRESH = 5000L;
    protected TreeViewer fTreeViewer;
    protected TmfStatisticsTree fStatisticsData;
    protected boolean fStatisticsUpdateBusy = false;
    protected boolean fStatisticsUpdatePending = false;
    protected TmfTimeRange fStatisticsUpdateRange = null;
    protected final Object fStatisticsUpdateSyncObj = new Object();
    protected final Object fStatisticsRangeUpdateSyncObj = new Object();
    protected ITmfTrace fTrace;
    protected TmfTimeRange fRequestedTimerange;
    private boolean fProcessAll;
    private static int fCountInstance = 0;
    private int fInstanceNb;
    private Cursor fWaitCursor = null;
    private int fWaitCursorCount = 0;
    private boolean fSendRangeRequest = true;
    private final TmfTraceManager fTraceManager;

    public TmfStatisticsViewer() {
        this.fTraceManager = TmfTraceManager.getInstance();
    }

    public TmfStatisticsViewer(Composite parent, String viewerName, ITmfTrace trace) {
        this.init(parent, viewerName, trace);
        this.fTraceManager = TmfTraceManager.getInstance();
    }

    public void init(Composite parent, String viewerName, ITmfTrace trace) {
        super.init(parent, viewerName);
        this.fInstanceNb = ++fCountInstance;
        this.fTrace = trace;
        this.fProcessAll = trace instanceof TmfExperiment;
        this.initContent(parent);
        this.initInput();
    }

    public void dispose() {
        super.dispose();
        if (this.fWaitCursor != null) {
            this.fWaitCursor.dispose();
        }
        TmfStatisticsTreeManager.removeStatTreeRoot(this.getTreeID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (!this.isListeningTo(trace)) {
            return;
        }
        Object object = this.fStatisticsRangeUpdateSyncObj;
        synchronized (object) {
            if (this.fSendRangeRequest) {
                this.fSendRangeRequest = false;
                this.requestTimeRangeData(trace, this.fTraceManager.getCurrentRange());
            }
        }
        this.requestData(trace, signal.getRange());
    }

    @TmfSignalHandler
    public void timeRangeUpdated(TmfRangeSynchSignal signal) {
        if (this.fTrace == null) {
            return;
        }
        this.requestTimeRangeData(this.fTrace, signal.getCurrentRange());
    }

    @TmfSignalHandler
    public void statsUpdated(TmfStatsUpdatedSignal sig) {
        if (!this.isListeningTo(sig.getTrace())) {
            return;
        }
        TmfStatisticsTree statsData = TmfStatisticsTreeManager.getStatTree(this.getTreeID());
        Map map = sig.getEventsPerType();
        String name = sig.getTrace().getName();
        boolean isGlobal = sig.isGlobal();
        for (Map.Entry entry : map.entrySet()) {
            statsData.setTypeCount(name, (String)entry.getKey(), isGlobal, (Long)entry.getValue());
        }
        long globalTotal = 0L;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            globalTotal += val;
        }
        statsData.setTotal(name, isGlobal, globalTotal);
        this.modelComplete(isGlobal);
    }

    @Override
    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public Object getInput() {
        return this.fTreeViewer.getInput();
    }

    public int getPageSize() {
        return 50000;
    }

    public long getRefreshRate() {
        return this.STATS_INPUT_CHANGED_REFRESH;
    }

    public TmfStatisticsTree getStatisticData() {
        if (this.fStatisticsData == null) {
            this.fStatisticsData = new TmfStatisticsTree();
        }
        return this.fStatisticsData;
    }

    public String getTreeID() {
        return String.valueOf(this.getName()) + this.fInstanceNb;
    }

    @Override
    public void refresh() {
        final Control viewerControl = this.getControl();
        if (viewerControl.isDisposed()) {
            return;
        }
        viewerControl.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!viewerControl.isDisposed()) {
                    TmfStatisticsViewer.this.fTreeViewer.refresh();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialRequestOnNextUpdate() {
        Object object = this.fStatisticsRangeUpdateSyncObj;
        synchronized (object) {
            this.fSendRangeRequest = true;
        }
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    protected void cancelOngoingRequest(ITmfDataRequest request) {
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
    }

    protected ITmfColumnDataProvider getColumnDataProvider() {
        return new TmfBaseColumnDataProvider();
    }

    protected void initContent(Composite parent) {
        final List<TmfBaseColumnData> columnDataList = this.getColumnDataProvider().getColumnData();
        this.fTreeViewer = new TreeViewer(parent, 2816);
        this.fTreeViewer.setContentProvider((IContentProvider)new TmfTreeContentProvider());
        this.fTreeViewer.getTree().setHeaderVisible(true);
        this.fTreeViewer.setUseHashlookup(true);
        for (final TmfBaseColumnData columnData : columnDataList) {
            final TreeViewerColumn treeColumn = new TreeViewerColumn(this.fTreeViewer, columnData.getAlignment());
            treeColumn.getColumn().setText(columnData.getHeader());
            treeColumn.getColumn().setWidth(columnData.getWidth());
            treeColumn.getColumn().setToolTipText(columnData.getTooltip());
            if (columnData.getComparator() != null) {
                treeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
                    private ViewerComparator reverseComparator;

                    public void widgetSelected(SelectionEvent e) {
                        if (this.reverseComparator == null) {
                            this.reverseComparator = new ViewerComparator(){

                                public int compare(Viewer viewer, Object e1, Object e2) {
                                    return -1 * columnData.getComparator().compare(viewer, e1, e2);
                                }
                            };
                        }
                        if (TmfStatisticsViewer.this.fTreeViewer.getTree().getSortDirection() == 128 || TmfStatisticsViewer.this.fTreeViewer.getTree().getSortColumn() != treeColumn.getColumn()) {
                            TmfStatisticsViewer.this.fTreeViewer.setComparator(columnData.getComparator());
                            TmfStatisticsViewer.this.fTreeViewer.getTree().setSortDirection(1024);
                        } else {
                            TmfStatisticsViewer.this.fTreeViewer.setComparator(this.reverseComparator);
                            TmfStatisticsViewer.this.fTreeViewer.getTree().setSortDirection(128);
                        }
                        TmfStatisticsViewer.this.fTreeViewer.getTree().setSortColumn(treeColumn.getColumn());
                    }
                });
            }
            treeColumn.setLabelProvider((CellLabelProvider)columnData.getLabelProvider());
        }
        this.fTreeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider() != null) {
                    TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)event.item.getData();
                    double percentage = ((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider().getPercentage(node);
                    if (percentage == 0.0) {
                        return;
                    }
                    if ((event.detail & 2) > 0) {
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.detail &= 0xFFFFFFFD;
                    }
                    int barWidth = (int)((double)(TmfStatisticsViewer.this.fTreeViewer.getTree().getColumn(event.index).getWidth() - 8) * percentage);
                    int oldAlpha = event.gc.getAlpha();
                    Color oldForeground = event.gc.getForeground();
                    Color oldBackground = event.gc.getBackground();
                    event.gc.setAlpha(64);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                    event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                    event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                    event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                    event.gc.setForeground(oldForeground);
                    event.gc.setBackground(oldBackground);
                    event.gc.setAlpha(oldAlpha);
                    event.detail &= 0xFFFFFFF7;
                }
            }
        });
        this.fTreeViewer.setComparator(columnDataList.get(0).getComparator());
        this.fTreeViewer.getTree().setSortColumn(this.fTreeViewer.getTree().getColumn(0));
        this.fTreeViewer.getTree().setSortDirection(1024);
    }

    protected void initInput() {
        TmfStatisticsTreeNode statisticsTreeNode;
        String treeID = this.getTreeID();
        if (TmfStatisticsTreeManager.containsTreeRoot(treeID)) {
            statisticsTreeNode = TmfStatisticsTreeManager.getStatTreeRoot(treeID);
            int numNodeTraces = statisticsTreeNode.getNbChildren();
            ITmfTrace[] traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
            int numTraces = traces.length;
            if (numTraces == numNodeTraces) {
                boolean same = true;
                int i = 0;
                while (i < numTraces) {
                    String traceName = traces[i].getName();
                    if (!statisticsTreeNode.containsChild(traceName)) {
                        same = false;
                        break;
                    }
                    ++i;
                }
                if (same) {
                    this.fTreeViewer.setInput((Object)statisticsTreeNode);
                    return;
                }
                statisticsTreeNode.reset();
            }
        } else {
            statisticsTreeNode = TmfStatisticsTreeManager.addStatsTreeRoot(treeID, this.getStatisticData());
        }
        this.fTreeViewer.setInput((Object)statisticsTreeNode);
        this.resetUpdateSynchronization();
    }

    protected boolean isListeningTo(ITmfTrace trace) {
        return this.fProcessAll || trace == this.fTrace;
    }

    protected void modelComplete(boolean global) {
        this.refresh();
        this.waitCursor(false);
        if (global) {
            this.sendPendingUpdate();
        }
    }

    protected void modelIncomplete(boolean isGlobalRequest) {
        if (isGlobalRequest) {
            this.resetUpdateSynchronization();
            this.sendPendingUpdate();
        } else {
            this.resetTimeRangeValue();
        }
        this.refresh();
        this.waitCursor(false);
    }

    protected void requestData(ITmfTrace trace, TmfTimeRange timeRange) {
        this.buildStatisticsTree(trace, timeRange, true);
    }

    protected void requestTimeRangeData(ITmfTrace trace, TmfTimeRange timeRange) {
        this.fRequestedTimerange = timeRange;
        this.buildStatisticsTree(trace, timeRange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStatisticsTree(ITmfTrace trace, TmfTimeRange timeRange, boolean isGlobal) {
        TmfStatisticsTreeNode statTree = TmfStatisticsTreeManager.getStatTreeRoot(this.getTreeID());
        TmfStatisticsTree statsData = TmfStatisticsTreeManager.getStatTree(this.getTreeID());
        if (statsData == null) {
            return;
        }
        TmfStatisticsTree tmfStatisticsTree = statsData;
        synchronized (tmfStatisticsTree) {
            if (isGlobal) {
                statTree.resetGlobalValue();
            } else {
                statTree.resetTimeRangeValue();
            }
            ITmfTrace[] iTmfTraceArray = TmfTraceManager.getTraceSet((ITmfTrace)trace);
            int n = iTmfTraceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfStatistics stats;
                ITmfTrace aTrace = iTmfTraceArray[n2];
                if (this.isListeningTo(aTrace) && (stats = aTrace.getStatistics()) != null) {
                    long start = timeRange.getStartTime().normalize(0L, -9).getValue();
                    long end = timeRange.getEndTime().normalize(0L, -9).getValue();
                    aTrace.getStatistics().updateStats(isGlobal, start, end);
                }
                ++n2;
            }
        }
    }

    protected void resetTimeRangeValue() {
        TmfStatisticsTreeNode treeModelRoot = TmfStatisticsTreeManager.getStatTreeRoot(this.getTreeID());
        if (treeModelRoot != null && treeModelRoot.hasChildren()) {
            treeModelRoot.resetTimeRangeValue();
        }
    }

    protected void waitCursor(final boolean waitRequested) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        boolean needsUpdate = false;
        Display display = this.fTreeViewer.getControl().getDisplay();
        if (waitRequested) {
            ++this.fWaitCursorCount;
            if (this.fWaitCursor == null) {
                this.fWaitCursor = new Cursor((Device)display, 1);
            }
            if (this.fWaitCursorCount == 1) {
                needsUpdate = true;
            }
        } else if (this.fWaitCursorCount > 0) {
            --this.fWaitCursorCount;
            if (this.fWaitCursorCount == 0) {
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TmfStatisticsViewer.this.fTreeViewer != null && !TmfStatisticsViewer.this.fTreeViewer.getTree().isDisposed()) {
                        Cursor cursor = null;
                        if (waitRequested) {
                            cursor = TmfStatisticsViewer.this.fWaitCursor;
                        }
                        TmfStatisticsViewer.this.fTreeViewer.getControl().setCursor(cursor);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUpdateSynchronization() {
        Object object = this.fStatisticsUpdateSyncObj;
        synchronized (object) {
            this.fStatisticsUpdateBusy = false;
            this.fStatisticsUpdatePending = false;
            this.fStatisticsUpdateRange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUpdateBusy(TmfTimeRange timeRange) {
        Object object = this.fStatisticsUpdateSyncObj;
        synchronized (object) {
            block5: {
                if (!this.fStatisticsUpdateBusy) break block5;
                this.fStatisticsUpdatePending = true;
                if (this.fStatisticsUpdateRange == null || timeRange.getEndTime().compareTo(this.fStatisticsUpdateRange.getEndTime()) > 0) {
                    this.fStatisticsUpdateRange = timeRange;
                }
                return true;
            }
            this.fStatisticsUpdateBusy = true;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPendingUpdate() {
        Object object = this.fStatisticsUpdateSyncObj;
        synchronized (object) {
            this.fStatisticsUpdateBusy = false;
            if (this.fStatisticsUpdatePending) {
                this.fStatisticsUpdatePending = false;
                this.requestData(this.fTrace, this.fStatisticsUpdateRange);
                this.fStatisticsUpdateRange = null;
            }
        }
    }
}

