/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.core.scannerconfig;

import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.build.internal.core.scannerconfig.jobs.CfgSCJobsUtil;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.newmake.internal.core.MakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ScannerConfigBuilder
extends ACBuilder {
    public static final int PERFORM_CORE_UPDATE = 1;
    public static final int FORCE_DISCOVERY = 2;
    public static final int SKIP_SI_DISCOVERY = 4;
    public static final String BUILDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ScannerConfigBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IManagedBuildInfo bInfo = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (bInfo != null) {
            IConfiguration[] cfgs = bInfo.getManagedProject().getConfigurations();
            if (cfgs.length != 0) {
                int numWork;
                if (!ScannerConfigBuilder.needAllConfigBuild()) {
                    ICConfigurationDescription settingCfgDes;
                    ICProjectDescription des = CoreModel.getDefault().getProjectDescription(this.getProject(), false);
                    IConfiguration cfg = null;
                    if (des != null && (settingCfgDes = des.getDefaultSettingConfiguration()) != null) {
                        int i = 0;
                        while (i < cfgs.length) {
                            if (settingCfgDes.getId().equals(cfgs[i].getId())) {
                                cfg = cfgs[i];
                                break;
                            }
                            ++i;
                        }
                    }
                    cfgs = cfg != null ? new IConfiguration[]{cfg} : new IConfiguration[]{};
                }
                if ((numWork = cfgs.length) > 0) {
                    monitor.beginTask(MakeMessages.getString("ScannerConfigBuilder.Invoking_Builder"), numWork);
                    int i = 0;
                    while (i < cfgs.length) {
                        ScannerConfigBuilder.build(cfgs[i], 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
            }
            CfgDiscoveredPathManager.getInstance().updateCoreSettings(this.getProject(), cfgs);
        }
        return this.getProject().getReferencedProjects();
    }

    public static void build(IConfiguration cfg, int flags, IProgressMonitor monitor) {
        if (cfg != null) {
            ICfgScannerConfigBuilderInfo2Set info = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo(cfg);
            IProject project = cfg.getOwner().getProject();
            Map<CfgInfoContext, IScannerConfigBuilderInfo2> infoMap = info.getInfoMap();
            int num = infoMap.size();
            if (num != 0) {
                Properties envProps = ScannerConfigBuilder.calcEnvironment(cfg);
                monitor.beginTask(MakeMessages.getString("ScannerConfigBuilder.Invoking_Builder"), num);
                for (Map.Entry<CfgInfoContext, IScannerConfigBuilderInfo2> entry : infoMap.entrySet()) {
                    try {
                        CfgInfoContext c = entry.getKey();
                        IScannerConfigBuilderInfo2 buildInfo2 = entry.getValue();
                        ScannerConfigBuilder.build(c, buildInfo2, flags & 0xFFFFFFFE, envProps, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        ManagedBuilderCorePlugin.log(e);
                    }
                }
            }
            if ((flags & 1) != 0) {
                CfgDiscoveredPathManager.getInstance().updateCoreSettings(project, new IConfiguration[]{cfg});
            }
        }
    }

    private static Properties calcEnvironment(IConfiguration cfg) {
        Properties envProps = new Properties();
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] vars = mngr.getVariables(cfgDes, true);
        int i = 0;
        while (i < vars.length) {
            envProps.setProperty(vars[i].getName(), vars[i].getValue());
            ++i;
        }
        return envProps;
    }

    public static SCProfileInstance build(CfgInfoContext context, IScannerConfigBuilderInfo2 buildInfo2, int flags, Properties env, IProgressMonitor monitor) throws CoreException {
        IConfiguration cfg = context.getConfiguration();
        if (ScannerDiscoveryLegacySupport.isLegacyScannerDiscoveryOn((ICConfigurationDescription)ManagedBuildManager.getDescriptionForConfiguration(cfg))) {
            IProject project = cfg.getOwner().getProject();
            boolean autodiscoveryEnabled2 = buildInfo2.isAutoDiscoveryEnabled();
            if (autodiscoveryEnabled2 || (flags & 2) != 0) {
                monitor.beginTask(MakeMessages.getString("ScannerConfigBuilder.Invoking_Builder"), 100);
                monitor.subTask(String.valueOf(MakeMessages.getString("ScannerConfigBuilder.Invoking_Builder")) + project.getName());
                if (env == null) {
                    env = ScannerConfigBuilder.calcEnvironment(cfg);
                }
                SCProfileInstance instance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, context.toInfoContext(), buildInfo2.getSelectedProfileId());
                if (!((flags & 4) != 0 || instance != null && buildInfo2.getProviderIdList().isEmpty())) {
                    instance = CfgSCJobsUtil.getProviderScannerInfo(project, context, instance, buildInfo2, env, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                }
                CfgSCJobsUtil.updateScannerConfiguration(project, context, instance, buildInfo2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                CfgDiscoveredPathManager.getInstance().removeDiscoveredInfo(project, context, false);
                if ((flags & 1) != 0) {
                    CfgDiscoveredPathManager.getInstance().updateCoreSettings(project, new IConfiguration[]{cfg});
                }
                return instance;
            }
        }
        return null;
    }
}

