/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.vpg.AnnotationType;
import org.eclipse.photran.internal.core.vpg.EdgeType;
import org.eclipse.photran.internal.core.vpg.IPhotranSerializable;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.PhotranVPGSerializer;
import org.eclipse.rephraserengine.core.util.OffsetLength;
import org.eclipse.rephraserengine.core.vpg.NodeRef;

public class PhotranTokenRef
extends NodeRef<Token>
implements IPhotranSerializable {
    private static final long serialVersionUID = 1L;

    public PhotranTokenRef(String filename, int offset, int length) {
        super(filename, offset, length);
        if (filename == null) {
            throw new IllegalArgumentException();
        }
    }

    public PhotranTokenRef(IFile file, int offset, int length) {
        this(file == null ? "" : PhotranVPG.getFilenameForIFile((IFile)file), offset, length);
    }

    public PhotranTokenRef(PhotranTokenRef copyFrom) {
        super((NodeRef)copyFrom);
    }

    public PhotranTokenRef(String filename, OffsetLength ol) {
        this(filename, ol.getOffset(), ol.getLength());
    }

    public IFile getFile() {
        return PhotranVPG.getIFileForFilename((String)this.getFilename());
    }

    public Token getASTNode() {
        return this.findToken();
    }

    public Token findToken() {
        IFortranAST ast;
        block3: {
            try {
                ast = (IFortranAST)PhotranVPG.getInstance().acquireTransientAST(this.getFilename());
                if (ast != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return ast.findTokenByStreamOffsetLength(this.getOffset(), this.getLength());
    }

    public Token findTokenOrReturnNull() {
        return this.findToken();
    }

    public String getText() {
        return this.findToken().getText();
    }

    public int compareTo(PhotranTokenRef that) {
        int result = this.getFilename().compareTo(that.getFilename());
        if (result == 0) {
            result = Integer.valueOf(this.getOffset()).compareTo(that.getOffset());
        }
        if (result == 0) {
            result = Integer.valueOf(this.getLength()).compareTo(that.getLength());
        }
        return result;
    }

    public Iterable<PhotranTokenRef> followOutgoing(int edgeType) {
        return super.followOutgoing(edgeType);
    }

    public Iterable<PhotranTokenRef> followOutgoing(EdgeType edgeType) {
        return super.followOutgoing(edgeType.ordinal());
    }

    public Iterable<PhotranTokenRef> followIncoming(int edgeType) {
        return super.followIncoming(edgeType);
    }

    public Iterable<PhotranTokenRef> followIncoming(EdgeType edgeType) {
        return super.followIncoming(edgeType.ordinal());
    }

    public <R extends Serializable> R getAnnotation(AnnotationType annotationType) {
        return (R)super.getAnnotation(annotationType.ordinal());
    }

    protected PhotranVPG getVPG() {
        return PhotranVPG.getInstance();
    }

    public static PhotranTokenRef readFrom(InputStream in) throws IOException {
        String filename = (String)PhotranVPGSerializer.deserialize(in);
        int offset = (Integer)PhotranVPGSerializer.deserialize(in);
        int length = (Integer)PhotranVPGSerializer.deserialize(in);
        return new PhotranTokenRef(filename, offset, length);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        PhotranVPGSerializer.serialize(this.getFilename(), out);
        PhotranVPGSerializer.serialize(this.getOffset(), out);
        PhotranVPGSerializer.serialize(this.getLength(), out);
    }

    @Override
    public char getSerializationCode() {
        return 'T';
    }
}

