/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.tasks.ui.TaskContextStore;
import org.eclipse.mylyn.internal.context.ui.state.ContextState;
import org.eclipse.mylyn.internal.context.ui.state.ContextStateManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class ContextMementoMigrator {
    @Deprecated
    public static final String PREFIX_TASK_TO_PERSPECTIVE = "org.eclipse.mylyn.ui.perspectives.task.";
    @Deprecated
    public static final String EDITOR_MEMENTO_PREFS_PREFIX = "editors.task.";
    private final ContextStateManager stateManager;
    private boolean deleteOldDataEnabled;

    public ContextMementoMigrator(ContextStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public void setDeleteOldDataEnabled(boolean deleteOldDataEnabled) {
        this.deleteOldDataEnabled = deleteOldDataEnabled;
    }

    public boolean isDeleteOldDataEnabled() {
        return this.deleteOldDataEnabled;
    }

    public IStatus migrateContextMementos(SubMonitor monitor) {
        String contextHandle;
        String key;
        int n;
        int n2;
        String[] stringArray;
        SubMonitor progress;
        String[] keys;
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.context.ui", 0, "Errors migrating saved editors and perspective settings", null);
        ScopedPreferenceStore perspectivePreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.mylyn.context.ui");
        ScopedPreferenceStore editorPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.mylyn.resources.ui");
        IEclipsePreferences[] perspectiveNodes = perspectivePreferenceStore.getPreferenceNodes(false);
        IEclipsePreferences[] editorNodes = editorPreferenceStore.getPreferenceNodes(false);
        monitor.beginTask("Migrating context information", 100);
        if (editorNodes.length > 0) {
            try {
                keys = editorNodes[0].keys();
                progress = monitor.newChild(80);
                progress.setWorkRemaining(keys.length);
                stringArray = keys;
                n2 = keys.length;
                n = 0;
                while (n < n2) {
                    key = stringArray[n];
                    if (key.startsWith(EDITOR_MEMENTO_PREFS_PREFIX)) {
                        contextHandle = key.substring(EDITOR_MEMENTO_PREFS_PREFIX.length());
                        String mementoString = editorPreferenceStore.getString(key);
                        if (mementoString != null && !mementoString.trim().equals("")) {
                            try {
                                ITask task;
                                XMLMemento oldMemento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString));
                                InteractionContext context = new InteractionContext(contextHandle, ContextCore.getCommonContextScaling());
                                ContextState state = this.stateManager.createMemento((IInteractionContext)context, contextHandle);
                                IMemento newMemnto = state.createMemento("org.eclipse.mylyn.context.ui.editors");
                                newMemnto.putMemento((IMemento)oldMemento);
                                String perspectiveId = perspectivePreferenceStore.getString(PREFIX_TASK_TO_PERSPECTIVE + contextHandle);
                                if (perspectiveId != null && perspectiveId.length() > 0) {
                                    IMemento perspectiveMemento = state.createMemento("org.eclipse.mylyn.context.ui.perspectives");
                                    perspectiveMemento.putString("activeId", perspectiveId);
                                }
                                if ((task = TasksUi.getRepositoryModel().getTask(contextHandle)) != null) {
                                    this.write(state, task);
                                }
                            }
                            catch (Exception e) {
                                status.add((IStatus)new Status(2, "org.eclipse.mylyn.context.ui", NLS.bind((String)"Migration of editor memento failed for {0}", (Object)contextHandle), (Throwable)e));
                            }
                        }
                        if (this.isDeleteOldDataEnabled()) {
                            editorNodes[0].remove(key);
                            if (perspectiveNodes.length > 0) {
                                perspectiveNodes[0].remove(PREFIX_TASK_TO_PERSPECTIVE + contextHandle);
                            }
                        }
                    }
                    progress.worked(1);
                    ++n;
                }
                progress.done();
            }
            catch (BackingStoreException e) {
                status.add((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Reading of editor mementos failed", (Throwable)e));
            }
        }
        if (perspectiveNodes.length > 0) {
            try {
                keys = perspectiveNodes[0].keys();
                progress = monitor.newChild(20);
                progress.setWorkRemaining(keys.length);
                stringArray = keys;
                n2 = keys.length;
                n = 0;
                while (n < n2) {
                    key = stringArray[n];
                    if (key.startsWith(PREFIX_TASK_TO_PERSPECTIVE) && !key.equals("org.eclipse.mylyn.ui.perspectives.task.none")) {
                        contextHandle = key.substring(PREFIX_TASK_TO_PERSPECTIVE.length());
                        String perspectiveId = perspectivePreferenceStore.getString(key);
                        if (perspectiveId != null && perspectiveId.length() > 0) {
                            try {
                                InteractionContext context = new InteractionContext(contextHandle, ContextCore.getCommonContextScaling());
                                ContextState state = this.stateManager.createMemento((IInteractionContext)context, contextHandle);
                                IMemento perspectiveMemento = state.createMemento("org.eclipse.mylyn.context.ui.perspectives");
                                perspectiveMemento.putString("activeId", perspectiveId);
                                ITask task = TasksUi.getRepositoryModel().getTask(contextHandle);
                                if (task != null) {
                                    this.write(state, task);
                                }
                            }
                            catch (Exception e) {
                                status.add((IStatus)new Status(2, "org.eclipse.mylyn.context.ui", NLS.bind((String)"Migration of editor memento failed for {0}", (Object)contextHandle), (Throwable)e));
                            }
                        }
                        if (this.isDeleteOldDataEnabled()) {
                            perspectiveNodes[0].remove(key);
                        }
                    }
                    progress.worked(1);
                    ++n;
                }
                progress.done();
            }
            catch (BackingStoreException e) {
                status.add((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Reading of perspective mementos failed", (Throwable)e));
            }
        }
        try {
            editorPreferenceStore.save();
        }
        catch (IOException e) {
            status.add((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Saving of preference store failed", (Throwable)e));
        }
        try {
            perspectivePreferenceStore.save();
        }
        catch (IOException e) {
            status.add((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Saving of preference store failed", (Throwable)e));
        }
        return status;
    }

    private void write(ContextState state, ITask task) throws IOException, CoreException {
        block6: {
            ICommonStorable storable = ((TaskContextStore)TasksUiPlugin.getContextStore()).getStorable(task);
            try {
                if (storable.exists("context-state.xml")) break block6;
                OutputStream out = storable.write("context-state.xml", null);
                try {
                    this.stateManager.write(out, state);
                }
                finally {
                    out.close();
                }
            }
            finally {
                storable.release();
            }
        }
    }
}

