/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rephraserengine.core.preservation.Replacement;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.VPG;

public final class ReplacementList
implements Iterable<Replacement> {
    protected final List<Replacement> list = new ArrayList<Replacement>();

    public ReplacementList() {
    }

    public ReplacementList(Replacement ... ops) {
        this();
        Replacement[] replacementArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            Replacement op = replacementArray[n2];
            this.add(op);
            ++n2;
        }
    }

    public ReplacementList without(Replacement opToOmit) {
        ReplacementList result = new ReplacementList();
        for (Replacement op : this.list) {
            if (op.equals(opToOmit)) continue;
            result.add(op);
        }
        return result;
    }

    @Override
    public Iterator<Replacement> iterator() {
        return this.list.iterator();
    }

    public void add(Replacement op) {
        if (op.isAddition() && this.needToMergeAlpha(op)) {
            this.mergeAlpha(op);
        } else {
            this.internalAdd(op);
        }
    }

    private boolean needToMergeAlpha(Replacement alpha) {
        return !this.list.isEmpty() && this.lastOp().isAddition() && this.lastOp().getFilename().equals(alpha.getFilename()) && this.lastOp().getOffset() == alpha.getOffset();
    }

    private Replacement lastOp() {
        return this.list.get(this.list.size() - 1);
    }

    private void mergeAlpha(Replacement alpha2) {
        Replacement alpha1 = this.list.remove(this.list.size() - 1);
        Replacement newAlpha = new Replacement(alpha1.getFilename(), alpha1.getOffset(), 0, alpha1.getNewLength() + alpha2.getNewLength());
        this.internalAdd(newAlpha);
    }

    private void internalAdd(Replacement opToAdd) {
        for (Replacement existingOp : this.list) {
            if (!opToAdd.overlaps(existingOp)) continue;
            throw new IllegalArgumentException("Cannot add operation " + opToAdd + " because it overlaps " + existingOp);
        }
        this.list.add(opToAdd);
    }

    public int offset(String filename, int offset) {
        int result = offset;
        for (Replacement op : this.list) {
            result += op.adjust(filename, offset);
        }
        return result;
    }

    public <T, R extends IVPGNode<T>> R projectInitial(R tokenRef, VPG<?, T, R> vpg) {
        for (Replacement replacement : this.list) {
            if (!replacement.origIntervalContains(tokenRef)) continue;
            return null;
        }
        String filename = tokenRef.getFilename();
        int newOffset = this.offset(filename, tokenRef.getOffset());
        int newEndOffset = this.offset(filename, tokenRef.getEndOffset());
        return vpg.getVPGNode(filename, newOffset, newEndOffset - newOffset);
    }

    public <T, R extends IVPGNode<T>> R projectFinal(R tokenRef, VPG<?, T, R> vpg) {
        for (Replacement replacement : this.list) {
            if (!replacement.newIntervalContains(tokenRef, this)) continue;
            return null;
        }
        return tokenRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Replacement op : this.list) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(op);
        }
        return sb.toString();
    }
}

