/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.DateAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PriorityAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.UserAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorSummaryPart
extends AbstractTaskEditorPart {
    private AbstractAttributeEditor summaryEditor;

    public TaskEditorSummaryPart() {
        this.setPartName(Messages.TaskEditorSummaryPart_Summary);
    }

    protected void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, int indent, boolean showLabel, boolean decorationEnabled, boolean readOnly) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            Image image;
            ITask.PriorityLevel priorityLevel;
            ITaskMapping mapping;
            editor.setReadOnly(readOnly);
            editor.setDecorationEnabled(decorationEnabled);
            boolean isPriority = this.isAttribute(attribute, "task.common.priority");
            if (showLabel && !isPriority) {
                editor.createLabelControl(composite, toolkit);
                GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(indent, 0).applyTo((Control)editor.getLabelControl());
            }
            if (isPriority && (mapping = this.getTaskEditorPage().getConnector().getTaskMapping(this.getTaskData())) != null && (priorityLevel = mapping.getPriorityLevel()) != null && (image = CommonImages.getImage((ImageDescriptor)TasksUiInternal.getPriorityImage(this.getTaskEditorPage().getTask()))) != null) {
                Label label = toolkit.createLabel(composite, null);
                label.setImage(image);
                GridDataFactory.defaultsFor((Control)label).indent(5, -3).applyTo((Control)label);
            }
            if (this.isAttribute(attribute, "task.common.date.modified") && editor instanceof DateAttributeEditor) {
                ((DateAttributeEditor)editor).setShowTime(true);
            }
            editor.createControl(composite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
    }

    protected Control addPriorityAttributeWithIcon(Composite composite, FormToolkit toolkit, TaskAttribute attribute, boolean forceReadOnly) {
        if (attribute != null) {
            PriorityAttributeEditor editor = new PriorityAttributeEditor(this.getModel(), attribute);
            if (editor != null) {
                editor.setDecorationEnabled(false);
                if (forceReadOnly) {
                    editor.setReadOnly(true);
                }
                ((AbstractAttributeEditor)editor).createControl(composite, toolkit);
                this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
            }
            return editor.getControl();
        }
        return null;
    }

    private boolean isAttribute(TaskAttribute attribute, String id) {
        return attribute.getId().equals(attribute.getTaskData().getAttributeMapper().mapToRepositoryKey(attribute.getParentAttribute(), id));
    }

    private void addSummaryText(Composite composite, FormToolkit toolkit) {
        TaskAttribute summaryAttrib = this.getTaskData().getRoot().getMappedAttribute("task.common.summary");
        this.summaryEditor = this.createAttributeEditor(summaryAttrib);
        if (this.summaryEditor != null) {
            if (summaryAttrib.getMetaData().isReadOnly()) {
                this.summaryEditor.setReadOnly(true);
            }
            if (this.summaryEditor instanceof RichTextAttributeEditor) {
                Composite roundedBorder = EditorUtil.createBorder(composite, toolkit, !this.summaryEditor.isReadOnly());
                this.summaryEditor.createControl(roundedBorder, toolkit);
                EditorUtil.setHeaderFontSizeAndStyle(this.summaryEditor.getControl());
            } else {
                Composite border = toolkit.createComposite(composite);
                GridDataFactory.fillDefaults().align(4, 1).hint(300, -1).grab(true, false).applyTo((Control)border);
                border.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(1, 4).create());
                this.summaryEditor.createControl(border, toolkit);
                GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(this.summaryEditor.getControl());
                toolkit.paintBordersFor(border);
            }
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.summaryEditor);
        }
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        TaskAttribute userAssignedAttribute;
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        TaskAttribute priorityAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.priority");
        final Control priorityEditor = this.addPriorityAttributeWithIcon(composite, toolkit, priorityAttribute, false);
        if (priorityEditor != null) {
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(1, 2).applyTo(priorityEditor);
            priorityEditor.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (TaskEditorSummaryPart.this.summaryEditor != null && TaskEditorSummaryPart.this.summaryEditor.getControl() != null) {
                        TaskEditorSummaryPart.this.summaryEditor.getControl().setFocus();
                        priorityEditor.removeFocusListener((FocusListener)this);
                    }
                }
            });
            ++layout.numColumns;
        }
        this.addSummaryText(composite, toolkit);
        if (Boolean.parseBoolean(this.getModel().getTaskRepository().getProperty("avatarSupport")) && (userAssignedAttribute = this.getTaskData().getRoot().getMappedAttribute("task.common.user.assigned")) != null) {
            UserAttributeEditor editor = new UserAttributeEditor(this.getModel(), userAssignedAttribute);
            editor.createControl(composite, toolkit);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(1, 2).indent(0, 2).applyTo(editor.getControl());
            layout.marginRight = 1;
            ++layout.numColumns;
        }
        if (this.needsHeader()) {
            this.createHeaderLayout(composite, toolkit);
        }
        toolkit.paintBordersFor(composite);
        this.setControl((Control)composite);
    }

    protected Composite createHeaderLayout(Composite composite, FormToolkit toolkit) {
        Composite headerComposite = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        headerComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)headerComposite);
        this.createAttributeEditors(toolkit, headerComposite);
        layout.numColumns = headerComposite.getChildren().length;
        if (layout.numColumns == 0) {
            layout.numColumns = 1;
            toolkit.createLabel(headerComposite, " ");
        }
        return headerComposite;
    }

    protected void createAttributeEditors(FormToolkit toolkit, Composite headerComposite) {
        TaskAttribute statusAtribute = this.getTaskData().getRoot().getMappedAttribute("task.common.status");
        this.addAttribute(headerComposite, toolkit, statusAtribute, 0, true, true, true);
        ITaskMapping mapping = this.getTaskEditorPage().getConnector().getTaskMapping(this.getTaskData());
        if (mapping != null && mapping.getResolution() != null && mapping.getResolution().length() > 0) {
            TaskAttribute resolutionAtribute = this.getTaskData().getRoot().getMappedAttribute("task.common.resolution");
            this.addAttribute(headerComposite, toolkit, resolutionAtribute, 0, false, false, true);
        }
        TaskAttribute dateCreation = this.getTaskData().getRoot().getMappedAttribute("task.common.date.created");
        this.addAttribute(headerComposite, toolkit, dateCreation, 6, true, false, true);
        TaskAttribute dateModified = this.getTaskData().getRoot().getMappedAttribute("task.common.date.modified");
        this.addAttribute(headerComposite, toolkit, dateModified, 6, true, false, true);
    }

    public boolean needsHeader() {
        return !this.getTaskData().isNew();
    }

    public void setFocus() {
        if (this.summaryEditor != null && this.summaryEditor.getControl() != null) {
            this.summaryEditor.getControl().setFocus();
        }
    }
}

