/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.launch;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.PreferenceConstants;
import org.eclipse.ptp.internal.etfw.jaxb.JAXBInitializationUtil;
import org.eclipse.ptp.internal.etfw.jaxb.data.BuildToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.EtfwToolProcessType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ExecToolType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolAppType;
import org.eclipse.ptp.internal.etfw.jaxb.data.ToolPaneType;
import org.eclipse.ptp.internal.etfw.jaxb.util.JAXBExtensionUtils;
import org.eclipse.ptp.internal.etfw.launch.ETFWParentLaunchConfigurationTab;
import org.eclipse.ptp.internal.etfw.launch.messages.Messages;
import org.eclipse.ptp.internal.etfw.ui.ExternalToolSelectionTab;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBControllerLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.JAXBDynamicLaunchConfigurationTab;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.CommandType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PerformanceAnalysisTab
extends AbstractLaunchConfigurationTab
implements IToolLaunchConfigurationConstants,
IExecutableExtension {
    private static final String TAB_ID = "org.eclipse.ptp.internal.etfw.launch.PerformanceAnalysisTab";
    protected boolean noPTP = false;
    private EtfwToolProcessType etfwTool;
    private ETFWParentLaunchConfigurationTab launchTabParent;
    private IVariableMap vmap;
    private ILaunchConfiguration launchConfiguration = null;
    private ILaunchController controller;
    private final WidgetListener listener = new WidgetListener();
    private List<ToolPaneType> toolTabs;
    private Composite topComposite;
    private Composite toolComposite;
    private Composite bottomComposite;
    private Combo toolCombo;
    private Label selectToolLbl;
    private Button buildOnlyCheck;
    private Button analyzeonlyCheck;
    private final LinkedList<IJAXBLaunchConfigurationTab> tabControllers = new LinkedList();
    private final ContentsChangedListener launchContentsChangedListener = new ContentsChangedListener();
    private ExternalToolSelectionTab saxETFWTab;

    public PerformanceAnalysisTab() {
        this(false);
    }

    public PerformanceAnalysisTab(boolean noPar) {
        this.noPTP = noPar;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        GridLayout layout = new GridLayout();
        content.setLayout((Layout)layout);
        this.topComposite = new Composite(content, 0);
        this.topComposite.setLayout((Layout)new GridLayout(2, false));
        this.topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolComposite = new Composite(content, 0);
        this.toolComposite.setLayout((Layout)new FillLayout());
        this.toolComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.bottomComposite = new Composite(content, 0);
        this.bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.bottomComposite.setLayout((Layout)new GridLayout(1, false));
        this.buildOnlyCheck = new Button(this.bottomComposite, 32);
        this.buildOnlyCheck.setText(Messages.PerformanceAnalysisTab_BuildInstrumentedExecutable);
        this.analyzeonlyCheck = new Button(this.bottomComposite, 32);
        this.analyzeonlyCheck.setText(Messages.PerformanceAnalysisTab_SelectExistingPerfData);
        if (this.noPTP) {
            this.buildSAXParserUI();
        } else {
            String parser = PreferenceConstants.getVersion();
            if (parser.equals("sax-parser")) {
                this.buildSAXParserUI();
            } else {
                this.buildJAXBParserUI();
            }
        }
    }

    private void buildSAXParserUI() {
        this.bottomComposite.setVisible(false);
        this.saxETFWTab = new ExternalToolSelectionTab(this.noPTP);
        this.saxETFWTab.createControl(this.toolComposite);
        this.saxETFWTab.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.toolComposite.getParent().layout();
        this.toolComposite.layout();
    }

    private void buildJAXBParserUI() {
        this.selectToolLbl = new Label(this.topComposite, 0);
        this.selectToolLbl.setText(Messages.PerformanceAnalysisTab_SelectTool);
        this.toolCombo = new Combo(this.topComposite, 8);
        this.toolCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        String[] toolNames = JAXBExtensionUtils.getToolNames();
        this.toolCombo.add(Messages.PerformanceAnalysisTab_PleaseSelectWorkflow);
        String[] stringArray = toolNames;
        int n = toolNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.toolCombo.add(name);
            ++n2;
        }
        this.toolCombo.addSelectionListener((SelectionListener)this.listener);
        this.toolComposite.getParent().layout();
        this.topComposite.layout();
        this.toolComposite.layout();
    }

    private void addAttribute(String name, String value) {
        AttributeType attr = this.vmap.get(name);
        if (attr == null) {
            attr = new AttributeType();
            attr.setName(name);
            attr.setVisible(Boolean.valueOf(true));
            attr.setReadOnly(Boolean.valueOf(true));
            this.vmap.put(name, attr);
        }
        attr.setValue((Object)value);
    }

    private void setConnectionPropertyAttributes(IRemoteConnection conn) {
        String property = conn.getProperty("os.arch");
        if (property != null) {
            this.addAttribute("os.arch", property);
        }
        if ((property = conn.getProperty("os.name")) != null) {
            this.addAttribute("os.name", property);
        }
        if ((property = conn.getProperty("os.version")) != null) {
            this.addAttribute("os.version", property);
        }
    }

    private void rebuildTab(String toolName) {
        IRemoteConnectionManager connMgr;
        IRemoteConnection remoteConnection;
        if (toolName.equals(Messages.PerformanceAnalysisTab_PleaseSelectWorkflow)) {
            this.clearOldWidgets();
            return;
        }
        this.etfwTool = JAXBExtensionUtils.getTool((String)toolName);
        this.vmap = this.controller.getEnvironment();
        JAXBInitializationUtil.initializeMap((EtfwToolProcessType)this.etfwTool, (IVariableMap)this.vmap);
        IRemoteServices services = RemoteServices.getRemoteServices((String)this.controller.getRemoteServicesId());
        if (services != null && (remoteConnection = (connMgr = services.getConnectionManager()).getConnection(this.controller.getConnectionName())) != null) {
            this.setConnectionPropertyAttributes(remoteConnection);
        }
        try {
            this.launchTabParent = new ETFWParentLaunchConfigurationTab(this.controller, (IProgressMonitor)new NullProgressMonitor(), this.vmap);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        this.launchTabParent.addContentsChangedListener(this.launchContentsChangedListener);
        for (IJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            tabControl.getLocalWidgets().clear();
        }
        this.tabControllers.clear();
        Control[] controlArray = this.toolComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.etfwTool.getControlData() != null) {
            for (CommandType command : this.etfwTool.getControlData().getInitializeCommand()) {
                if (command == null) continue;
                try {
                    this.controller.runCommand(command, this.vmap);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        this.toolTabs = this.findTabControllers();
        for (ToolPaneType toolTab : this.toolTabs) {
            this.tabControllers.add((IJAXBLaunchConfigurationTab)new JAXBDynamicLaunchConfigurationTab(this.controller, toolTab.getOptionPane(), (JAXBControllerLaunchConfigurationTab)this.launchTabParent));
        }
        this.launchTabParent.addDynamicContent(this.tabControllers);
        try {
            this.launchTabParent.createControl(this.toolComposite, this.controller.getControlId());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.handleUpdate();
    }

    private void handleUpdate() {
        this.launchTabParent.initializeFrom(this.launchConfiguration);
        for (IJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            for (IUpdateModel m : tabControl.getLocalWidgets().values()) {
                m.initialize(this.launchConfiguration, this.vmap, (IVariableMap)this.launchTabParent.getVariableMap());
            }
            ((JAXBDynamicLaunchConfigurationTab)tabControl).initializeFrom(this.launchConfiguration);
        }
    }

    private List<ToolPaneType> findTabControllers() {
        ArrayList<ToolPaneType> subTabs = new ArrayList<ToolPaneType>();
        for (Object tool : this.etfwTool.getExecToolOrAnalysisToolOrBuildTool()) {
            if (tool instanceof BuildToolType) {
                BuildToolType buildTool = (BuildToolType)tool;
                if (buildTool.getGlobal() != null) {
                    for (ToolPaneType toolPane : buildTool.getGlobal().getToolPanes()) {
                        if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                        subTabs.add(toolPane);
                    }
                }
                if (buildTool.getAllCompilers() == null) continue;
                for (ToolPaneType toolPane : buildTool.getAllCompilers().getToolPanes()) {
                    if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                    subTabs.add(toolPane);
                }
                continue;
            }
            if (!(tool instanceof ExecToolType)) continue;
            ExecToolType execTool = (ExecToolType)tool;
            if (execTool.getGlobal() != null) {
                for (ToolPaneType toolPane : execTool.getGlobal().getToolPanes()) {
                    if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                    subTabs.add(toolPane);
                }
            }
            for (ToolAppType toolApp : execTool.getExecUtils()) {
                for (ToolPaneType toolPane : toolApp.getToolPanes()) {
                    if (toolPane.isVirtual() || toolPane.getOptionPane() == null) continue;
                    subTabs.add(toolPane);
                }
            }
        }
        return subTabs;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        if (this.noPTP) {
            this.saxETFWTab.initializeFrom(configuration);
        } else {
            String rmType = LaunchUtils.getTemplateName((ILaunchConfiguration)configuration);
            String remId = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration);
            String remName = LaunchUtils.getConnectionName((ILaunchConfiguration)configuration);
            try {
                this.controller = LaunchControllerManager.getInstance().getLaunchController(remId, remName, rmType);
                if (this.controller != null) {
                    String parser = PreferenceConstants.getVersion();
                    if (parser.equals("sax-parser")) {
                        this.saxETFWTab.initializeFrom(configuration);
                    } else {
                        String toolName = configuration.getAttribute("selected_performance_tool", "");
                        int index = 0;
                        while (index < this.toolCombo.getItemCount()) {
                            if (this.toolCombo.getItem(index).equals(toolName)) {
                                this.toolCombo.select(index);
                                this.toolCombo.notifyListeners(13, null);
                                break;
                            }
                            ++index;
                        }
                        if (toolName.equals("")) {
                            this.toolCombo.select(0);
                            this.clearOldWidgets();
                        }
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.noPTP) {
            configuration.setAttribute("ETFW_VERSION", "sax-parser");
            this.saxETFWTab.performApply(configuration);
        } else {
            String parser = PreferenceConstants.getVersion();
            configuration.setAttribute("ETFW_VERSION", parser);
            if (parser.equals("sax-parser")) {
                this.saxETFWTab.performApply(configuration);
            } else if (this.toolCombo.getSelectionIndex() > 0) {
                String selectedtool = this.toolCombo.getItem(this.toolCombo.getSelectionIndex());
                configuration.setAttribute("selected_performance_tool", selectedtool);
                configuration.setAttribute("build_but_do_not_run_instrumented_executable", this.buildOnlyCheck.getSelection());
                configuration.setAttribute("analyze_existing_perf_data_in_specified_location_build/run_nothing", this.analyzeonlyCheck.getSelection());
                if (this.launchTabParent != null) {
                    this.launchTabParent.performApply(configuration);
                }
            }
        }
    }

    private void clearOldWidgets() {
        Control[] controlArray = this.toolComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public String getName() {
        return Messages.PerformanceAnalysisTab_Tab_Name;
    }

    public String getId() {
        return TAB_ID;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String error;
        this.setErrorMessage(null);
        if (this.toolCombo != null) {
            try {
                String toolName = configuration.getAttribute("selected_performance_tool", "");
                if (this.toolCombo.getSelectionIndex() != -1 && this.toolCombo.getItem(this.toolCombo.getSelectionIndex()).equals(toolName)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            this.setErrorMessage(Messages.PerformanceAnalysisTab_NoWorkflowSelected);
            return false;
        }
        if (this.launchTabParent != null && (error = this.launchTabParent.getUpdateHandler().getFirstError()) != null) {
            this.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null) {
            Map parameters = (Map)data;
            this.noPTP = Boolean.valueOf((String)parameters.get("noPTP"));
        }
    }

    private final class ContentsChangedListener
    implements IRMLaunchConfigurationContentsChangedListener {
        private ContentsChangedListener() {
        }

        public void handleContentsChanged(IRMLaunchConfigurationDynamicTab rmDynamicTab) {
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class WidgetListener
    extends SelectionAdapter {
        private String prevToolName;
        private String prevLaunchConfig;

        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (PerformanceAnalysisTab.this.getLaunchConfigurationDialog().getActiveTab().getName().equals(PerformanceAnalysisTab.this.getName())) {
                int selection = PerformanceAnalysisTab.this.toolCombo.getSelectionIndex();
                String toolName = PerformanceAnalysisTab.this.toolCombo.getItem(selection);
                if (!toolName.equals(this.prevToolName) || !PerformanceAnalysisTab.this.launchConfiguration.getName().equals(this.prevLaunchConfig)) {
                    this.prevToolName = toolName;
                    this.prevLaunchConfig = PerformanceAnalysisTab.this.launchConfiguration.getName();
                    PerformanceAnalysisTab.this.rebuildTab(toolName);
                }
            }
            PerformanceAnalysisTab.this.updateLaunchConfigurationDialog();
        }
    }
}

