/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.preservation;

import org.eclipse.rephraserengine.core.preservation.ReplacementList;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;

public final class Replacement {
    private final String filename;
    private final int offset;
    private final int origLength;
    private final int newLength;

    public Replacement(String filename, int offset, int oldLength, int newLength) {
        this.filename = filename;
        this.offset = offset;
        this.origLength = oldLength;
        this.newLength = newLength;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getOrigEndOffset() {
        return this.offset + this.origLength;
    }

    public int getOrigLength() {
        return this.origLength;
    }

    public int getNewLength() {
        return this.newLength;
    }

    public boolean isAddition() {
        return this.origLength == 0;
    }

    public boolean isRemoval() {
        return this.newLength == 0;
    }

    int adjust(String filename, int n) {
        if (this.filename.equals(filename) && n >= this.offset + this.origLength) {
            return this.newLength - this.origLength;
        }
        return 0;
    }

    boolean overlaps(Replacement that) {
        return !this.doesNotOverlap(that);
    }

    private boolean doesNotOverlap(Replacement that) {
        return !this.getFilename().equals(that.getFilename()) || this.getOrigEndOffset() <= that.getOffset() || this.getOffset() >= that.getOrigEndOffset();
    }

    boolean origIntervalContains(IVPGNode<?> tokenRef) {
        return this.filename.equals(tokenRef.getFilename()) && this.offset <= tokenRef.getOffset() && tokenRef.getEndOffset() <= this.getOrigEndOffset();
    }

    boolean newIntervalContains(IVPGNode<?> tokenRef, ReplacementList list) {
        if (!this.filename.equals(tokenRef.getFilename())) {
            return false;
        }
        list = list.without(this);
        int newOffset = list.offset(this.filename, this.getOffset());
        int newEndOffset = list.offset(this.filename, this.offset + this.newLength - 1) + 1;
        return newOffset <= tokenRef.getOffset() && tokenRef.getEndOffset() <= newEndOffset;
    }

    public String toString() {
        return String.valueOf(this.filename) + ": " + "[" + this.offset + ", " + (this.offset + this.origLength) + ")" + " // " + "[" + this.offset + ", " + (this.offset + this.newLength) + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.newLength;
        result = 31 * result + this.offset;
        result = 31 * result + this.origLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Replacement other = (Replacement)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.newLength != other.newLength) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return this.origLength == other.origLength;
    }
}

