/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.extra.DomainEvent;
import org.eclipse.dstore.extra.IDomainListener;
import org.eclipse.ptp.internal.remote.rse.core.DStoreHostShell;
import org.eclipse.ptp.internal.remote.rse.core.messages.Messages;
import org.eclipse.ptp.remote.core.AbstractRemoteProcess;
import org.eclipse.rse.internal.services.local.shells.LocalHostShell;
import org.eclipse.rse.services.shells.HostShellOutputStream;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;

public class RSEProcess
extends AbstractRemoteProcess
implements IHostShellOutputListener {
    private final boolean mergeOutput;
    private final IHostShell hostShell;
    private InputStream inputStream = null;
    private InputStream errorStream = null;
    private HostShellOutputStream outputStream = null;
    private PipedOutputStream hostShellInput = null;
    private PipedOutputStream hostShellError = null;
    private DataElement fStatus;
    private boolean fSpawnErrorFound = false;
    private String fSpawnErrorMessage;
    private boolean fErrorReported = false;
    private int fIndex = 0;
    private final IDomainListener fDomainListener = new IDomainListener(){

        public boolean listeningTo(DomainEvent e) {
            return e.getParent() == RSEProcess.this.fStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void domainChanged(DomainEvent e) {
            if (!RSEProcess.this.fSpawnErrorFound) {
                while (RSEProcess.this.fStatus != null && RSEProcess.this.fIndex < RSEProcess.this.fStatus.getNestedSize()) {
                    DataElement dataElement = RSEProcess.this.fStatus;
                    RSEProcess rSEProcess = RSEProcess.this;
                    int n = rSEProcess.fIndex;
                    rSEProcess.fIndex = n + 1;
                    DataElement element = dataElement.get(n);
                    String type = element.getType();
                    if (!type.equals("spawnError")) continue;
                    String command = element.getName();
                    String message = Messages.bind((String)Messages.RSEProcess_0, (Object)command);
                    PipedOutputStream pipedOutputStream = RSEProcess.this.hostShellInput;
                    synchronized (pipedOutputStream) {
                        RSEProcess.this.fSpawnErrorFound = true;
                        RSEProcess.this.fSpawnErrorMessage = message;
                    }
                }
            }
        }
    };

    public RSEProcess(IHostShell hostShell, boolean mergeOutput) throws IOException {
        this.hostShell = hostShell;
        this.mergeOutput = mergeOutput;
        this.hostShellInput = new PipedOutputStream();
        if (mergeOutput) {
            this.hostShellError = this.hostShellInput;
            this.errorStream = new NullInputStream();
        } else {
            this.hostShellError = new PipedOutputStream();
            this.errorStream = new PipedInputStream(this.hostShellError);
        }
        this.inputStream = new PipedInputStream(this.hostShellInput);
        this.outputStream = new HostShellOutputStream(hostShell);
        this.hostShell.getStandardOutputReader().addOutputListener((IHostShellOutputListener)this);
        if (this.hostShell.getStandardErrorReader() != null) {
            this.hostShell.getStandardErrorReader().addOutputListener((IHostShellOutputListener)this);
        }
        if (hostShell instanceof DStoreHostShell) {
            this.fStatus = ((DStoreHostShell)hostShell).getStatus();
        } else if (hostShell instanceof org.eclipse.rse.internal.services.dstore.shells.DStoreHostShell) {
            this.fStatus = ((org.eclipse.rse.internal.services.dstore.shells.DStoreHostShell)hostShell).getStatus();
        } else if (hostShell instanceof LocalHostShell) {
            this.fStatus = null;
        }
        if (this.fStatus != null) {
            this.fStatus.getDataStore().getDomainNotifier().addDomainListener(this.fDomainListener);
        }
    }

    public synchronized void destroy() {
        this.hostShell.exit();
        ((Object)((Object)this)).notifyAll();
        try {
            this.hostShellInput.close();
            if (!this.mergeOutput) {
                this.hostShellError.close();
            }
            this.inputStream.close();
            this.errorStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {}
    }

    public synchronized int exitValue() {
        if (this.hostShell.isActive()) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public synchronized int waitFor() throws InterruptedException {
        this.waitForHostShellTermination();
        try {
            ((Object)((Object)this)).wait(1000L);
            if (this.inputStream.available() != 0 || this.errorStream.available() != 0) {
                throw new InterruptedException();
            }
            this.hostShellInput.close();
            if (!this.mergeOutput) {
                this.hostShellError.close();
            }
            this.inputStream.close();
            this.errorStream.close();
            this.outputStream.close();
        }
        catch (IOException iOException) {}
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportSpawnError() throws IOException {
        Object object = this.fDomainListener;
        synchronized (object) {
            if (!this.fSpawnErrorFound) {
                while (this.fStatus != null && this.fIndex < this.fStatus.getNestedSize()) {
                    DataElement element;
                    String type;
                    if (!(type = (element = this.fStatus.get(this.fIndex++)).getType()).equals("spawnError")) continue;
                    String command = element.getName();
                    String message = Messages.bind((String)Messages.RSEProcess_0, (Object)command);
                    PipedOutputStream pipedOutputStream = this.hostShellInput;
                    synchronized (pipedOutputStream) {
                        this.fSpawnErrorFound = true;
                        this.fSpawnErrorMessage = message;
                    }
                }
            }
        }
        object = this.hostShellInput;
        synchronized (object) {
            if (this.fSpawnErrorFound && !this.fErrorReported) {
                this.hostShellInput.write(this.fSpawnErrorMessage.getBytes());
                this.hostShellInput.flush();
                this.fErrorReported = true;
            }
        }
    }

    public boolean isCompleted() {
        try {
            this.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        PipedOutputStream outputStream;
        IHostOutput[] input = event.getLines();
        PipedOutputStream pipedOutputStream = outputStream = event.isError() ? this.hostShellError : this.hostShellInput;
        if (input.length == 0) {
            this.waitForHostShellTermination();
            try {
                this.reportSpawnError();
                ((OutputStream)outputStream).close();
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            IHostOutput[] iHostOutputArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                IHostOutput element = iHostOutputArray[n2];
                outputStream.write(element.getString().getBytes());
                ((OutputStream)outputStream).write(10);
                ((OutputStream)outputStream).flush();
                ++n2;
            }
        }
        catch (IOException iOException) {}
    }

    private synchronized void waitForHostShellTermination() {
        while (this.hostShell.isActive()) {
            try {
                ((Object)((Object)this)).wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public class NullInputStream
    extends InputStream {
        public int read() throws IOException {
            return -1;
        }

        public int available() {
            return 0;
        }
    }
}

