/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.ICGlobalVariableManager;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CGlobalVariableManager
implements ICGlobalVariableManager {
    private static final String GLOBAL_VARIABLE_LIST = "globalVariableList";
    private static final String GLOBAL_VARIABLE = "globalVariable";
    private static final String ATTR_GLOBAL_VARIABLE_PATH = "path";
    private static final String ATTR_GLOBAL_VARIABLE_NAME = "name";
    private CDebugTarget fDebugTarget;
    private IGlobalVariableDescriptor[] fInitialDescriptors = new IGlobalVariableDescriptor[0];
    private List<ICGlobalVariable> fGlobals;

    public CGlobalVariableManager(CDebugTarget target) {
        this.setDebugTarget(target);
        this.initialize();
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDebugTarget(CDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    public ICGlobalVariable[] getGlobals() {
        if (this.fGlobals == null) {
            try {
                this.addGlobals(this.getInitialDescriptors());
            }
            catch (DebugException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        return this.fGlobals.toArray(new ICGlobalVariable[this.fGlobals.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlobals(IGlobalVariableDescriptor[] descriptors) throws DebugException {
        this.fGlobals = new ArrayList<ICGlobalVariable>(10);
        MultiStatus ms = new MultiStatus(CDebugCorePlugin.getUniqueIdentifier(), 0, "", null);
        ArrayList<ICGlobalVariable> globals = new ArrayList<ICGlobalVariable>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            try {
                globals.add(this.getDebugTarget().createGlobalVariable(descriptors[i]));
            }
            catch (DebugException e) {
                ms.add(e.getStatus());
            }
            ++i;
        }
        if (globals.size() > 0) {
            List<ICGlobalVariable> list = this.fGlobals;
            synchronized (list) {
                this.fGlobals.addAll(globals);
            }
        }
        this.getDebugTarget().fireChangeEvent(512);
        if (!ms.isOK()) {
            throw new DebugException((IStatus)ms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGlobals(ICGlobalVariable[] globals) {
        List<ICGlobalVariable> list = this.fGlobals;
        synchronized (list) {
            this.fGlobals.removeAll(Arrays.asList(globals));
        }
        int i = 0;
        while (i < globals.length) {
            if (globals[i] instanceof CVariable) {
                ((CVariable)((Object)globals[i])).dispose();
            }
            ++i;
        }
        this.getDebugTarget().fireChangeEvent(512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllGlobals() {
        ICGlobalVariable[] globals;
        if (this.fGlobals == null) {
            return;
        }
        List<ICGlobalVariable> list = this.fGlobals;
        synchronized (list) {
            globals = this.fGlobals.toArray(new ICGlobalVariable[this.fGlobals.size()]);
            this.fGlobals.clear();
        }
        int i = 0;
        while (i < globals.length) {
            if (globals[i] instanceof CVariable) {
                ((CVariable)((Object)globals[i])).dispose();
            }
            ++i;
        }
        this.getDebugTarget().fireChangeEvent(512);
    }

    public void dispose() {
        if (this.fGlobals != null) {
            for (ICGlobalVariable global : this.fGlobals) {
                ((CVariable)((Object)global)).dispose();
            }
            this.fGlobals.clear();
            this.fGlobals = null;
        }
    }

    public String getMemento() {
        Document document = null;
        try {
            ICGlobalVariable[] globals;
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = document.createElement(GLOBAL_VARIABLE_LIST);
            document.appendChild(node);
            ICGlobalVariable[] iCGlobalVariableArray = globals = this.getGlobals();
            int n = globals.length;
            int n2 = 0;
            while (n2 < n) {
                ICGlobalVariable global = iCGlobalVariableArray[n2];
                IGlobalVariableDescriptor descriptor = global.getDescriptor();
                if (descriptor != null) {
                    Element child = document.createElement(GLOBAL_VARIABLE);
                    child.setAttribute(ATTR_GLOBAL_VARIABLE_NAME, descriptor.getName());
                    child.setAttribute(ATTR_GLOBAL_VARIABLE_PATH, descriptor.getPath().toOSString());
                    node.appendChild(child);
                }
                ++n2;
            }
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (TransformerException e) {
            DebugPlugin.log((Throwable)e);
        }
        return null;
    }

    private void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (root.getNodeName().equalsIgnoreCase(GLOBAL_VARIABLE_LIST)) {
                ArrayList<IGlobalVariableDescriptor> descriptors = new ArrayList<IGlobalVariableDescriptor>();
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element entry;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(GLOBAL_VARIABLE)) {
                        String name = entry.getAttribute(ATTR_GLOBAL_VARIABLE_NAME);
                        String pathString = entry.getAttribute(ATTR_GLOBAL_VARIABLE_PATH);
                        Path path = new Path(pathString);
                        if (path.isValidPath(pathString)) {
                            descriptors.add(CVariableFactory.createGlobalVariableDescriptor(name, (IPath)path));
                        }
                    }
                    ++i;
                }
                this.fInitialDescriptors = descriptors.toArray(new IGlobalVariableDescriptor[descriptors.size()]);
                return;
            }
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(InternalDebugCoreMessages.getString("CGlobalVariableManager.0"), ex);
    }

    private void initialize() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            String memento = config.getAttribute("org.eclipse.cdt.launch.GLOBAL_VARIABLES", "");
            if (memento != null && memento.trim().length() != 0) {
                this.initializeFromMemento(memento);
            }
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private IGlobalVariableDescriptor[] getInitialDescriptors() {
        return this.fInitialDescriptors;
    }

    public void save() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.GLOBAL_VARIABLES", this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    @Override
    public IGlobalVariableDescriptor[] getDescriptors() {
        if (this.fGlobals == null) {
            return this.getInitialDescriptors();
        }
        ArrayList<IGlobalVariableDescriptor> descrs = new ArrayList<IGlobalVariableDescriptor>();
        for (ICGlobalVariable global : this.fGlobals) {
            IGlobalVariableDescriptor descr = global.getDescriptor();
            if (descr == null) continue;
            descrs.add(descr);
        }
        return descrs.toArray(new IGlobalVariableDescriptor[descrs.size()]);
    }
}

