/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.StreamInput;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

public class Stream {
    private Long id = null;
    private StructDeclaration packetContextDecl = null;
    private StructDeclaration eventHeaderDecl = null;
    private StructDeclaration eventContextDecl = null;
    private CTFTrace trace = null;
    private Map<Long, IEventDeclaration> events = new HashMap<Long, IEventDeclaration>();
    private final Set<StreamInput> inputs = new HashSet<StreamInput>();

    public Stream(CTFTrace trace) {
        this.trace = trace;
    }

    public void setId(long id) {
        this.id = id;
        this.events = this.trace.createEvents(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public boolean isIdSet() {
        return this.id != null;
    }

    public boolean isEventHeaderSet() {
        return this.eventHeaderDecl != null;
    }

    public boolean isEventContextSet() {
        return this.eventContextDecl != null;
    }

    public boolean isPacketContextSet() {
        return this.packetContextDecl != null;
    }

    public void setEventHeader(StructDeclaration eventHeader) {
        this.eventHeaderDecl = eventHeader;
    }

    public void setEventContext(StructDeclaration eventContext) {
        this.eventContextDecl = eventContext;
    }

    public void setPacketContext(StructDeclaration packetContext) {
        this.packetContextDecl = packetContext;
    }

    public StructDeclaration getEventHeaderDecl() {
        return this.eventHeaderDecl;
    }

    public StructDeclaration getEventContextDecl() {
        return this.eventContextDecl;
    }

    public StructDeclaration getPacketContextDecl() {
        return this.packetContextDecl;
    }

    public Set<StreamInput> getStreamInputs() {
        return this.inputs;
    }

    public CTFTrace getTrace() {
        return this.trace;
    }

    public Map<Long, IEventDeclaration> getEvents() {
        return this.events;
    }

    public void addEvent(IEventDeclaration event) throws ParseException {
        if (this.events.get(null) != null) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        if (event.getId() == null && this.events.size() != 0) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        if (this.events.get(event.getId()) != null) {
            throw new ParseException("Event id already exists");
        }
        this.events.put(event.getId(), event);
    }

    public void addInput(StreamInput input) {
        this.inputs.add(input);
    }

    public String toString() {
        return "Stream [id=" + this.id + ", packetContextDecl=" + this.packetContextDecl + ", eventHeaderDecl=" + this.eventHeaderDecl + ", eventContextDecl=" + this.eventContextDecl + ", trace=" + this.trace + ", events=" + this.events + ", inputs=" + this.inputs + "]";
    }
}

