/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional;

import java.math.BigInteger;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.LabelPosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;

public class DisassemblyAnnotationModel
extends AnnotationModel {
    private DisassemblyDocument getDisassemblyDocument() {
        return (DisassemblyDocument)this.fDocument;
    }

    protected Position createPositionFromSourceLine(String fileName, int lineNumber) {
        if (fileName != null) {
            return this.getDisassemblyDocument().getSourcePosition(fileName, lineNumber);
        }
        return null;
    }

    protected Position createPositionFromSourceLine(IFile file, int lineNumber) {
        if (file != null) {
            return this.getDisassemblyDocument().getSourcePosition((IStorage)file, lineNumber);
        }
        return null;
    }

    protected Position createPositionFromAddress(BigInteger address) {
        AddressRangePosition p;
        if (address != null && (p = this.getDisassemblyDocument().getDisassemblyPosition(address)) != null && p.fValid) {
            return new Position(p.offset, p.length);
        }
        return null;
    }

    protected Position createPositionFromLabel(BigInteger address) {
        LabelPosition p;
        if (address != null && (p = this.getDisassemblyDocument().getLabelPosition(address)) != null && p.fValid) {
            return new Position(p.offset, p.length);
        }
        return null;
    }

    protected Position createPositionFromLabel(String label) {
        if (label != null) {
            try {
                Position[] labelPositions = this.getDisassemblyDocument().getPositions("category_labels");
                int labelLen = label.length();
                Position[] positionArray = labelPositions;
                int n = labelPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    String candidate;
                    Position position = positionArray[n2];
                    if (position instanceof LabelPosition && (candidate = ((LabelPosition)position).fLabel) != null && candidate.startsWith(label) && (candidate.length() == labelLen || candidate.charAt(labelLen) == '(')) {
                        return position;
                    }
                    ++n2;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                return null;
            }
        }
        return null;
    }
}

