/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.RECURSIVE;
    private List<Ref> commits = new LinkedList<Ref>();
    private boolean squash;
    private FastForwardMode fastForwardMode = FastForwardMode.FF;
    private boolean commit = true;

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MergeResult call() throws GitAPIException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException {
        MergeResult mergeResult;
        RevWalk revWalk;
        block32: {
            Object msg;
            block31: {
                MergeResult mergeResult2;
                block30: {
                    MergeResult msg22;
                    block29: {
                        Object squashedCommits;
                        block28: {
                            MergeResult mergeResult3;
                            block27: {
                                this.checkCallable();
                                this.checkParameters();
                                revWalk = null;
                                DirCacheCheckout dco = null;
                                try {
                                    try {
                                        boolean noProblems;
                                        Ref head = this.repo.getRef("HEAD");
                                        if (head == null) {
                                            throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                                        }
                                        StringBuilder refLogMessage = new StringBuilder("merge ");
                                        revWalk = new RevWalk(this.repo);
                                        Ref ref = this.commits.get(0);
                                        refLogMessage.append(ref.getName());
                                        ref = this.repo.peel(ref);
                                        ObjectId objectId = ref.getPeeledObjectId();
                                        if (objectId == null) {
                                            objectId = ref.getObjectId();
                                        }
                                        RevCommit srcCommit = revWalk.lookupCommit(objectId);
                                        ObjectId headId = head.getObjectId();
                                        if (headId == null) {
                                            revWalk.parseHeaders(srcCommit);
                                            dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                                            dco.setFailOnConflict(true);
                                            dco.checkout();
                                            RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                                            refUpdate.setNewObjectId(objectId);
                                            refUpdate.setExpectedOldObjectId(null);
                                            refUpdate.setRefLogMessage("initial pull", false);
                                            if (refUpdate.update() != RefUpdate.Result.NEW) {
                                                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                                            }
                                            this.setCallable(false);
                                            MergeResult mergeResult4 = new MergeResult(srcCommit, srcCommit, new ObjectId[]{null, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                                            Object var21_19 = null;
                                            if (revWalk == null) return mergeResult4;
                                            revWalk.release();
                                            return mergeResult4;
                                        }
                                        RevCommit headCommit = revWalk.lookupCommit(headId);
                                        if (revWalk.isMergedInto(srcCommit, headCommit)) {
                                            this.setCallable(false);
                                            mergeResult3 = new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                                            break block27;
                                        }
                                        if (revWalk.isMergedInto(headCommit, srcCommit) && this.fastForwardMode != FastForwardMode.NO_FF) {
                                            ObjectId newHead;
                                            refLogMessage.append(": " + (Object)((Object)MergeResult.MergeStatus.FAST_FORWARD));
                                            dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), srcCommit.getTree());
                                            dco.setFailOnConflict(true);
                                            dco.checkout();
                                            String msg22 = null;
                                            ObjectId base = null;
                                            MergeResult.MergeStatus mergeStatus = null;
                                            if (!this.squash) {
                                                this.updateHead(refLogMessage, srcCommit, headId);
                                                newHead = base = srcCommit;
                                                mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                                            } else {
                                                msg22 = JGitText.get().squashCommitNotUpdatingHEAD;
                                                newHead = base = headId;
                                                mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                                                squashedCommits = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                                                String squashMessage = new SquashMessageFormatter().format((List<RevCommit>)squashedCommits, head);
                                                this.repo.writeSquashCommitMsg(squashMessage);
                                            }
                                            this.setCallable(false);
                                            squashedCommits = new MergeResult(newHead, base, new ObjectId[]{headCommit, srcCommit}, mergeStatus, this.mergeStrategy, null, msg22);
                                            break block28;
                                        }
                                        if (this.fastForwardMode == FastForwardMode.FF_ONLY) {
                                            msg22 = new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ABORTED, this.mergeStrategy, null, null);
                                            break block29;
                                        }
                                        String mergeMessage = "";
                                        if (!this.squash) {
                                            mergeMessage = new MergeMessageFormatter().format(this.commits, head);
                                            this.repo.writeMergeCommitMsg(mergeMessage);
                                            this.repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
                                        } else {
                                            List<RevCommit> squashedCommits2 = RevWalkUtils.find(revWalk, srcCommit, headCommit);
                                            String squashMessage = new SquashMessageFormatter().format(squashedCommits2, head);
                                            this.repo.writeSquashCommitMsg(squashMessage);
                                        }
                                        Merger merger = this.mergeStrategy.newMerger(this.repo);
                                        Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults = null;
                                        Map<String, ResolveMerger.MergeFailureReason> failingPaths = null;
                                        List<String> unmergedPaths = null;
                                        if (merger instanceof ResolveMerger) {
                                            ResolveMerger resolveMerger = (ResolveMerger)merger;
                                            resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                                            resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                                            noProblems = merger.merge(headCommit, srcCommit);
                                            lowLevelResults = resolveMerger.getMergeResults();
                                            failingPaths = resolveMerger.getFailingPaths();
                                            unmergedPaths = resolveMerger.getUnmergedPaths();
                                        } else {
                                            noProblems = merger.merge(headCommit, srcCommit);
                                        }
                                        refLogMessage.append(": Merge made by ");
                                        if (!revWalk.isMergedInto(headCommit, srcCommit)) {
                                            refLogMessage.append(this.mergeStrategy.getName());
                                        } else {
                                            refLogMessage.append("recursive");
                                        }
                                        refLogMessage.append('.');
                                        if (noProblems) {
                                            dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                                            dco.setFailOnConflict(true);
                                            dco.checkout();
                                            msg = null;
                                            ObjectId newHeadId = null;
                                            MergeResult.MergeStatus mergeStatus = null;
                                            if (!this.commit && this.squash) {
                                                mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                                            }
                                            if (!this.commit && !this.squash) {
                                                mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                                            }
                                            if (this.commit && !this.squash) {
                                                newHeadId = new Git(this.getRepository()).commit().setReflogComment(refLogMessage.toString()).call().getId();
                                                mergeStatus = MergeResult.MergeStatus.MERGED;
                                            }
                                            if (this.commit && this.squash) {
                                                msg = JGitText.get().squashCommitNotUpdatingHEAD;
                                                newHeadId = headCommit.getId();
                                                mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                                            }
                                            mergeResult2 = new MergeResult(newHeadId, null, new ObjectId[]{headCommit.getId(), srcCommit.getId()}, mergeStatus, this.mergeStrategy, null, (String)msg);
                                            break block30;
                                        }
                                        if (failingPaths != null) {
                                            this.repo.writeMergeCommitMsg(null);
                                            this.repo.writeMergeHeads(null);
                                            msg = new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.FAILED, this.mergeStrategy, lowLevelResults, failingPaths, null);
                                            break block31;
                                        }
                                        String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths);
                                        this.repo.writeMergeCommitMsg(mergeMessageWithConflicts);
                                        mergeResult = new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, this.mergeStrategy, lowLevelResults, null);
                                        break block32;
                                    }
                                    catch (org.eclipse.jgit.errors.CheckoutConflictException e) {
                                        List<String> conflicts = dco == null ? Collections.emptyList() : dco.getConflicts();
                                        throw new CheckoutConflictException(conflicts, e);
                                    }
                                    catch (IOException e) {
                                        throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var21_26 = null;
                                    if (revWalk == null) throw throwable;
                                    revWalk.release();
                                    throw throwable;
                                }
                            }
                            Object var21_20 = null;
                            if (revWalk == null) return mergeResult3;
                            revWalk.release();
                            return mergeResult3;
                        }
                        Object var21_21 = null;
                        if (revWalk == null) return squashedCommits;
                        revWalk.release();
                        return squashedCommits;
                    }
                    Object var21_22 = null;
                    if (revWalk == null) return msg22;
                    revWalk.release();
                    return msg22;
                }
                Object var21_23 = null;
                if (revWalk == null) return mergeResult2;
                revWalk.release();
                return mergeResult2;
            }
            Object var21_24 = null;
            if (revWalk == null) return msg;
            revWalk.release();
            return msg;
        }
        Object var21_25 = null;
        if (revWalk == null) return mergeResult;
        revWalk.release();
        return mergeResult;
    }

    private void checkParameters() throws InvalidMergeHeadsException {
        if (this.squash && this.fastForwardMode == FastForwardMode.NO_FF) {
            throw new JGitInternalException(JGitText.get().cannotCombineSquashWithNoff);
        }
        if (this.commits.size() != 1) {
            throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public MergeCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public MergeCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public MergeCommand setSquash(boolean squash) {
        this.checkCallable();
        this.squash = squash;
        return this;
    }

    public MergeCommand setFastForward(FastForwardMode fastForwardMode) {
        this.checkCallable();
        this.fastForwardMode = fastForwardMode;
        return this;
    }

    public MergeCommand setCommit(boolean commit) {
        this.commit = commit;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FastForwardMode implements Config.ConfigEnum
    {
        FF,
        NO_FF,
        FF_ONLY;


        @Override
        public String toConfigValue() {
            return "--" + this.name().toLowerCase().replace('_', '-');
        }

        @Override
        public boolean matchConfigValue(String in) {
            if (StringUtils.isEmptyOrNull(in)) {
                return false;
            }
            if (!in.startsWith("--")) {
                return false;
            }
            return this.name().equalsIgnoreCase(in.substring(2).replace('-', '_'));
        }

        public static FastForwardMode valueOf(Merge ffMode) {
            switch (ffMode) {
                case FALSE: {
                    return NO_FF;
                }
                case ONLY: {
                    return FF_ONLY;
                }
            }
            return FF;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Merge {
            TRUE,
            FALSE,
            ONLY;


            public static Merge valueOf(FastForwardMode ffMode) {
                switch (ffMode) {
                    case NO_FF: {
                        return FALSE;
                    }
                    case FF_ONLY: {
                        return ONLY;
                    }
                }
                return TRUE;
            }
        }
    }
}

