/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.core.utils.BufferedProcessInputStream;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.osgi.util.NLS;

public final class RpmPackageBuildProposalsJob
extends Job {
    private static RpmPackageBuildProposalsJob job = null;
    private Object updatingLock = false;
    private boolean updating = false;
    private IJobChangeListener updateFinishedListener = new JobChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            Object object = RpmPackageBuildProposalsJob.this.updatingLock;
            synchronized (object) {
                RpmPackageBuildProposalsJob.this.updating = false;
                RpmPackageBuildProposalsJob.this.updatingLock.notifyAll();
            }
        }
    };
    protected static final IEclipsePreferences.IPreferenceChangeListener PROPERTY_LISTENER = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("currentRpmtools")) {
                RpmPackageBuildProposalsJob.update();
            }
        }
    };

    private RpmPackageBuildProposalsJob(String name) {
        super(name);
        this.addJobChangeListener(this.updateFinishedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForUpdates() {
        if (job != null) {
            try {
                Object object = RpmPackageBuildProposalsJob.job.updatingLock;
                synchronized (object) {
                    if (RpmPackageBuildProposalsJob.job.updating) {
                        RpmPackageBuildProposalsJob.job.updatingLock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        return this.retrievePackageList(monitor);
    }

    public boolean shouldSchedule() {
        return ((Object)((Object)this)).equals((Object)job);
    }

    public static void update() {
        boolean runJob = false;
        Date today = new Date();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.ui.editor");
        if (preferences.getBoolean("rpmListBackgroundBuild", true)) {
            int period = preferences.getInt("rpmListBuildPeriod", 1);
            if (period == 1) {
                runJob = true;
            } else {
                long lastBuildTime = preferences.getLong("rpmLisMastBuild", 0L);
                if (lastBuildTime == 0L) {
                    runJob = true;
                } else {
                    long interval = (today.getTime() - lastBuildTime) / 86400000L;
                    if (period == 2 && interval >= 7L) {
                        runJob = true;
                    } else if (period == 3 && interval >= 30L) {
                        runJob = true;
                    }
                }
            }
            if (runJob) {
                if (job == null) {
                    job = new RpmPackageBuildProposalsJob(Messages.RpmPackageBuildProposalsJob_0);
                    job.lockAndSchedule();
                    preferences.putLong("rpmLisMastBuild", today.getTime());
                } else {
                    job.cancel();
                    job.lockAndSchedule();
                    preferences.putLong("rpmLisMastBuild", today.getTime());
                }
            }
        } else if (job != null) {
            job.cancel();
            job = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndSchedule() {
        Object object = this.updatingLock;
        synchronized (object) {
            this.updating = true;
        }
        this.schedule();
    }

    private IStatus retrievePackageList(IProgressMonitor monitor) {
        block13: {
            String rpmListCmd = Activator.getDefault().getPreferenceStore().getString("currentRpmtools");
            String rpmListFilepath = Activator.getDefault().getPreferenceStore().getString("rpmListFilePath");
            File bkupFile = new File(String.valueOf(rpmListFilepath) + ".bkup");
            try {
                String line;
                monitor.beginTask(Messages.RpmPackageBuildProposalsJob_1, -1);
                if (!Utils.fileExist((String)"/bin/sh")) break block13;
                BufferedProcessInputStream in = Utils.runCommandToInputStream((String[])new String[]{"/bin/sh", "-c", rpmListCmd});
                File rpmListFile = new File(rpmListFilepath);
                if (rpmListFile.exists()) {
                    Utils.copyFile((File)new File(rpmListFilepath), (File)bkupFile);
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(rpmListFile, false));
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
                monitor.subTask(String.valueOf(Messages.RpmPackageBuildProposalsJob_2) + rpmListCmd + Messages.RpmPackageBuildProposalsJob_3);
                while ((line = reader.readLine()) != null) {
                    monitor.subTask(line);
                    out.write(String.valueOf(line) + "\n");
                    if (!monitor.isCanceled()) continue;
                    in.destroyProcess();
                    in.close();
                    out.close();
                    if (rpmListFile.exists() && bkupFile.exists()) {
                        Utils.copyFile((File)bkupFile, (File)rpmListFile);
                        bkupFile.delete();
                    }
                    Activator.packagesList = new RpmPackageProposalsList();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                in.close();
                out.close();
                bkupFile.delete();
                int processExitValue = 0;
                try {
                    processExitValue = in.getExitValue();
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
                try {
                    if (processExitValue != 0) {
                        SpecfileLog.log(2, processExitValue, NLS.bind((String)Messages.RpmPackageBuildProposalsJob_NonZeroReturn, (Object)processExitValue), null);
                    }
                }
                catch (IOException e) {
                    SpecfileLog.logError(e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
        }
        Activator.packagesList = new RpmPackageProposalsList();
        return Status.OK_STATUS;
    }

    public static void setPropertyChangeListener(boolean activated) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.rpm.ui.editor");
        if (activated) {
            preferences.addPreferenceChangeListener(PROPERTY_LISTENER);
        } else {
            preferences.removePreferenceChangeListener(PROPERTY_LISTENER);
        }
    }
}

