/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.custom;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomEventContent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class CustomEvent
extends TmfEvent {
    public static final byte TIMESTAMP_SCALE = -3;
    protected static final String TIMESTAMP_INPUT_FORMAT_KEY = "CE_TS_I_F";
    protected static final String NO_MESSAGE = "";
    private ITmfTimestamp customEventTimestamp;
    private ITmfEventField customEventContent;
    private ITmfEventType customEventType;
    protected CustomTraceDefinition fDefinition;
    protected Map<String, String> fData;
    private TmfEventField[] fColumnData;

    public CustomEvent(CustomTraceDefinition definition) {
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
    }

    public CustomEvent(CustomTraceDefinition definition, TmfEvent other) {
        super((ITmfEvent)other);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = other.getTimestamp();
        this.customEventContent = other.getContent();
        this.customEventType = other.getType();
    }

    public CustomEvent(CustomTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, String source, TmfEventType type, String reference) {
        super(parentTrace, null, source, null, null, reference);
        this.fDefinition = definition;
        this.fData = new HashMap<String, String>();
        this.customEventTimestamp = timestamp;
        this.customEventContent = null;
        this.customEventType = type;
    }

    public ITmfTimestamp getTimestamp() {
        if (this.fData != null) {
            this.processData();
        }
        return this.customEventTimestamp;
    }

    public ITmfEventField getContent() {
        return this.customEventContent;
    }

    public ITmfEventType getType() {
        return this.customEventType;
    }

    protected void setTimestamp(ITmfTimestamp timestamp) {
        this.customEventTimestamp = timestamp;
    }

    protected void setContent(ITmfEventField content) {
        this.customEventContent = content;
    }

    protected void setType(ITmfEventType type) {
        this.customEventType = type;
    }

    public TmfEventField[] extractItemFields() {
        if (this.fData != null) {
            this.processData();
        }
        return Arrays.copyOf(this.fColumnData, this.fColumnData.length);
    }

    private void processData() {
        String timeStampString = this.fData.get(CustomTraceDefinition.TAG_TIMESTAMP);
        String timeStampInputFormat = this.fData.get(TIMESTAMP_INPUT_FORMAT_KEY);
        Date date = null;
        if (timeStampInputFormat != null && timeStampString != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(timeStampInputFormat);
            try {
                date = dateFormat.parse(timeStampString);
                this.setTimestamp((ITmfTimestamp)new TmfTimestamp(date.getTime(), -3));
            }
            catch (ParseException parseException) {
                this.setTimestamp(TmfTimestamp.ZERO);
            }
        } else {
            this.setTimestamp(TmfTimestamp.ZERO);
        }
        int i = 0;
        this.fColumnData = new TmfEventField[this.fDefinition.outputs.size()];
        for (CustomTraceDefinition.OutputColumn outputColumn : this.fDefinition.outputs) {
            String value = this.fData.get(outputColumn.name);
            if (outputColumn.name.equals(CustomTraceDefinition.TAG_TIMESTAMP) && date != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.fDefinition.timeStampOutputFormat);
                this.fColumnData[i++] = new TmfEventField(outputColumn.name, (Object)dateFormat.format(date), null);
                continue;
            }
            this.fColumnData[i++] = new TmfEventField(outputColumn.name, (Object)(value != null ? value : NO_MESSAGE), null);
        }
        CustomEventContent curContent = (CustomEventContent)this.getContent();
        this.setContent((ITmfEventField)new CustomEventContent(curContent.getName(), curContent.getValue(), (ITmfEventField[])this.fColumnData));
        this.fData = null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fDefinition == null ? 0 : this.fDefinition.hashCode());
        result = 31 * result + (this.customEventTimestamp == null ? 0 : this.customEventTimestamp.hashCode());
        result = 31 * result + (this.customEventContent == null ? 0 : this.customEventContent.hashCode());
        result = 31 * result + (this.customEventType == null ? 0 : this.customEventType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CustomEvent)) {
            return false;
        }
        CustomEvent other = (CustomEvent)((Object)obj);
        if (this.fDefinition == null ? other.fDefinition != null : !this.fDefinition.equals(other.fDefinition)) {
            return false;
        }
        if (this.customEventTimestamp == null ? other.customEventTimestamp != null : !this.customEventTimestamp.equals(other.customEventTimestamp)) {
            return false;
        }
        if (this.customEventContent == null ? other.customEventContent != null : !this.customEventContent.equals(other.customEventContent)) {
            return false;
        }
        return !(this.customEventType == null ? other.customEventType != null : !this.customEventType.equals(other.customEventType));
    }
}

