/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class IntroduceCallTreeRefactoring
extends FortranResourceRefactoring {
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast == null) {
                    status.addError("One of the selected files (" + file.getName() + ") cannot be parsed.");
                    continue;
                }
                this.makeChangesTo(file, ast, status, pm);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) {
        List<ScopingNode> scopes = ast.getRoot().getAllContainedScopes();
        LinkedList<Character> blank_characters = new LinkedList<Character>();
        LinkedList<String> callStmtsOfScope = new LinkedList<String>();
        Integer line_int = new Integer(0);
        ASTNode scopeChanged = null;
        boolean hasCall = false;
        int mainProgramCalls = this.getMainProgramCalls(scopes);
        int scopeCalls = 0;
        for (ScopingNode scope : scopes) {
            scopeCalls = this.getScopeCalls(scopeCalls, scope);
            callStmtsOfScope.clear();
            blank_characters.clear();
            scopeChanged = null;
            hasCall = false;
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            IASTListNode<? extends IASTNode> body = scope.getBody();
            for (IASTNode iASTNode : body) {
                if (!(iASTNode instanceof ASTCallStmtNode)) continue;
                hasCall = true;
                scopeChanged = scope;
                line_int = scope instanceof ASTMainProgramNode ? Integer.valueOf(iASTNode.findFirstToken().getLine() + mainProgramCalls) : Integer.valueOf(iASTNode.findFirstToken().getLine() + scopeCalls + mainProgramCalls);
                String line = line_int.toString();
                callStmtsOfScope.add(String.valueOf(((ASTCallStmtNode)iASTNode).getSubroutineName().getText()) + " (on line <" + line + ">)");
            }
            if (!hasCall || scopeChanged == null) continue;
            Token token = scopeChanged.findFirstToken();
            String firstTokenText = token.getText();
            String tab = "";
            String headerStmt = ((ScopingNode)scopeChanged).getHeaderStmt().toString();
            String[] headerStmtWithoutComments = headerStmt.split("\n");
            headerStmt = headerStmtWithoutComments[headerStmtWithoutComments.length - 1];
            tab = this.getBlankCharacters(blank_characters, tab, headerStmt);
            String name = "";
            if (((ScopingNode)scopeChanged).isMainProgram()) {
                name = " in program ";
            }
            if (((ScopingNode)scopeChanged).isModule()) {
                name = " in module ";
            }
            if (((ScopingNode)scopeChanged).isSubprogram()) {
                name = " in subroutine ";
            }
            token.setText("! Calls" + name + ((ScopingNode)scopeChanged).getName().toUpperCase() + ": \n");
            int i = 0;
            while (i < callStmtsOfScope.size()) {
                String arrow = "=";
                int j = 0;
                while (j < i) {
                    arrow = String.valueOf(arrow) + "=";
                    ++j;
                }
                arrow = String.valueOf(arrow) + ">";
                token.setText(String.valueOf(token.getText()) + tab + "! " + arrow + " " + ((String)callStmtsOfScope.get(i)).toString() + "\n");
                ++i;
            }
            token.setText(String.valueOf(token.getText()) + tab + firstTokenText.trim());
        }
        this.addChangeFromModifiedAST(file, pm);
    }

    private String getBlankCharacters(List<Character> blank_characters, String tab, String headerStmt) {
        boolean start = false;
        int i = 0;
        while (i < headerStmt.length()) {
            char c = headerStmt.charAt(i);
            if (c != '\t' && c != ' ') {
                start = true;
            }
            if (!(c != '\t' && c != ' ' || start)) {
                blank_characters.add(Character.valueOf(headerStmt.charAt(i)));
            }
            ++i;
        }
        i = 0;
        while (i < blank_characters.size()) {
            tab = String.valueOf(tab) + blank_characters.get(i);
            ++i;
        }
        return tab;
    }

    private int getScopeCalls(int scopeCalls, ScopingNode scope) {
        if (!(scope instanceof ASTExecutableProgramNode) && !(scope instanceof ASTDerivedTypeDefNode)) {
            IASTListNode<? extends IASTNode> body = scope.getBody();
            int n = 0;
            for (IASTNode iASTNode : body) {
                if (!(iASTNode instanceof ASTCallStmtNode)) continue;
                ++n;
            }
            if (n > 0) {
                ++n;
            }
            scopeCalls += n;
        }
        return scopeCalls;
    }

    private int getMainProgramCalls(List<ScopingNode> scopes) {
        int mainProgramCalls = 0;
        for (ScopingNode scope : scopes) {
            if (!(scope instanceof ASTMainProgramNode)) continue;
            IASTListNode<? extends IASTNode> body = scope.getBody();
            for (IASTNode iASTNode : body) {
                if (!(iASTNode instanceof ASTCallStmtNode)) continue;
                ++mainProgramCalls;
            }
            if (mainProgramCalls <= 0) continue;
            ++mainProgramCalls;
        }
        return mainProgramCalls;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
    }

    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    public String getName() {
        return "Introduce Call Tree";
    }
}

