/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.RebaseTargetSelectionDialog;
import org.eclipse.egit.ui.internal.rebase.RebaseHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;

public class RebaseCurrentRefCommand
extends AbstractRebaseCommandHandler {
    public RebaseCurrentRefCommand() {
        super(null, null, null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Ref ref;
        ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)currentSelection;
            Object selected = selection.getFirstElement();
            ref = this.getRef(selected);
        } else {
            ref = null;
        }
        Repository repository = RebaseCurrentRefCommand.getRepository(event);
        if (repository == null) {
            return null;
        }
        BasicConfigurationDialog.show(repository);
        String currentFullBranch = this.getFullBranch(repository);
        if (ref != null && ref.getName().equals(currentFullBranch)) {
            ref = null;
        }
        if (ref == null) {
            RebaseTargetSelectionDialog rebaseTargetSelectionDialog = new RebaseTargetSelectionDialog(this.getShell(event), repository);
            if (rebaseTargetSelectionDialog.open() == 0) {
                String refName = rebaseTargetSelectionDialog.getRefName();
                try {
                    ref = repository.getRef(refName);
                }
                catch (IOException e) {
                    throw new ExecutionException(e.getMessage(), (Throwable)e);
                }
            } else {
                return null;
            }
        }
        String jobname = NLS.bind((String)UIText.RebaseCurrentRefCommand_RebasingCurrentJobName, (Object)Repository.shortenRefName((String)currentFullBranch), (Object)ref.getName());
        RebaseHelper.runRebaseJob(repository, jobname, ref);
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext ctx;
        Object selection;
        if (evaluationContext instanceof IEvaluationContext && (selection = this.getSelection(ctx = (IEvaluationContext)evaluationContext)) instanceof ISelection) {
            Repository repo = RebaseCurrentRefCommand.getRepository((ISelection)selection, this.getActiveEditorInput(ctx));
            if (repo != null) {
                boolean enabled = RebaseCurrentRefCommand.isEnabledForState(repo, repo.getRepositoryState());
                this.setBaseEnabled(enabled);
            } else {
                this.setBaseEnabled(false);
            }
            return;
        }
        this.setBaseEnabled(true);
    }

    public static boolean isEnabledForState(Repository repo, RepositoryState state) {
        return state == RepositoryState.SAFE && RebaseCurrentRefCommand.hasHead(repo);
    }

    private static boolean hasHead(Repository repo) {
        try {
            Ref headRef = repo.getRef("HEAD");
            return headRef != null && headRef.getObjectId() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private String getFullBranch(Repository repository) throws ExecutionException {
        try {
            return repository.getFullBranch();
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.RebaseCurrentRefCommand_ErrorGettingCurrentBranchMessage, (Throwable)e);
        }
    }
}

