/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.ui.dialogs.AbstractInPlaceDialog;
import org.eclipse.mylyn.commons.workbench.EnhancedFilteredTree;
import org.eclipse.mylyn.commons.workbench.SubstringPatternFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class InPlaceCheckBoxTreeDialog
extends AbstractInPlaceDialog {
    private final Map<String, String> validValues;
    private CheckboxFilteredTree valueTree;
    private final Set<String> selectedValues;
    private final String dialogLabel;

    public InPlaceCheckBoxTreeDialog(Shell shell, Control openControl, List<String> values, Map<String, String> validValues, String dialogLabel) {
        super(shell, 131072, openControl);
        Assert.isNotNull(values);
        Assert.isNotNull(validValues);
        Assert.isNotNull((Object)dialogLabel);
        this.selectedValues = new HashSet<String>(values);
        this.validValues = validValues;
        this.dialogLabel = dialogLabel;
        this.setShellStyle(this.getShellStyle());
    }

    protected Control createControl(Composite parent) {
        this.getShell().setText(this.dialogLabel);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.valueTree = new CheckboxFilteredTree(composite, 2850, new SubstringPatternFilter());
        gd = new GridData(1808);
        gd.heightHint = 175;
        gd.widthHint = 160;
        CheckboxTreeViewer viewer = this.valueTree.getViewer();
        viewer.getControl().setLayoutData((Object)gd);
        if (this.validValues != null) {
            viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof Map) {
                        return ((Map)parentElement).keySet().toArray();
                    }
                    return null;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    return this.getChildren(inputElement);
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        return (String)InPlaceCheckBoxTreeDialog.this.validValues.get(element);
                    }
                    return super.getText(element);
                }
            });
            viewer.setInput(this.validValues);
            HashSet<String> invalidValues = new HashSet<String>();
            for (String value : this.selectedValues) {
                if (this.validValues.containsKey(value)) continue;
                invalidValues.add(value);
            }
            for (String value : this.validValues.keySet()) {
                if (viewer.setChecked((Object)value, true)) continue;
                invalidValues.add(value);
            }
            this.selectedValues.removeAll(invalidValues);
            viewer.setCheckedElements(this.selectedValues.toArray());
        }
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InPlaceCheckBoxTreeDialog.this.selectedValues.add((String)event.getElement());
                } else {
                    InPlaceCheckBoxTreeDialog.this.selectedValues.remove(event.getElement());
                }
            }
        });
        return this.valueTree;
    }

    public Set<String> getSelectedValues() {
        return new HashSet<String>(this.selectedValues);
    }

    private class CheckboxFilteredTree
    extends EnhancedFilteredTree {
        public CheckboxFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
        }

        protected WorkbenchJob doCreateRefreshJob() {
            WorkbenchJob job = super.doCreateRefreshJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult() != null && event.getResult().isOK() && !CheckboxFilteredTree.this.getViewer().getTree().isDisposed()) {
                        CheckboxFilteredTree.this.getViewer().setCheckedElements(InPlaceCheckBoxTreeDialog.this.selectedValues.toArray());
                    }
                }
            });
            return job;
        }

        protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
            return new CheckboxTreeViewer(parent, style);
        }

        public CheckboxTreeViewer getViewer() {
            return (CheckboxTreeViewer)super.getViewer();
        }
    }
}

