/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.Messages;

public class TaskRelation {
    private final String taskId;
    private final Kind kind;
    private final Direction direction;

    private TaskRelation(Kind kind, Direction direction, String taskId) {
        Assert.isNotNull((Object)((Object)kind));
        Assert.isNotNull((Object)((Object)direction));
        Assert.isNotNull((Object)taskId);
        this.kind = kind;
        this.direction = direction;
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static TaskRelation parentTask(String taskId) {
        return new TaskRelation(Kind.CONTAINMENT, Direction.INWARD, taskId);
    }

    public static TaskRelation subtask(String taskId) {
        return new TaskRelation(Kind.CONTAINMENT, Direction.OUTWARD, taskId);
    }

    public static TaskRelation dependency(String taskId, Direction direction) {
        return new TaskRelation(Kind.DEPENDENCY, direction, taskId);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.kind.hashCode();
        result = 31 * result + this.taskId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskRelation other = (TaskRelation)obj;
        return this.direction.equals((Object)other.direction) && this.kind.equals((Object)other.kind) && this.taskId.equals(other.taskId);
    }

    public String toString() {
        if (this.kind == Kind.CONTAINMENT && this.direction == Direction.INWARD) {
            return Messages.TaskRelation_Parent;
        }
        if (this.kind == Kind.CONTAINMENT && this.direction == Direction.OUTWARD) {
            return Messages.TaskRelation_Subtask;
        }
        return Messages.TaskRelation_Dependency;
    }

    public static enum Direction {
        INWARD,
        OUTWARD;

    }

    public static enum Kind {
        CONTAINMENT,
        DEPENDENCY,
        DUPLICATE;

    }
}

