/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.core.op.IgnoreOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.securestorage.EGitSecureStore;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.team.core.RepositoryProvider;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin
implements DebugOptionsListener {
    private static Activator plugin;
    private static String pluginId;
    private RepositoryCache repositoryCache;
    private IndexDiffCache indexDiffCache;
    private RepositoryUtil repositoryUtil;
    private EGitSecureStore secureStore;
    private AutoShareProjects shareGitProjectsJob;
    private IResourceChangeListener preDeleteProjectListener;
    private IgnoreDerivedResources ignoreDerivedResourcesListener;

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return pluginId;
    }

    public static IStatus error(String message, Throwable thr) {
        return new Status(4, Activator.getPluginId(), 0, message, thr);
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        pluginId = context.getBundle().getSymbolicName();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", pluginId);
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.repositoryCache = new RepositoryCache();
        this.indexDiffCache = new IndexDiffCache();
        try {
            GitProjectData.reconfigureWindowCache();
        }
        catch (RuntimeException e) {
            Activator.logError(CoreText.Activator_ReconfigureWindowCacheError, e);
        }
        GitProjectData.attachToWorkspace(true);
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
        String gitPrefix = node.get("core_gitPrefix", null);
        if (gitPrefix != null) {
            FS.DETECTED.setGitPrefix(new File(gitPrefix));
        }
        this.repositoryUtil = new RepositoryUtil();
        this.secureStore = new EGitSecureStore(SecurePreferencesFactory.getDefault());
        this.registerAutoShareProjects();
        this.registerAutoIgnoreDerivedResources();
        this.registerPreDeleteResourceChangeListener();
    }

    private void registerPreDeleteResourceChangeListener() {
        if (this.preDeleteProjectListener == null) {
            this.preDeleteProjectListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResource dotGit;
                    IProject project;
                    IResource resource = event.getResource();
                    if (resource instanceof IProject && RepositoryProvider.getProvider((IProject)(project = (IProject)resource)) instanceof GitProvider && (dotGit = project.findMember(".git")) != null && dotGit.getType() == 2) {
                        GitProjectData.reconfigureWindowCache();
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.preDeleteProjectListener, 4);
        }
    }

    public void optionsChanged(DebugOptions options) {
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    public IndexDiffCache getIndexDiffCache() {
        return this.indexDiffCache;
    }

    public RepositoryUtil getRepositoryUtil() {
        return this.repositoryUtil;
    }

    public EGitSecureStore getSecureStore() {
        return this.secureStore;
    }

    public void stop(BundleContext context) throws Exception {
        GitProjectData.detachFromWorkspace();
        this.repositoryCache = null;
        this.indexDiffCache.dispose();
        this.indexDiffCache = null;
        this.repositoryUtil.dispose();
        this.repositoryUtil = null;
        this.secureStore = null;
        super.stop(context);
        plugin = null;
        if (this.preDeleteProjectListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.preDeleteProjectListener);
            this.preDeleteProjectListener = null;
        }
        if (this.ignoreDerivedResourcesListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.ignoreDerivedResourcesListener);
            this.ignoreDerivedResourcesListener = null;
        }
        if (this.shareGitProjectsJob != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.shareGitProjectsJob);
            this.shareGitProjectsJob = null;
        }
    }

    private void registerAutoShareProjects() {
        this.shareGitProjectsJob = new AutoShareProjects();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.shareGitProjectsJob, 1);
    }

    private void registerAutoIgnoreDerivedResources() {
        this.ignoreDerivedResourcesListener = new IgnoreDerivedResources();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.ignoreDerivedResourcesListener, 1);
    }

    private static class AutoShareProjects
    implements IResourceChangeListener {
        private static int INTERESTING_CHANGES = 16385;

        private boolean doAutoShare() {
            IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
            IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
            return p.getBoolean("core_autoShareProjects", d.getBoolean("core_autoShareProjects", true));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                final HashMap<IProject, File> projects = new HashMap<IProject, File>();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (!AutoShareProjects.this.doAutoShare()) {
                            return false;
                        }
                        if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
                            return true;
                        }
                        IResource resource = delta.getResource();
                        if (!resource.exists() || !resource.isAccessible() || resource.isLinked(512)) {
                            return false;
                        }
                        if (resource.getType() != 4) {
                            return true;
                        }
                        if (RepositoryMapping.getMapping(resource) != null) {
                            return false;
                        }
                        IProject project = (IProject)resource;
                        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                        if (provider != null) {
                            return false;
                        }
                        RepositoryFinder f = new RepositoryFinder(project);
                        Collection<RepositoryMapping> mappings = f.find((IProgressMonitor)new NullProgressMonitor());
                        try {
                            if (mappings.size() == 1) {
                                RepositoryMapping m = mappings.iterator().next();
                                File repositoryDir = m.getGitDirAbsolutePath().toFile();
                                projects.put(project, repositoryDir);
                                Activator.getDefault().getRepositoryUtil().addConfiguredRepository(repositoryDir);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            Activator.logError(CoreText.Activator_AutoSharingFailed, e);
                        }
                        return false;
                    }
                });
                if (projects.size() > 0) {
                    ConnectProviderOperation op = new ConnectProviderOperation(projects);
                    JobUtil.scheduleUserJob(op, CoreText.Activator_AutoShareJobName, JobFamilies.AUTO_SHARE);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }
    }

    private static class IgnoreDerivedResources
    implements IResourceChangeListener {
        private IgnoreDerivedResources() {
        }

        protected boolean autoIgnoreDerived() {
            IEclipsePreferences d = DefaultScope.INSTANCE.getNode(Activator.getPluginId());
            IEclipsePreferences p = InstanceScope.INSTANCE.getNode(Activator.getPluginId());
            return p.getBoolean("core_autoIgnoreDerivedResources", d.getBoolean("core_autoIgnoreDerivedResources", true));
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta d = event.getDelta();
                if (d == null || !this.autoIgnoreDerived()) {
                    return;
                }
                final ArrayList<IPath> toBeIgnored = new ArrayList<IPath>();
                d.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((delta.getKind() & 5) == 0) {
                            return false;
                        }
                        int flags = delta.getFlags();
                        if (flags != 0 && (flags & 0x400000) == 0) {
                            return false;
                        }
                        IResource r = delta.getResource();
                        if (r.getProject() != null && RepositoryMapping.getMapping(r) == null) {
                            return false;
                        }
                        if (r.isTeamPrivateMember()) {
                            return false;
                        }
                        if (r.isDerived()) {
                            try {
                                if (!RepositoryUtil.isIgnored(r.getLocation())) {
                                    toBeIgnored.add(r.getLocation());
                                }
                            }
                            catch (IOException e) {
                                Activator.logError(MessageFormat.format(CoreText.Activator_ignoreResourceFailed, r.getFullPath()), e);
                            }
                            return false;
                        }
                        return true;
                    }
                });
                if (toBeIgnored.size() > 0) {
                    JobUtil.scheduleUserJob(new IgnoreOperation(toBeIgnored), CoreText.Activator_autoIgnoreDerivedResources, JobFamilies.AUTO_IGNORE);
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
                return;
            }
        }
    }
}

