/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.SkipWorkTreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StashCreateCommand
extends GitCommand<RevCommit> {
    private static final String MSG_INDEX = "index on {0}: {1} {2}";
    private static final String MSG_WORKING_DIR = "WIP on {0}: {1} {2}";
    private String indexMessage = "index on {0}: {1} {2}";
    private String workingDirectoryMessage = "WIP on {0}: {1} {2}";
    private String ref = "refs/stash";
    private PersonIdent person;

    public StashCreateCommand(Repository repo) {
        super(repo);
        this.person = new PersonIdent(repo);
    }

    public StashCreateCommand setIndexMessage(String message) {
        this.indexMessage = message;
        return this;
    }

    public StashCreateCommand setWorkingDirectoryMessage(String message) {
        this.workingDirectoryMessage = message;
        return this;
    }

    public StashCreateCommand setPerson(PersonIdent person) {
        this.person = person;
        return this;
    }

    public StashCreateCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    private RevCommit parseCommit(ObjectReader reader, ObjectId headId) throws IOException {
        RevWalk walk = new RevWalk(reader);
        walk.setRetainBody(true);
        return walk.parseCommit(headId);
    }

    private CommitBuilder createBuilder(ObjectId headId) {
        CommitBuilder builder = new CommitBuilder();
        PersonIdent author = this.person;
        if (author == null) {
            author = new PersonIdent(this.repo);
        }
        builder.setAuthor(author);
        builder.setCommitter(author);
        builder.setParentId(headId);
        return builder;
    }

    private void updateStashRef(ObjectId commitId, PersonIdent refLogIdent, String refLogMessage) throws IOException {
        Ref currentRef = this.repo.getRef(this.ref);
        RefUpdate refUpdate = this.repo.updateRef(this.ref);
        refUpdate.setNewObjectId(commitId);
        refUpdate.setRefLogIdent(refLogIdent);
        refUpdate.setRefLogMessage(refLogMessage, false);
        if (currentRef != null) {
            refUpdate.setExpectedOldObjectId(currentRef.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    private Ref getHead() throws GitAPIException {
        try {
            Ref head = this.repo.getRef("HEAD");
            if (head == null || head.getObjectId() == null) {
                throw new NoHeadException(JGitText.get().headRequiredToStash);
            }
            return head;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashFailed, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException {
        this.checkCallable();
        Ref head = this.getHead();
        ObjectReader reader = this.repo.newObjectReader();
        try {
            try {
                ObjectId commitId;
                ArrayList<String> wtDeletes;
                ArrayList<1> wtEdits;
                ObjectInserter inserter;
                DirCache cache;
                RevCommit headCommit;
                block17: {
                    AbstractTreeIterator headIter;
                    TreeWalk treeWalk;
                    block16: {
                        headCommit = this.parseCommit(reader, head.getObjectId());
                        cache = this.repo.lockDirCache();
                        inserter = this.repo.newObjectInserter();
                        treeWalk = new TreeWalk(reader);
                        treeWalk.setRecursive(true);
                        treeWalk.addTree(headCommit.getTree());
                        treeWalk.addTree(new DirCacheIterator(cache));
                        treeWalk.addTree(new FileTreeIterator(this.repo));
                        treeWalk.setFilter(AndTreeFilter.create(new SkipWorkTreeFilter(1), new IndexDiffFilter(1, 2)));
                        if (treeWalk.next()) break block16;
                        RevCommit revCommit = null;
                        Object var22_10 = null;
                        inserter.release();
                        cache.unlock();
                        Object var24_14 = null;
                        reader.release();
                        return revCommit;
                    }
                    MutableObjectId id = new MutableObjectId();
                    wtEdits = new ArrayList<1>();
                    wtDeletes = new ArrayList<String>();
                    boolean hasChanges = false;
                    do {
                        headIter = treeWalk.getTree(0, AbstractTreeIterator.class);
                        DirCacheIterator indexIter = treeWalk.getTree(1, DirCacheIterator.class);
                        WorkingTreeIterator wtIter = treeWalk.getTree(2, WorkingTreeIterator.class);
                        if (indexIter != null && !indexIter.getDirCacheEntry().isMerged()) {
                            throw new UnmergedPathsException(new UnmergedPathException(indexIter.getDirCacheEntry()));
                        }
                        if (wtIter != null) {
                            Object var20_28;
                            if (indexIter == null && headIter == null) continue;
                            hasChanges = true;
                            if (indexIter != null && wtIter.idEqual(indexIter) || headIter != null && wtIter.idEqual(headIter)) continue;
                            treeWalk.getObjectId(id, 0);
                            final DirCacheEntry entry = new DirCacheEntry(treeWalk.getRawPath());
                            entry.setLength(wtIter.getEntryLength());
                            entry.setLastModified(wtIter.getEntryLastModified());
                            entry.setFileMode(wtIter.getEntryFileMode());
                            long contentLength = wtIter.getEntryContentLength();
                            InputStream in = wtIter.openEntryStream();
                            try {
                                entry.setObjectId(inserter.insert(3, contentLength, in));
                                var20_28 = null;
                                in.close();
                            }
                            catch (Throwable throwable) {
                                var20_28 = null;
                                in.close();
                                throw throwable;
                            }
                            wtEdits.add(new DirCacheEditor.PathEdit(entry){

                                public void apply(DirCacheEntry ent) {
                                    ent.copyMetaData(entry);
                                }
                            });
                        }
                        hasChanges = true;
                        if (wtIter != null || headIter == null) continue;
                        wtDeletes.add(treeWalk.getPathString());
                    } while (treeWalk.next());
                    if (hasChanges) break block17;
                    headIter = null;
                    Object var22_11 = null;
                    inserter.release();
                    cache.unlock();
                    Object var24_15 = null;
                    reader.release();
                    return headIter;
                }
                try {
                    String branch = Repository.shortenRefName(head.getTarget().getName());
                    CommitBuilder builder = this.createBuilder(headCommit);
                    builder.setTreeId(cache.writeTree(inserter));
                    builder.setMessage(MessageFormat.format(this.indexMessage, branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()));
                    ObjectId indexCommit = inserter.insert(builder);
                    if (!wtEdits.isEmpty() || !wtDeletes.isEmpty()) {
                        DirCacheEditor editor = cache.editor();
                        for (DirCacheEditor.PathEdit pathEdit : wtEdits) {
                            editor.add(pathEdit);
                        }
                        for (String string : wtDeletes) {
                            editor.add(new DirCacheEditor.DeletePath(string));
                        }
                        editor.finish();
                    }
                    builder.addParentId(indexCommit);
                    builder.setMessage(MessageFormat.format(this.workingDirectoryMessage, branch, headCommit.abbreviate(7).name(), headCommit.getShortMessage()));
                    builder.setTreeId(cache.writeTree(inserter));
                    commitId = inserter.insert(builder);
                    inserter.flush();
                    this.updateStashRef(commitId, builder.getAuthor(), builder.getMessage());
                    Object var22_12 = null;
                    inserter.release();
                    cache.unlock();
                }
                catch (Throwable throwable) {
                    Object var22_13 = null;
                    inserter.release();
                    cache.unlock();
                    throw throwable;
                }
                new ResetCommand(this.repo).setMode(ResetCommand.ResetType.HARD).call();
                RevCommit revCommit = this.parseCommit(reader, commitId);
                Object var24_16 = null;
                reader.release();
                return revCommit;
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().stashFailed, e);
            }
        }
        catch (Throwable throwable) {
            Object var24_17 = null;
            reader.release();
            throw throwable;
        }
    }
}

