/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.internal.rdt.sync.ui.SynchronizeWizardExtensionDescriptor;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeWizardExtension;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeWizardExtensionDescriptor;

public class SynchronizeWizardExtensionRegistry {
    public static final String SYNCHRONIZE_WIZARD_EXTENSION = "synchronizeWizardExtension";
    private static List<ISynchronizeWizardExtensionDescriptor> fAllDescriptors;

    public static ISynchronizeWizardExtensionDescriptor[] getDescriptors() {
        SynchronizeWizardExtensionRegistry.loadDescriptors();
        if (fAllDescriptors != null) {
            return fAllDescriptors.toArray(new ISynchronizeWizardExtensionDescriptor[fAllDescriptors.size()]);
        }
        return new ISynchronizeWizardExtensionDescriptor[0];
    }

    public static ISynchronizeWizardExtension getSynchronizeWizardExtensionForProject(IProject project) {
        ISynchronizeWizardExtensionDescriptor[] iSynchronizeWizardExtensionDescriptorArray = SynchronizeWizardExtensionRegistry.getDescriptors();
        int n = iSynchronizeWizardExtensionDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeWizardExtensionDescriptor descriptor = iSynchronizeWizardExtensionDescriptorArray[n2];
            try {
                if (project.hasNature(descriptor.getNature())) {
                    return descriptor.getWizardExtension();
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    private static void loadDescriptors() {
        IExtensionPoint point;
        if (fAllDescriptors == null && (point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.sync.ui", SYNCHRONIZE_WIZARD_EXTENSION)) != null) {
            fAllDescriptors = new ArrayList<ISynchronizeWizardExtensionDescriptor>();
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    fAllDescriptors.add(new SynchronizeWizardExtensionDescriptor(configElement));
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

