/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.linuxtools.ctf.core.event.CTFCallsite;
import org.eclipse.linuxtools.tmf.core.event.lookup.TmfCallsite;

public class CtfTmfCallsite
extends TmfCallsite {
    private final String fEventName;
    private final long fInstructionPointer;

    CtfTmfCallsite(CTFCallsite callsite) {
        super(callsite.getFileName(), callsite.getFunctionName(), callsite.getLineNumber());
        this.fEventName = callsite.getEventName();
        this.fInstructionPointer = callsite.getIp();
    }

    public String getEventName() {
        return this.fEventName;
    }

    public long getIntructionPointer() {
        return this.fInstructionPointer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fEventName == null ? 0 : this.fEventName.hashCode());
        result = 31 * result + (int)(this.fInstructionPointer ^ this.fInstructionPointer >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CtfTmfCallsite other = (CtfTmfCallsite)obj;
        if (this.fEventName == null ? other.fEventName != null : !this.fEventName.equals(other.fEventName)) {
            return false;
        }
        return this.fInstructionPointer == other.fInstructionPointer;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getEventName()) + "@0x" + Long.toHexString(this.fInstructionPointer) + ": " + this.getFileName() + ':' + Long.toString(this.getLineNumber()) + ' ' + this.getFileName() + "()";
    }
}

