/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers.ActionUtils;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.model.Row;
import org.eclipse.ui.handlers.HandlerUtil;

public class RefreshJobHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null && !selection.isEmpty()) {
            Job cancelJob = new Job(Messages.AbstractControlHandler_ControlJob){

                protected IStatus run(IProgressMonitor monitor) {
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selected = objectArray[n2];
                        if (selected instanceof Row) {
                            Row row = (Row)selected;
                            JobStatusData status = row.status;
                            try {
                                ActionUtils.maybeUpdateJobState(status, monitor);
                                if (monitor.isCanceled()) {
                                    break;
                                }
                            }
                            catch (CoreException t) {
                                return CoreExceptionUtils.getErrorStatus((String)Messages.AbstractControlHandler_Failed_to_cancel_job, (Throwable)t);
                            }
                        }
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
            };
            cancelJob.setUser(true);
            cancelJob.schedule();
        }
        return null;
    }
}

