/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.internal.core.CharOperation;

public class TodoTaskParser {
    private static final Task[] EMPTY_TASK_ARRAY = new Task[0];
    private final char[][] tags;
    private final int[] priorities;
    private final boolean isTaskCaseSensitive;
    private final int[] order;

    public TodoTaskParser(char[][] taskTags, int[] taskPriorities, boolean isTaskCaseSensitive) {
        assert (taskPriorities.length == taskTags.length);
        this.tags = taskTags;
        this.priorities = taskPriorities;
        this.isTaskCaseSensitive = isTaskCaseSensitive;
        this.order = new int[taskTags.length];
        int i = 0;
        while (i < this.order.length) {
            this.order[i] = i;
            ++i;
        }
        int inc = this.order.length / 2;
        while (inc > 0) {
            int i2 = inc;
            while (i2 < this.order.length) {
                int j = i2;
                while (j >= inc && taskTags[this.order[j - inc]].length < taskTags[this.order[j]].length) {
                    int temp = this.order[j];
                    this.order[j] = this.order[j - inc];
                    this.order[j - inc] = temp;
                    j -= inc;
                }
                ++i2;
            }
            inc /= 2;
        }
    }

    public Task[] parse(IASTComment[] comments) {
        HashSet<String> locKeys = new HashSet<String>();
        ArrayList<Task> tasks = new ArrayList<Task>();
        IASTComment[] iASTCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            IASTFileLocation location = comment.getFileLocation();
            if (location != null) {
                String fileName = location.getFileName();
                int nodeOffset = location.getNodeOffset();
                String key = String.valueOf(fileName) + ':' + nodeOffset;
                if (locKeys.add(key)) {
                    this.parse(comment.getComment(), fileName, nodeOffset, location.getStartingLineNumber(), tasks);
                }
            }
            ++n2;
        }
        if (tasks.isEmpty()) {
            return EMPTY_TASK_ARRAY;
        }
        return tasks.toArray(new Task[tasks.size()]);
    }

    private void parse(char[] comment, String filename, int offset, int lineNumber, List<Task> tasks) {
        int commentLength = comment.length;
        int foundTaskIndex = tasks.size();
        char previous = comment[1];
        int i = 2;
        while (i < commentLength) {
            char[] tag = null;
            int j = 0;
            while (j < this.order.length) {
                block23: {
                    int itag = this.order[j];
                    tag = this.tags[itag];
                    int tagLength = tag.length;
                    if (!(tagLength == 0 || i + tagLength > commentLength || TodoTaskParser.isIdentifierStart(tag[0]) && TodoTaskParser.isIdentifierPart(previous))) {
                        int t = 0;
                        while (t < tagLength) {
                            char tc;
                            char sc;
                            int x = i + t;
                            if (x < commentLength && ((sc = comment[x]) == (tc = tag[t]) || !this.isTaskCaseSensitive && Character.toLowerCase(sc) == Character.toLowerCase(tc))) {
                                ++t;
                                continue;
                            }
                            break block23;
                        }
                        if (i + tagLength >= commentLength || !TodoTaskParser.isIdentifierPart(comment[i + tagLength - 1]) || !TodoTaskParser.isIdentifierPart(comment[i + tagLength])) {
                            Task task = new Task(filename, i, i + tagLength, lineNumber, String.valueOf(tag), "", this.priorities[itag]);
                            tasks.add(task);
                            i += tagLength - 1;
                            break;
                        }
                    }
                }
                ++j;
            }
            previous = comment[i];
            ++i;
        }
        boolean containsEmptyTask = false;
        int i2 = foundTaskIndex;
        while (i2 < tasks.size()) {
            char c;
            int maxValue;
            Task task = tasks.get(i2);
            int msgStart = task.start + task.tag.length();
            int n = maxValue = i2 + 1 < tasks.size() ? tasks.get(i2 + 1).start : commentLength;
            if (maxValue < msgStart) {
                maxValue = msgStart;
            }
            int end = -1;
            int j = msgStart;
            while (j < maxValue) {
                c = comment[j];
                if (c == '\n' || c == '\r') {
                    end = j;
                    break;
                }
                ++j;
            }
            if (end == -1) {
                j = maxValue;
                while (--j >= msgStart) {
                    c = comment[j];
                    if (c != '*') continue;
                    end = j;
                    break;
                }
                if (end == -1) {
                    end = maxValue;
                }
            }
            while (msgStart < end && CharOperation.isWhitespace((char)comment[end - 1])) {
                --end;
            }
            while (msgStart < end && (CharOperation.isWhitespace((char)comment[msgStart]) || comment[msgStart] == ':')) {
                ++msgStart;
            }
            if (msgStart == end) {
                containsEmptyTask = true;
            } else {
                task.end = end;
                int messageLength = end - msgStart;
                task.message = String.valueOf(comment, msgStart, messageLength);
            }
            ++i2;
        }
        if (containsEmptyTask) {
            i2 = foundTaskIndex;
            while (i2 < tasks.size()) {
                Task task1 = tasks.get(i2);
                if (task1.message.length() == 0) {
                    int j = i2 + 1;
                    while (j < tasks.size()) {
                        Task task2 = tasks.get(j);
                        if (task2.message.length() != 0) {
                            task1.message = task2.message;
                            task1.end = task2.end;
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        i2 = foundTaskIndex;
        while (i2 < tasks.size()) {
            Task task;
            Task task2 = task = tasks.get(i2);
            task2.lineNumber = task2.lineNumber + TodoTaskParser.getLineOffset(comment, task.start);
            Task task3 = task;
            task3.start = task3.start + offset;
            Task task4 = task;
            task4.end = task4.end + offset;
            ++i2;
        }
    }

    private static int getLineOffset(char[] buffer, int pos) {
        int count = 0;
        int i = 0;
        while (i < pos && i < buffer.length) {
            if (buffer[i] == '\n') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static boolean isIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || Character.isUnicodeIdentifierPart(c);
    }

    private static boolean isIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9' || Character.isUnicodeIdentifierPart(c);
    }

    public static class Task {
        private String fileLocation;
        private int start;
        private int end;
        private int lineNumber;
        private String tag;
        private String message;
        private int priority;

        Task(String fileLocation, int start, int end, int lineNumber, String tag, String message, int priority) {
            this.fileLocation = fileLocation;
            this.start = start;
            this.end = end;
            this.lineNumber = lineNumber;
            this.tag = tag;
            this.message = message;
            this.priority = priority;
        }

        public String getFileLocation() {
            return this.fileLocation;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getTag() {
            return this.tag;
        }

        public String getMessage() {
            return this.message;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

