/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.List;
import java.util.concurrent.Semaphore;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSelector;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.index.IndexBasedFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner.ISkippedIndexedFilesListener;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.core.runtime.CoreException;

public abstract class ASTTranslationUnit
extends ASTNode
implements IASTTranslationUnit,
ISkippedIndexedFilesListener {
    private static final IASTPreprocessorStatement[] EMPTY_PREPROCESSOR_STATEMENT_ARRAY = new IASTPreprocessorStatement[0];
    private static final IASTPreprocessorMacroDefinition[] EMPTY_PREPROCESSOR_MACRODEF_ARRAY = new IASTPreprocessorMacroDefinition[0];
    private static final IASTPreprocessorIncludeStatement[] EMPTY_PREPROCESSOR_INCLUSION_ARRAY = new IASTPreprocessorIncludeStatement[0];
    private static final IASTProblem[] EMPTY_PROBLEM_ARRAY = new IASTProblem[0];
    private static final String EMPTY_STRING = "";
    private IASTDeclaration[] fAllDeclarations;
    private IASTDeclaration[] fActiveDeclarations;
    private int fLastDeclaration = -1;
    protected ILocationResolver fLocationResolver;
    private IIndex fIndex;
    private boolean fIsHeader = true;
    private IIndexFileSet fIndexFileSet;
    private IIndexFileSet fASTFileSet;
    private INodeFactory fNodeFactory;
    private boolean fForContentAssist;
    private ITranslationUnit fOriginatingTranslationUnit;
    private ISignificantMacros fSignificantMacros = ISignificantMacros.NONE;
    private boolean fPragmaOnceSemantics;
    private SizeofCalculator fSizeofCalculator;
    private final Semaphore fSemaphore = new Semaphore(1);
    private boolean fBasedOnIncompleteIndex;

    @Override
    public final IASTTranslationUnit getTranslationUnit() {
        return this;
    }

    @Override
    public final void addDeclaration(IASTDeclaration d) {
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(OWNED_DECLARATION);
            this.fAllDeclarations = ArrayUtil.appendAt(IASTDeclaration.class, this.fAllDeclarations, ++this.fLastDeclaration, d);
            this.fActiveDeclarations = null;
        }
    }

    @Override
    public final IASTDeclaration[] getDeclarations() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fLastDeclaration + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    @Override
    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = ArrayUtil.trimAt(IASTDeclaration.class, this.fAllDeclarations, this.fLastDeclaration);
            return this.fAllDeclarations;
        }
        return this.getDeclarations();
    }

    public final void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fLastDeclaration) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
    }

    @Override
    public final IName[] getDeclarations(IBinding binding) {
        IName[] names = this.getDeclarationsInAST(binding);
        if (names.length == 0 && this.fIndex != null) {
            try {
                names = this.fIndex.findDeclarations(binding);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return names;
            }
        }
        return names;
    }

    protected final IASTName[] getMacroDefinitionsInAST(IMacroBinding binding) {
        if (this.fLocationResolver == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        return this.fLocationResolver.getDeclarations(binding);
    }

    protected final IASTName[] getMacroReferencesInAST(IMacroBinding binding) {
        if (this.fLocationResolver == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        return this.fLocationResolver.getReferences(binding);
    }

    @Override
    public final IName[] getDefinitions(IBinding binding) {
        IName[] names = this.getDefinitionsInAST(binding);
        if (names.length == 0 && this.fIndex != null) {
            try {
                names = this.fIndex.findDefinitions(binding);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return names;
            }
        }
        return names;
    }

    @Override
    public final IASTPreprocessorMacroDefinition[] getMacroDefinitions() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_MACRODEF_ARRAY;
        }
        return this.fLocationResolver.getMacroDefinitions();
    }

    @Override
    public IASTPreprocessorMacroExpansion[] getMacroExpansions() {
        if (this.fLocationResolver == null) {
            return IASTPreprocessorMacroExpansion.EMPTY_ARRAY;
        }
        return this.fLocationResolver.getMacroExpansions(this.getFileLocation());
    }

    @Override
    public final IASTPreprocessorMacroDefinition[] getBuiltinMacroDefinitions() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_MACRODEF_ARRAY;
        }
        return this.fLocationResolver.getBuiltinMacroDefinitions();
    }

    @Override
    public final IASTPreprocessorIncludeStatement[] getIncludeDirectives() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_INCLUSION_ARRAY;
        }
        return this.fLocationResolver.getIncludeDirectives();
    }

    @Override
    public final IASTPreprocessorStatement[] getAllPreprocessorStatements() {
        if (this.fLocationResolver == null) {
            return EMPTY_PREPROCESSOR_STATEMENT_ARRAY;
        }
        return this.fLocationResolver.getAllPreprocessorStatements();
    }

    public final void setLocationResolver(ILocationResolver resolver) {
        this.fLocationResolver = resolver;
        resolver.setRootNode(this);
    }

    @Override
    public final IASTProblem[] getPreprocessorProblems() {
        if (this.fLocationResolver == null) {
            return EMPTY_PROBLEM_ARRAY;
        }
        IASTProblem[] result = this.fLocationResolver.getScannerProblems();
        int i = 0;
        while (i < result.length) {
            IASTProblem p = result[i];
            p.setParent(this);
            p.setPropertyInParent(IASTTranslationUnit.SCANNER_PROBLEM);
            ++i;
        }
        return result;
    }

    @Override
    public final int getPreprocessorProblemsCount() {
        return this.fLocationResolver == null ? 0 : this.fLocationResolver.getScannerProblemsCount();
    }

    @Override
    public final String getFilePath() {
        if (this.fLocationResolver == null) {
            return EMPTY_STRING;
        }
        return new String(this.fLocationResolver.getTranslationUnitPath());
    }

    @Override
    public final boolean accept(ASTVisitor action) {
        IASTDeclaration[] decls;
        if (action.shouldVisitTranslationUnit) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTDeclaration[] iASTDeclarationArray = decls = this.getDeclarations(action.includeInactiveNodes);
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (!decl.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitTranslationUnit || action.leave(this) != 2;
    }

    @Override
    public final IASTFileLocation flattenLocationsToFile(IASTNodeLocation[] nodeLocations) {
        if (this.fLocationResolver == null) {
            return null;
        }
        return this.fLocationResolver.flattenLocations(nodeLocations);
    }

    @Override
    public final IASTTranslationUnit.IDependencyTree getDependencyTree() {
        if (this.fLocationResolver == null) {
            return null;
        }
        return this.fLocationResolver.getDependencyTree();
    }

    @Override
    public final String getContainingFilename(int offset) {
        if (this.fLocationResolver == null) {
            return EMPTY_STRING;
        }
        return this.fLocationResolver.getContainingFilePath(offset);
    }

    @Override
    public final IIndex getIndex() {
        return this.fIndex;
    }

    @Override
    public final void setIndex(IIndex index) {
        this.fIndex = index;
        if (index != null) {
            this.fIndexFileSet = index.createFileSet();
            this.fASTFileSet = index.createFileSet();
        }
    }

    @Override
    public final INodeFactory getASTNodeFactory() {
        return this.fNodeFactory;
    }

    public final void setASTNodeFactory(INodeFactory nodeFactory) {
        this.fNodeFactory = nodeFactory;
    }

    @Override
    public final IASTComment[] getComments() {
        if (this.fLocationResolver != null) {
            return this.fLocationResolver.getComments();
        }
        return new IASTComment[0];
    }

    public final Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.fLocationResolver.getClass())) {
            return this.fLocationResolver;
        }
        if (adapter.isAssignableFrom(IIndexFileSet.class)) {
            return this.fIndexFileSet;
        }
        if (adapter.isAssignableFrom(Lexer.LexerOptions.class)) {
            return this.fLocationResolver.getLexerOptions();
        }
        return null;
    }

    @Override
    public final boolean isHeaderUnit() {
        return this.fIsHeader;
    }

    @Override
    public final void setIsHeaderUnit(boolean headerUnit) {
        this.fIsHeader = headerUnit;
    }

    public boolean isForContentAssist() {
        return this.fForContentAssist;
    }

    public final void setIsForContentAssist(boolean forContentAssist) {
        this.fForContentAssist = forContentAssist;
    }

    @Override
    public boolean isBasedOnIncompleteIndex() {
        return this.fBasedOnIncompleteIndex;
    }

    public void setBasedOnIncompleteIndex(boolean basedOnIncompleteIndex) {
        this.fBasedOnIncompleteIndex = basedOnIncompleteIndex;
    }

    @Override
    public void skippedFile(int offset, InternalFileContent fileContent) {
        if (this.fIndexFileSet != null) {
            List<IIndexFile> files = fileContent.getFilesIncluded();
            for (IIndexFile indexFile : files) {
                this.fASTFileSet.remove(indexFile);
                this.fIndexFileSet.add(indexFile);
            }
        }
    }

    @Override
    public final IIndexFileSet getIndexFileSet() {
        return this.fIndexFileSet;
    }

    @Override
    public void parsingFile(InternalFileContentProvider provider, InternalFileContent fc) {
        if (this.fASTFileSet != null && provider instanceof IndexBasedFileContentProvider) {
            try {
                IIndexFile[] iIndexFileArray = ((IndexBasedFileContentProvider)provider).findIndexFiles(fc);
                int n = iIndexFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IIndexFile file = iIndexFileArray[n2];
                    if (!this.fIndexFileSet.contains(file)) {
                        this.fASTFileSet.add(file);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public final IIndexFileSet getASTFileSet() {
        return this.fASTFileSet;
    }

    @Override
    public final IASTNode selectNodeForLocation(String path, int realOffset, int realLength) {
        return this.getNodeSelector(path).findNode(realOffset, realLength);
    }

    @Override
    public final IASTNodeSelector getNodeSelector(String filePath) {
        return new ASTNodeSelector(this, this.fLocationResolver, filePath);
    }

    public abstract void resolveAmbiguities();

    protected abstract IType createType(IASTTypeId var1);

    protected void copyAbstractTU(ASTTranslationUnit copy, IASTNode.CopyStyle style) {
        copy.setIndex(this.fIndex);
        copy.fIsHeader = this.fIsHeader;
        copy.fNodeFactory = this.fNodeFactory;
        copy.setLocationResolver(this.fLocationResolver);
        copy.fForContentAssist = this.fForContentAssist;
        copy.fOriginatingTranslationUnit = this.fOriginatingTranslationUnit;
        IASTDeclaration[] iASTDeclarationArray = this.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            copy.addDeclaration(declaration == null ? null : declaration.copy(style));
            ++n2;
        }
        copy.setOffsetAndLength(this);
    }

    @Override
    public final void freeze() {
        this.accept(new ASTGenericVisitor(true){

            @Override
            protected int genericVisit(IASTNode node) {
                ((ASTNode)node).setIsFrozen();
                return 3;
            }
        });
    }

    @Override
    public ITranslationUnit getOriginatingTranslationUnit() {
        return this.fOriginatingTranslationUnit;
    }

    public void setOriginatingTranslationUnit(ITranslationUnit tu) {
        this.fOriginatingTranslationUnit = tu;
    }

    @Override
    public ISignificantMacros getSignificantMacros() {
        return this.fSignificantMacros;
    }

    @Override
    public void setSignificantMacros(ISignificantMacros sigMacros) {
        this.assertNotFrozen();
        if (sigMacros != null) {
            this.fSignificantMacros = sigMacros;
        }
    }

    @Override
    public boolean hasPragmaOnceSemantics() {
        return this.fPragmaOnceSemantics;
    }

    @Override
    public void setPragmaOnceSemantics(boolean value) {
        this.assertNotFrozen();
        this.fPragmaOnceSemantics = value;
    }

    public void beginExclusiveAccess() throws InterruptedException {
        this.fSemaphore.acquire();
    }

    public void endExclusiveAccess() {
        this.fSemaphore.release();
    }

    public SizeofCalculator getSizeofCalculator() {
        if (this.fSizeofCalculator == null) {
            this.fSizeofCalculator = new SizeofCalculator(this);
        }
        return this.fSizeofCalculator;
    }

    public static int getNodeOffset(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return -1;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getNodeOffset() : -1;
    }

    public static int getNodeEndOffset(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return -1;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getNodeOffset() + nodeLocation.getNodeLength() : -1;
    }

    public static int getStartingLineNumber(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return 0;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getStartingLineNumber() : 0;
    }

    public static int getEndingLineNumber(IASTNode node) {
        if (!node.isPartOfTranslationUnitFile()) {
            return 0;
        }
        IASTFileLocation nodeLocation = node.getFileLocation();
        return nodeLocation != null ? nodeLocation.getEndingLineNumber() : 0;
    }
}

