/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

public class TreeDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TreeDragSourceEffect(Tree tree) {
        super(tree);
    }

    public void dragFinished(DragSourceEvent event) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent event) {
        event.image = this.getDragSourceImage(event);
    }

    Image getDragSourceImage(DragSourceEvent event) {
        int[] model;
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Tree tree = (Tree)this.control;
        if (tree.isListening(40) || tree.isListening(42)) {
            return null;
        }
        int handle = tree.handle;
        int selection = OS.gtk_tree_view_get_selection(handle);
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model = null);
        if (list == 0) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        Display display = tree.getDisplay();
        if (count == 1) {
            int path = OS.g_list_nth_data(list, 0);
            int icon = OS.gtk_tree_view_create_row_drag_icon(handle, path);
            this.dragSourceImage = Image.gtk_new(display, 1, icon, 0);
            OS.gtk_tree_path_free(path);
        } else {
            int width = 0;
            int height = 0;
            int[] w = new int[1];
            int[] h = new int[1];
            int[] yy = new int[count];
            int[] hh = new int[count];
            int[] icons = new int[count];
            GdkRectangle rect = new GdkRectangle();
            for (int i = 0; i < count; ++i) {
                int path = OS.g_list_nth_data(list, i);
                OS.gtk_tree_view_get_cell_area(handle, path, 0, rect);
                icons[i] = OS.gtk_tree_view_create_row_drag_icon(handle, path);
                if (OS.GTK3) {
                    w[0] = Cairo.cairo_xlib_surface_get_width(icons[i]);
                    h[0] = Cairo.cairo_xlib_surface_get_height(icons[i]);
                } else if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
                    OS.gdk_pixmap_get_size(icons[i], w, h);
                } else {
                    OS.gdk_drawable_get_size(icons[i], w, h);
                }
                width = Math.max(width, w[0]);
                height = rect.y + h[0] - yy[0];
                yy[i] = rect.y;
                hh[i] = h[0];
                OS.gtk_tree_path_free(path);
            }
            if (OS.GTK3) {
                int cairo;
                int surface = Cairo.cairo_image_surface_create(0, width, height);
                if (surface == 0) {
                    SWT.error(2);
                }
                if ((cairo = Cairo.cairo_create(surface)) == 0) {
                    SWT.error(2);
                }
                Cairo.cairo_set_operator(cairo, 1);
                for (int i = 0; i < count; ++i) {
                    Cairo.cairo_set_source_surface(cairo, icons[i], 2.0, yy[i] - yy[0] + 2);
                    Cairo.cairo_rectangle(cairo, 0.0, yy[i] - yy[0], width, hh[i]);
                    Cairo.cairo_fill(cairo);
                    Cairo.cairo_surface_destroy(icons[i]);
                }
                Cairo.cairo_destroy(cairo);
                this.dragSourceImage = Image.gtk_new(display, 1, surface, 0);
            } else {
                int source = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, -1);
                int gcSource = OS.gdk_gc_new(source);
                int mask = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), width, height, 1);
                int gcMask = OS.gdk_gc_new(mask);
                GdkColor color = new GdkColor();
                color.pixel = 0;
                OS.gdk_gc_set_foreground(gcMask, color);
                OS.gdk_draw_rectangle(mask, gcMask, 1, 0, 0, width, height);
                color.pixel = 1;
                OS.gdk_gc_set_foreground(gcMask, color);
                for (int i = 0; i < count; ++i) {
                    OS.gdk_draw_drawable(source, gcSource, icons[i], 0, 0, 0, yy[i] - yy[0], -1, -1);
                    OS.gdk_draw_rectangle(mask, gcMask, 1, 0, yy[i] - yy[0], width, hh[i]);
                    OS.g_object_unref(icons[i]);
                }
                OS.g_object_unref(gcSource);
                OS.g_object_unref(gcMask);
                this.dragSourceImage = Image.gtk_new(display, 1, source, mask);
            }
        }
        OS.g_list_free(list);
        return this.dragSourceImage;
    }
}

